/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class LittleActionInteract
extends LittleAction {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;
    public boolean secondMode;
    public UUID uuid;

    public LittleActionInteract(World world, BlockPos blockPos, EntityPlayer player) {
        this.blockPos = blockPos;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.secondMode = LittleActionInteract.isUsingSecondMode(player);
        if (world instanceof CreativeWorld) {
            this.uuid = ((CreativeWorld)world).parent.func_110124_au();
        }
    }

    public LittleActionInteract() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleActionInteract.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleActionInteract.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleActionInteract.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeBoolean(this.secondMode);
        if (this.uuid != null) {
            buf.writeBoolean(true);
            LittleActionInteract.writeString((ByteBuf)buf, (String)this.uuid.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleActionInteract.readPos((ByteBuf)buf);
        this.pos = LittleActionInteract.readVec3d((ByteBuf)buf);
        this.look = LittleActionInteract.readVec3d((ByteBuf)buf);
        this.secondMode = buf.readBoolean();
        this.uuid = buf.readBoolean() ? UUID.fromString(LittleActionInteract.readString((ByteBuf)buf)) : null;
    }

    protected abstract boolean isRightClick();

    protected abstract boolean action(World var1, TileEntityLittleTiles var2, LittleTile var3, ItemStack var4, EntityPlayer var5, RayTraceResult var6, BlockPos var7, boolean var8) throws LittleActionException;

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        TileEntity tileEntity;
        World world = player.field_70170_p;
        Vec3d pos = this.pos;
        Vec3d look = this.look;
        if (this.uuid != null) {
            EntityAnimation animation = LittleDoorHandler.getHandler(player.field_70170_p.field_72995_K).findDoor(this.uuid);
            if (animation == null) {
                this.onEntityNotFound();
            }
            if (!LittleActionInteract.isAllowedToInteract(player, animation, this.isRightClick())) {
                LittleActionInteract.sendEntityResetToClient((EntityPlayerMP)player, animation);
                return false;
            }
            world = animation.fakeWorld;
            pos = animation.origin.transformPointToFakeWorld(pos);
            look = animation.origin.transformPointToFakeWorld(look);
        }
        if ((tileEntity = world.func_175625_s(this.blockPos)) instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            LittleTile tile = te.getFocusedTile(pos, look);
            if (!LittleActionInteract.isAllowedToInteract(world, player, this.blockPos, this.isRightClick(), EnumFacing.EAST)) {
                LittleActionInteract.sendBlockResetToClient(world, (EntityPlayerMP)player, te);
                return false;
            }
            if (tile != null) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                RayTraceResult moving = this.rayTrace(te, tile, pos, look);
                if (moving != null) {
                    return this.action(world, te, tile, stack, player, moving, this.blockPos, this.secondMode);
                }
            } else {
                this.onTileNotFound();
            }
        } else {
            this.onTileEntityNotFound();
        }
        return false;
    }

    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile, Vec3d pos, Vec3d look) {
        return te.rayTrace(pos, look);
    }

    protected void onEntityNotFound() throws LittleActionException {
        throw new LittleActionException.EntityNotFoundException();
    }

    protected void onTileNotFound() throws LittleActionException {
        throw new LittleActionException.TileNotFoundException();
    }

    protected void onTileEntityNotFound() throws LittleActionException {
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

