/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.ColorIngredient;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import com.creativemd.littletiles.common.utils.ingredients.LittleInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LittleActionSaw
extends LittleActionInteract {
    public boolean toLimit;
    public LittleGridContext context;
    public LittleTileBox oldBox = null;
    public LittleBoxes newBoxes;
    public LittleTileIdentifierAbsolute coord = null;
    public EnumFacing facing;

    public LittleActionSaw(World world, BlockPos blockPos, EntityPlayer player, boolean toLimit, LittleGridContext context) {
        super(world, blockPos, player);
        this.toLimit = toLimit;
        this.context = context;
    }

    public LittleActionSaw() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile, Vec3d pos, Vec3d look) {
        return new LittleTileBox(tile.box).calculateIntercept(te.getContext(), te.func_174877_v(), pos, look);
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        this.facing = moving.field_178784_b;
        if (tile.canSawResizeTile(this.facing, player)) {
            LittleTileBox box;
            EnumFacing.Axis axis = this.facing.func_176740_k();
            te.ensureMinContext(this.context);
            if (this.context != te.getContext()) {
                this.context = te.getContext();
            }
            this.oldBox = tile.box.copy();
            boolean outside = false;
            if (secondMode) {
                box = tile.box.shrink(this.facing, this.toLimit);
            } else {
                box = tile.box.grow(this.facing);
                if (tile.box.isFaceAtEdge(te.getContext(), this.facing)) {
                    BlockPos newPos = te.func_174877_v().func_177972_a(this.facing);
                    if ((box = box.createOutsideBlockBox(te.getContext(), this.facing)) == null) {
                        return false;
                    }
                    LittleGridContext context = LittleGridContext.get(box.getSmallestContext(te.getContext()));
                    te = LittleActionSaw.loadTe(player, world, newPos, false);
                    if (te == null) {
                        return false;
                    }
                    if (context != te.getContext()) {
                        if (context.size > te.getContext().size) {
                            te.ensureMinContext(context);
                        } else {
                            box.convertTo(context, te.getContext());
                        }
                    }
                    outside = true;
                }
                if (this.toLimit) {
                    LittleTileBox before = null;
                    while (!box.isFaceAtEdge(te.getContext(), this.facing) && te.isSpaceForLittleTileIgnore(box, tile)) {
                        before = box;
                        box = box.grow(this.facing);
                    }
                    if (!te.isSpaceForLittleTileIgnore(box, tile)) {
                        box = before;
                    }
                } else if (!te.isSpaceForLittleTileIgnore(box, tile)) {
                    box = null;
                }
            }
            if (box != null) {
                double amount = outside ? box.getPercentVolume(te.getContext()) : Math.abs(box.getPercentVolume(te.getContext()) - tile.box.getPercentVolume(te.getContext()));
                LittleIngredients ingredients = new LittleIngredients();
                LittleInventory inventory = new LittleInventory(player);
                BlockIngredient blocks = new BlockIngredient();
                LittleTilePreview preview = tile.getPreviewTile();
                BlockIngredientEntry block = preview.getBlockIngredient(te.getContext());
                if (block != null) {
                    block.value = amount;
                    blocks.add(block);
                    ingredients.set(blocks.getClass(), blocks);
                    ColorIngredient unit = null;
                    if (preview.hasColor()) {
                        unit = ColorIngredient.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                        ingredients.set(unit.getClass(), unit);
                    }
                    if (secondMode) {
                        LittleActionSaw.give(player, inventory, ingredients);
                    } else {
                        LittleActionSaw.take(player, inventory, ingredients);
                    }
                }
                if (outside) {
                    LittleTile newTile = tile.copy();
                    newTile.box = box;
                    newTile.te = te;
                    te.updateTiles(x -> newTile.place((TileList)x));
                    te.updateBlock();
                    this.newBoxes = new LittleBoxes(te.func_174877_v(), te.getContext());
                    this.newBoxes.addBox(newTile);
                    te.convertToSmallest();
                    return true;
                }
                tile.box = box;
                te.updateBlock();
                this.coord = new LittleTileIdentifierAbsolute(tile);
                te.convertToSmallest();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        if (this.newBoxes != null) {
            return new LittleActionDestroyBoxes(this.newBoxes);
        }
        return new LittleActionSawRevert(this.context, this.coord, this.oldBox, this.facing);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeBoolean(this.toLimit);
        LittleActionSaw.writeContext(this.context, buf);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toLimit = buf.readBoolean();
        this.context = LittleActionSaw.readContext(buf);
    }

    public static class LittleActionSawRevert
    extends LittleAction {
        public LittleTileBox oldBox;
        public LittleTileBox replacedBox;
        public LittleTileIdentifierAbsolute coord;
        public LittleTileIdentifierAbsolute newCoord;
        public EnumFacing facing;
        public LittleGridContext context;

        public LittleActionSawRevert(LittleGridContext context, LittleTileIdentifierAbsolute coord, LittleTileBox oldBox, EnumFacing facing) {
            this.coord = coord;
            this.oldBox = oldBox;
            this.facing = facing;
            this.context = context;
        }

        public LittleActionSawRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert() throws LittleActionException {
            return new LittleActionSawRevert(this.context, this.newCoord, this.replacedBox, this.facing.func_176734_d());
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            LittleTile tile = LittleActionSawRevert.getTile(player.field_70170_p, this.coord);
            if (tile.canSawResizeTile(this.facing, player)) {
                tile.te.ensureMinContext(this.context);
                if (tile.getContext() != this.context) {
                    this.oldBox.convertTo(this.context, tile.getContext());
                    this.context = tile.getContext();
                }
                double amount = Math.abs(this.oldBox.getPercentVolume(this.context) - tile.box.getPercentVolume(tile.getContext()));
                LittleTilePreview preview = tile.getPreviewTile();
                LittleIngredients ingredients = new LittleIngredients();
                BlockIngredient blocks = new BlockIngredient();
                BlockIngredientEntry block = preview.getBlockIngredient(tile.getContext());
                if (block != null) {
                    LittleInventory inventory = new LittleInventory(player);
                    block.value = amount;
                    blocks.add(block);
                    ingredients.set(blocks.getClass(), blocks);
                    ColorIngredient unit = null;
                    if (preview.hasColor()) {
                        unit = ColorIngredient.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                        ingredients.set(unit.getClass(), unit);
                    }
                    if (this.oldBox.getVolume() < tile.box.getVolume()) {
                        LittleActionSawRevert.give(player, inventory, ingredients);
                    } else {
                        LittleActionSawRevert.take(player, inventory, ingredients);
                    }
                }
                this.replacedBox = tile.box.copy();
                tile.box = this.oldBox.copy();
                tile.te.convertToSmallest();
                tile.te.updateBlock();
                this.newCoord = new LittleTileIdentifierAbsolute(tile);
                return true;
            }
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionSawRevert.writeAbsoluteCoord(this.coord, buf);
            LittleActionSawRevert.writeLittleBox(this.oldBox, buf);
            LittleActionSawRevert.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
            LittleActionSawRevert.writeContext(this.context, buf);
        }

        public void readBytes(ByteBuf buf) {
            this.coord = LittleActionSawRevert.readAbsoluteCoord(buf);
            this.oldBox = LittleActionSawRevert.readLittleBox(buf);
            this.facing = LittleActionSawRevert.readFacing((ByteBuf)buf);
            this.context = LittleActionSawRevert.readContext(buf);
        }
    }
}

