/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerHeldItem;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.client.gui.controls.SlotControlBlockIngredient;
import com.creativemd.littletiles.common.items.ItemBag;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.ColorIngredient;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerBag
extends SubContainerHeldItem {
    public LittleIngredients bag;
    public InventoryBasic bagInventory;

    public SubContainerBag(EntityPlayer player, ItemStack stack, int index) {
        super(player, stack, index);
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        if (event.source instanceof SlotControl) {
            ItemStack input;
            LittleIngredients ingredients;
            if (event.source instanceof SlotControlBlockIngredient) {
                SlotControlBlockIngredient slot = (SlotControlBlockIngredient)event.source;
                if (slot.slot.func_75211_c().func_190926_b()) {
                    slot.ingredient = null;
                } else if (slot.ingredient != null) {
                    slot.ingredient.value = (double)slot.slot.func_75211_c().func_190916_E() / (double)LittleGridContext.get().maxTilesPerBlock;
                }
                BlockIngredient blocks = new BlockIngredient().setLimits(ItemBag.inventorySize, ItemBag.maxStackSize);
                for (int y = 0; y < ItemBag.inventoryHeight; ++y) {
                    for (int x = 0; x < ItemBag.inventoryWidth; ++x) {
                        int index = x + y * ItemBag.inventoryWidth;
                        BlockIngredientEntry ingredient = ((SlotControlBlockIngredient)this.get((String)new StringBuilder().append((String)"item").append((int)index).toString())).ingredient;
                        if (ingredient == null) continue;
                        blocks.add(ingredient);
                    }
                }
                this.bag.set(blocks.getClass(), blocks);
                ((ItemBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag);
                this.reloadControls();
            } else if (event.source.name.startsWith("input") && (ingredients = LittleIngredient.extractWithoutCount(input = ((SlotControl)event.source).slot.func_75211_c(), true)) != null) {
                ingredients.scale(input.func_190916_E());
                if (this.bag.add(ingredients) == null) {
                    ((ItemBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag);
                    if (ingredients.contains(BlockIngredient.class)) {
                        this.updateSlots();
                        this.player.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
                    }
                    if (ingredients.contains(ColorIngredient.class)) {
                        this.reloadControls();
                        this.player.func_184185_a(SoundEvents.field_187621_J, 1.0f, 1.0f);
                    }
                } else {
                    this.bag = ((ItemBag)this.stack.func_77973_b()).getInventory(this.stack);
                }
            }
        }
    }

    public void reloadControls() {
        this.controls.clear();
        this.createControls();
        this.refreshControls();
        NBTTagCompound nbt = this.stack.func_77978_p().func_74737_b();
        nbt.func_74757_a("reload", true);
        this.sendNBTToGui(nbt);
    }

    public void updateSlots() {
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        for (int y = 0; y < ItemBag.inventoryHeight; ++y) {
            for (int x = 0; x < ItemBag.inventoryWidth; ++x) {
                int index;
                this.bagInventory.func_70299_a(index, (index = x + y * ItemBag.inventoryWidth) < inventory.size() ? inventory.get(index).getTileItemStack() : ItemStack.field_190927_a);
                ((SlotControlBlockIngredient)this.get((String)new StringBuilder().append((String)"item").append((int)index).toString())).ingredient = index < inventory.size() ? inventory.get(index) : null;
            }
        }
    }

    public void createControls() {
        this.bag = ((ItemBag)this.stack.func_77973_b()).getInventory(this.stack);
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        this.bagInventory = new InventoryBasic("item", false, ItemBag.inventorySize){

            public int func_70297_j_() {
                return ItemBag.maxStackSizeOfTiles;
            }
        };
        for (int y = 0; y < ItemBag.inventoryHeight; ++y) {
            for (int x = 0; x < ItemBag.inventoryWidth; ++x) {
                int index;
                this.bagInventory.func_70299_a(index, (index = x + y * ItemBag.inventoryWidth) < inventory.size() ? inventory.get(index).getTileItemStack() : ItemStack.field_190927_a);
                this.controls.add(new SlotControlBlockIngredient(new Slot((IInventory)this.bagInventory, index, 5 + x * 18, 5 + y * 18){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }
                }, index < inventory.size() ? inventory.get(index) : null));
            }
        }
        InventoryBasic input = new InventoryBasic("input", false, 1);
        this.addSlotToContainer(new Slot((IInventory)input, 0, 120, 5));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onClosed() {
        ItemStack stack = ((SlotControl)this.get((String)"input0")).slot.func_75211_c();
        if (!stack.func_190926_b()) {
            WorldUtils.dropItem((EntityPlayer)this.player, (ItemStack)stack);
        }
    }

    public void onPacketReceive(NBTTagCompound nbt) {
    }
}

