/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.slots.SlotStackLimit;
import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.littletiles.common.structure.type.LittleStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerStorage
extends SubContainer {
    public LittleStorage storage;
    public final StorageSize size;

    public SubContainerStorage(EntityPlayer player, LittleStorage storage) {
        super(player);
        this.storage = storage;
        this.size = StorageSize.getSizeFromInventory(storage.inventory);
        if (!player.field_70170_p.field_72995_K) {
            this.storage.openContainers.add(this);
        }
    }

    public void createControls() {
        if (this.storage.inventory != null) {
            int slotsPerRow = this.size.width / 18;
            int rows = (int)Math.ceil((double)this.storage.inventory.func_70302_i_() / (double)slotsPerRow);
            int rowWidth = Math.min(slotsPerRow, this.storage.inventory.func_70302_i_()) * 18;
            int offsetX = (this.size.width - rowWidth) / 2;
            for (int i = 0; i < this.storage.inventory.func_70302_i_(); ++i) {
                int row = i / slotsPerRow;
                int rowIndex = i - row * slotsPerRow;
                int stackSize = this.storage.stackSizeLimit;
                if (i + 1 == this.storage.numberOfSlots && this.storage.lastSlotStackSize > 0) {
                    stackSize = this.storage.lastSlotStackSize;
                }
                this.addSlotToContainer((Slot)new SlotStackLimit(this.storage.inventory, i, offsetX + rowIndex * 18, 5 + row * 18, stackSize));
            }
            this.addPlayerSlotsToContainer(this.player, this.size.playerOffsetX, this.size.playerOffsetY);
        }
    }

    public void writeOpeningNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)InventoryUtils.saveInventoryBasic((IInventory)this.storage.inventory));
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        if (nbt.func_74764_b("inventory")) {
            ItemStack[] stacks = InventoryUtils.loadInventory((NBTTagCompound)nbt.func_74775_l("inventory"));
            for (int i = 0; i < stacks.length; ++i) {
                this.storage.inventory.func_70299_a(i, stacks[i]);
            }
        }
        if (nbt.func_74767_n("sort")) {
            InventoryUtils.sortInventory((IInventory)this.storage.inventory, (boolean)false);
            NBTTagCompound packet = new NBTTagCompound();
            packet.func_74782_a("inventory", (NBTBase)InventoryUtils.saveInventoryBasic((IInventory)this.storage.inventory));
            this.sendNBTUpdate(packet);
        }
    }

    public void onClosed() {
        super.onClosed();
        if (this.storage != null && !this.player.field_70170_p.field_72995_K) {
            this.storage.openContainers.remove((Object)this);
        }
    }

    public static enum StorageSize {
        SMALL(176, 166, 8, 84, false),
        Large(250, 250, 45, 170, false),
        INFINITE(250, 250, 45, 170, true);

        public final int height;
        public final int width;
        public final int playerOffsetX;
        public final int playerOffsetY;
        public final boolean scrollbox;

        private StorageSize(int width, int height, int playerOffsetX, int playerOffsetY, boolean scrollbox) {
            this.scrollbox = scrollbox;
            this.height = height;
            this.width = width;
            this.playerOffsetX = playerOffsetX;
            this.playerOffsetY = playerOffsetY;
        }

        public static StorageSize getSizeFromInventory(IInventory inventory) {
            if (inventory.func_70302_i_() <= 27) {
                return SMALL;
            }
            if (inventory.func_70302_i_() <= 117) {
                return Large;
            }
            return INFINITE;
        }
    }
}

