/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.packet.LittlePlacedAnimationPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationController;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.vec.LittleTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DoorController
extends EntityAnimationController {
    protected boolean isWaitingForApprove = false;
    protected int ticksToWait = -1;
    protected static final int waitTimeApprove = 300;
    protected static final int waitTimeRender = 200;
    protected Boolean placed = null;
    public static final String openedState = "opened";
    public static final String closedState = "closed";
    public Boolean turnBack;
    public int duration;
    public int completeDuration;
    public EntityPlayer activator;
    public LittleDoor.DoorOpeningResult result;
    public UUIDSupplier supplier;
    public boolean serverPlaced = false;
    protected boolean modifiedTransition;
    @SideOnly(value=Side.CLIENT)
    List<TileEntityLittleTiles> waitingForRender;

    public DoorController() {
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState closed, AnimationState opened, Boolean turnBack, int duration, int completeDuration) {
        this.result = result;
        this.supplier = supplier;
        this.turnBack = turnBack;
        this.duration = duration;
        this.completeDuration = completeDuration;
        this.addState(openedState, opened);
        this.addStateAndSelect(closedState, closed);
        this.generateAllTransistions(duration);
        this.modifiedTransition = false;
        this.stretchTransitions();
        this.startTransition(openedState);
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState closed, AnimationState opened, Boolean turnBack, int duration, int completeDuration, AnimationTimeline open, AnimationTimeline close) {
        this.result = result;
        this.supplier = supplier;
        this.turnBack = turnBack;
        this.duration = duration;
        this.completeDuration = completeDuration;
        this.addState(openedState, opened);
        this.addStateAndSelect(closedState, closed);
        this.addTransition(closedState, openedState, open);
        this.addTransition(openedState, closedState, close);
        this.stretchTransitions();
        this.startTransition(openedState);
    }

    @Override
    public AnimationController addTransition(String from, String to, AnimationTimeline animation) {
        this.modifiedTransition = true;
        return super.addTransition(from, to, animation);
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState opened, Boolean turnBack, int duration, int completeDuration) {
        this(result, supplier, new AnimationState(), opened, turnBack, duration, completeDuration);
    }

    protected void stretchTransitions() {
        this.completeDuration = Math.max(this.completeDuration, this.duration);
        for (AnimationTimeline timeline : this.stateTransition.values()) {
            timeline.duration = this.completeDuration;
        }
    }

    @Override
    public EntityPlayer activator() {
        return this.activator;
    }

    public void markWaitingForApprove() {
        this.isWaitingForApprove = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void removeWaitingTe(TileEntityLittleTiles te) {
        if (!this.isWaitingForRender()) {
            return;
        }
        List<TileEntityLittleTiles> list = this.waitingForRender;
        synchronized (list) {
            this.waitingForRender.remove(te);
            if (this.waitingForRender.isEmpty()) {
                this.parent.field_70128_L = true;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWaitingForRender() {
        return this.waitingForRender != null;
    }

    public boolean activate() {
        if (this.placed != null) {
            return false;
        }
        boolean isOpen = this.currentState.name.equals(openedState);
        if (!this.isChanging()) {
            this.startTransition(isOpen ? closedState : openedState);
            return true;
        }
        return false;
    }

    @Override
    public AnimationState tick() {
        if (this.parent.field_70170_p.field_72995_K && this.placed != null) {
            if (this.placed.booleanValue()) {
                --this.ticksToWait;
                if (this.waitingForRender.size() == 0 || this.ticksToWait < 0) {
                    this.parent.getRenderChunkSuppilier().unloadRenderCache();
                    this.parent.field_70128_L = true;
                } else {
                    this.parent.field_70128_L = false;
                }
            } else if (this.isWaitingForApprove) {
                if (this.ticksToWait < 0) {
                    this.ticksToWait = 300;
                } else if (this.ticksToWait == 0) {
                    this.parent.field_70128_L = true;
                } else {
                    --this.ticksToWait;
                }
            } else {
                this.place();
            }
        }
        if (this.isChanging()) {
            if (!this.parent.structure.loadChildren()) {
                return this.currentState.state;
            }
            ((LittleDoor)this.parent.structure).beforeTick(this.parent, this.tick);
            AnimationState state = super.tick();
            ((LittleDoor)this.parent.structure).afterTick(this.parent, this.tick);
            return state;
        }
        return super.tick();
    }

    @Override
    public void startTransition(String key) {
        super.startTransition(key);
    }

    @Override
    public void endTransition() {
        super.endTransition();
        ((LittleDoor)this.parent.structure).onFinished(this.parent);
        if (this.turnBack != null && this.turnBack.booleanValue() == this.currentState.name.equals(openedState)) {
            if (this.isWaitingForApprove) {
                this.placed = false;
            } else {
                this.place();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void place() {
        LittleActionPlaceStack.LittlePlaceResult result;
        if (!this.parent.structure.hasLoaded()) {
            System.out.println(new TextComponentTranslation("exception.door.notloaded", new Object[0]).func_150254_d());
            return;
        }
        if (!this.parent.structure.loadChildren()) {
            System.out.println(new TextComponentTranslation("exception.door.brokenchild", new Object[0]).func_150254_d());
            return;
        }
        if (!this.parent.structure.loadParent()) {
            System.out.println(new TextComponentTranslation("exception.door.brokenparent", new Object[0]).func_150254_d());
            return;
        }
        if (this.serverPlaced) {
            this.placed = true;
            this.waitingForRender = null;
            this.parent.field_70128_L = true;
            return;
        }
        World world = this.parent.field_70170_p;
        LittleAbsolutePreviewsStructure previews = this.parent.structure.getAbsolutePreviewsSameWorldOnly(this.parent.absolutePreviewPos);
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        LittleStructure newDoor = previews.getStructure();
        if (!(world instanceof CreativeWorld) && world.field_72995_K) {
            ((LittleDoor)newDoor).waitingForApproval = true;
        }
        if ((result = LittleActionPlaceStack.placeTilesWithoutPlayer(world, previews.context, placePreviews, previews.getStructure(), PlacementMode.all, previews.pos, null, null, null, EnumFacing.EAST)) != null) {
            if (this.parent.structure.parent != null) {
                LittleStructure parentStructure = this.parent.structure.parent.getStructure(world);
                newDoor.updateParentConnection(this.parent.structure.parent.getChildID(), parentStructure);
                parentStructure.updateChildConnection(this.parent.structure.parent.getChildID(), newDoor);
            }
            if (world.field_72995_K) {
                this.parent.fakeWorld.field_72996_f.removeIf(x -> {
                    if (x instanceof EntityAnimation && ((EntityAnimation)x).controller.isWaitingForRender()) {
                        ((EntityAnimation)((Object)x)).markRemoved();
                        return true;
                    }
                    return false;
                });
            }
        } else {
            this.parent.field_70128_L = true;
            if (!world.field_72995_K) {
                WorldUtils.dropItem((World)world, (ItemStack)this.parent.structure.getStructureDrop(), (BlockPos)this.parent.center.baseOffset);
            }
            return;
        }
        newDoor.transferChildrenFromAnimation(this.parent);
        if (!world.field_72995_K) {
            this.parent.field_70128_L = true;
            if (!(world instanceof CreativeWorld)) {
                PacketHandler.sendPacketToTrackingPlayersExcept((CreativeCorePacket)new LittlePlacedAnimationPacket(this.parent.func_110124_au(), newDoor.getMainTile()), (Entity)this.parent, null, (WorldServer)((WorldServer)this.parent.field_70170_p));
            }
        } else {
            List<TileEntityLittleTiles> list = this.waitingForRender = new ArrayList<TileEntityLittleTiles>();
            synchronized (list) {
                for (TileEntityLittleTiles te : result.tileEntities) {
                    te.addWaitingAnimation(this.parent);
                    this.waitingForRender.add(te);
                }
            }
            this.ticksToWait = 200;
            this.parent.field_70128_L = false;
            this.placed = true;
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74782_a(closedState, (NBTBase)this.getState((String)closedState).state.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a(openedState, (NBTBase)this.getState((String)openedState).state.writeToNBT(new NBTTagCompound()));
        if (!this.result.isEmpty()) {
            nbt.func_74782_a("result", (NBTBase)this.result.nbt);
        }
        nbt.func_74778_a("originaluuid", this.supplier.original().toString());
        nbt.func_74778_a("uuid", this.supplier.uuid.toString());
        nbt.func_74757_a("isOpen", this.currentState.name.equals(openedState));
        if (this.isChanging()) {
            nbt.func_74768_a("tick", this.tick);
        }
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("completeDuration", this.completeDuration);
        nbt.func_74774_a("turnBack", (byte)(this.turnBack == null ? 0 : (this.turnBack != false ? 1 : -1)));
        if (this.modifiedTransition) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : this.stateTransition.entrySet()) {
                NBTTagCompound transitionNBT = ((AnimationTimeline)entry.getValue()).writeToNBT(new NBTTagCompound());
                transitionNBT.func_74778_a("key", (String)entry.getKey());
                list.func_74742_a((NBTBase)transitionNBT);
            }
            nbt.func_74782_a("transitions", (NBTBase)list);
        }
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        byte turnBackData;
        this.addState(closedState, new AnimationState(nbt.func_74775_l(closedState)));
        this.addState(openedState, new AnimationState(nbt.func_74775_l(openedState)));
        this.result = nbt.func_74764_b("result") ? new LittleDoor.DoorOpeningResult(nbt.func_74775_l("result")) : LittleDoor.EMPTY_OPENING_RESULT;
        this.supplier = new UUIDSupplier(UUID.fromString(nbt.func_74779_i("originaluuid")), UUID.fromString(nbt.func_74779_i("uuid")));
        this.duration = nbt.func_74762_e("duration");
        this.completeDuration = nbt.func_74762_e("completeDuration");
        if (nbt.func_74764_b("transitions")) {
            NBTTagList list = nbt.func_150295_c("transitions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound transitionNBT = list.func_150305_b(i);
                this.addTransition(transitionNBT.func_74779_i("key"), new AnimationTimeline(transitionNBT));
            }
            this.modifiedTransition = true;
        } else {
            this.generateAllTransistions(this.duration);
            this.stretchTransitions();
        }
        boolean isOpen = nbt.func_74767_n("isOpen");
        this.currentState = isOpen ? this.getState(openedState) : this.getState(closedState);
        if (nbt.func_74764_b("tick")) {
            this.startTransition(isOpen ? closedState : openedState);
            this.tick = nbt.func_74762_e("tick");
        }
        this.turnBack = (turnBackData = nbt.func_74771_c("turnBack")) == 0 ? null : Boolean.valueOf(turnBackData > 0);
    }

    @Override
    public void onServerApproves() {
        this.isWaitingForApprove = false;
    }

    @Override
    public void onPlacedByServer() {
        this.serverPlaced = true;
    }

    @Override
    public void transform(LittleTransformation transformation) {
        for (AnimationController.AnimationControllerState state : this.states.values()) {
            state.transform(transformation);
        }
        for (AnimationTimeline timeline : this.stateTransition.values()) {
            int i;
            Rotation rotation;
            if (transformation.rotX != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.X);
                for (i = 0; i < Math.abs(transformation.rotX); ++i) {
                    timeline.transform(rotation);
                }
            }
            if (transformation.rotY != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.Y);
                for (i = 0; i < Math.abs(transformation.rotY); ++i) {
                    timeline.transform(rotation);
                }
            }
            if (transformation.rotZ == 0) continue;
            rotation = transformation.getRotation(EnumFacing.Axis.Z);
            for (i = 0; i < Math.abs(transformation.rotZ); ++i) {
                timeline.transform(rotation);
            }
        }
        if (this.tickingState != null) {
            this.tickingState.clear();
        } else if (this.isChanging()) {
            this.tickingState = new AnimationState();
        }
        if (this.isChanging()) {
            this.animation.tick(this.tick, this.tickingState);
        }
    }
}

