/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class LittleBedPacket
extends CreativeCorePacket {
    public LittleTileIdentifierAbsolute coord;
    public int playerID;

    public LittleBedPacket() {
    }

    public LittleBedPacket(LittleTileIdentifierAbsolute coord) {
        this.coord = coord;
        this.playerID = -1;
    }

    public LittleBedPacket(LittleTileIdentifierAbsolute coord, EntityPlayer player) {
        this(coord);
        this.playerID = player.func_145782_y();
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeAbsoluteCoord(this.coord, buf);
        buf.writeInt(this.playerID);
    }

    public void readBytes(ByteBuf buf) {
        this.coord = LittleAction.readAbsoluteCoord(buf);
        this.playerID = buf.readInt();
    }

    public void executeClient(EntityPlayer player) {
        EntityPlayer entity;
        Object object = entity = this.playerID == -1 ? player : player.field_70170_p.func_73045_a(this.playerID);
        if (entity instanceof EntityPlayer) {
            try {
                LittleStructure structure;
                LittleTile tile = LittleAction.getTile(player.field_70170_p, this.coord);
                if (tile.isConnectedToStructure() && (structure = tile.connection.getStructure(player.field_70170_p)) instanceof LittleBed) {
                    ((LittleBed)structure).trySleep(entity, structure.getHighestCenterVec());
                }
            }
            catch (LittleActionException e) {
                e.printStackTrace();
            }
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

