/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class LittlePlacedAnimationPacket
extends CreativeCorePacket {
    public UUID uuid;
    public LittleTileIdentifierAbsolute identifier;

    public LittlePlacedAnimationPacket(UUID uuid, LittleTile tile) {
        this.uuid = uuid;
        this.identifier = new LittleTileIdentifierAbsolute(tile);
    }

    public LittlePlacedAnimationPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittlePlacedAnimationPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        LittlePlacedAnimationPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.identifier.writeToNBT(new NBTTagCompound()));
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittlePlacedAnimationPacket.readString((ByteBuf)buf));
        this.identifier = new LittleTileIdentifierAbsolute(LittlePlacedAnimationPacket.readNBT((ByteBuf)buf));
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = LittleDoorHandler.getHandler(true).findDoor(this.uuid);
        if (animation != null && !animation.controller.isWaitingForRender()) {
            animation.controller.onPlacedByServer();
        } else {
            try {
                LittleTile tile = LittleAction.getTile(player.field_70170_p, this.identifier);
                if (tile.isChildOfStructure() && tile.connection.getStructure(player.field_70170_p) instanceof LittleDoor) {
                    ((LittleDoor)tile.connection.getStructureWithoutLoading()).waitingForApproval = false;
                }
            }
            catch (LittleActionException e) {
                e.printStackTrace();
            }
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

