/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.relative;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTileRelative;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class StructureRelative {
    protected LittleGridContext context;
    protected LittleTileBox box;

    public StructureRelative(LittleTileBox box, LittleGridContext context) {
        this.box = box;
        this.context = context;
    }

    public StructureRelative(String name, NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k(name);
        this.box = new LittleTileBox(array[0], array[1], array[2], array[3], array[4], array[5]);
        this.context = LittleGridContext.get(array[6]);
    }

    public LittleTileVec getDoubledCenterVec() {
        return new LittleTileVec(this.box.maxX + this.box.minX, this.box.maxY + this.box.minY, this.box.maxZ + this.box.minZ);
    }

    public Vector3d getCenter() {
        return new Vector3d(this.context.toVanillaGrid(this.box.maxX + this.box.minX) / 2.0, this.context.toVanillaGrid(this.box.maxY + this.box.minY) / 2.0, this.context.toVanillaGrid(this.box.maxZ + this.box.minZ) / 2.0);
    }

    public boolean isEven() {
        return this.box.getSize(EnumFacing.Axis.X) > 1;
    }

    public LittleTileBox getBox() {
        return this.box;
    }

    public LittleGridContext getContext() {
        return this.context;
    }

    public void convertTo(LittleGridContext context) {
        this.box.convertTo(this.context, context);
        this.context = context;
    }

    public void convertToSmallest() {
        int grid = this.box.getSmallestContext(this.context);
        if (grid < this.context.size) {
            this.convertTo(LittleGridContext.get(grid));
        }
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.box.minX, this.box.minY, this.box.minZ, this.box.maxX, this.box.maxY, this.box.maxZ, this.context.size});
    }

    public void setBox(BlockPos pos, LittleTileBox box, LittleGridContext context) {
        this.box = box;
        this.context = context;
        this.add(pos);
    }

    public LittleTileVecContext getMinVec() {
        return new LittleTileVecContext(this.context, this.box.getMinVec());
    }

    public PlacePreviewTile getPlacePreview(LittlePreviews previews, LittleStructureType.StructureTypeRelative type) {
        return new PlacePreviewTileRelative(this.box, previews, this, type);
    }

    public void onMove(LittleStructure structure, LittleGridContext context, LittleTileVec offset) {
        int scale = 1;
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            scale = this.context.size / context.size;
        }
        this.box.add(offset.x * scale, offset.y * scale, offset.z * scale);
        this.convertToSmallest();
    }

    public void onFlip(LittleStructure structure, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(context, this.context);
        }
        this.box.flipBox(axis, doubledCenter);
        this.convertToSmallest();
    }

    public void onRotate(LittleStructure structure, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(context, this.context);
        }
        this.box.rotateBox(rotation, doubledCenter);
        this.convertToSmallest();
    }

    public BlockPos getOffset() {
        return this.box.getMinVec().getBlockPos(this.context);
    }

    public void add(BlockPos pos) {
        this.box.add(new LittleTileVec(this.context, (Vec3i)pos));
    }

    public void add(LittleTileVecContext contextVec) {
        int scale = 1;
        if (contextVec.context.size > this.context.size) {
            this.convertTo(contextVec.context);
        } else if (contextVec.context.size < this.context.size) {
            scale = this.context.size / contextVec.context.size;
        }
        this.box.add(contextVec.vec.x * scale, contextVec.vec.y * scale, contextVec.vec.z * scale);
        this.convertToSmallest();
    }

    public void sub(BlockPos pos) {
        this.box.sub(new LittleTileVec(this.context, (Vec3i)pos));
    }

    public void sub(LittleTileVecContext contextVec) {
        int scale = 1;
        if (contextVec.context.size > this.context.size) {
            this.convertTo(contextVec.context);
        } else if (contextVec.context.size < this.context.size) {
            scale = this.context.size / contextVec.context.size;
        }
        this.box.sub(contextVec.vec.x * scale, contextVec.vec.y * scale, contextVec.vec.z * scale);
        this.convertToSmallest();
    }
}

