/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleActivateDoorPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class LittleDoor
extends LittleStructure {
    public boolean activateParent = false;
    public boolean waitingForApproval = false;
    public static final DoorOpeningResult EMPTY_OPENING_RESULT = new DoorOpeningResult(null);

    public LittleDoor(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.activateParent = nbt.func_74767_n("activateParent");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.activateParent) {
            nbt.func_74757_a("activateParent", this.activateParent);
        }
    }

    public DoorActivationResult activate(@Nullable EntityPlayer player, @Nullable LittleTile tile, @Nullable UUID uuid, boolean sendUpdate) throws LittleActionException {
        if (this.waitingForApproval) {
            throw new LittleActionException.LittleActionExceptionHidden("Door has not been approved yet!");
        }
        if (!this.hasLoaded()) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("exception.door.notloaded", new Object[0]), true);
            }
            return null;
        }
        if (!this.loadChildren()) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("exception.door.brokenchild", new Object[0]), true);
            }
            return null;
        }
        if (!this.loadParent()) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("exception.door.brokenparent", new Object[0]), true);
            }
            return null;
        }
        if (this.activateParent && this.parent != null) {
            LittleStructure parentStructure = this.parent.getStructureWithoutLoading();
            if (parentStructure instanceof LittleDoor) {
                return ((LittleDoor)parentStructure).activate(player, null, uuid, sendUpdate);
            }
            return null;
        }
        if (this.isInMotion()) {
            return null;
        }
        DoorOpeningResult result = this.canOpenDoor(player);
        if (result == null) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("exception.door.notenoughspace", new Object[0]), true);
            }
            return null;
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        if (sendUpdate) {
            if (this.getWorld().field_72995_K) {
                this.sendActivationToServer(player, uuid, result);
            } else {
                this.sendActivationToClient(player, uuid, result);
            }
        }
        return new DoorActivationResult(this.openDoor(player, new UUIDSupplier(uuid), result, false), result);
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (world.field_72995_K) {
            this.activate(player, tile, null, true);
            action.preventInteraction = true;
        }
        return true;
    }

    public void beforeTick(EntityAnimation animation, int tick) {
    }

    public void afterTick(EntityAnimation animation, int tick) {
    }

    public void onFinished(EntityAnimation animation) {
    }

    public void sendActivationToServer(EntityPlayer activator, UUID uuid, DoorOpeningResult result) {
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleActivateDoorPacket(this.getMainTile(), uuid, result));
    }

    public void sendActivationToClient(EntityPlayer activator, UUID uuid, DoorOpeningResult result) {
    }

    public abstract int getCompleteDuration();

    public abstract List<LittleDoor> collectDoorsToCheck();

    public abstract boolean isInMotion();

    public DoorOpeningResult canOpenDoor(@Nullable EntityPlayer player) {
        if (this.isInMotion()) {
            return null;
        }
        NBTTagCompound nbt = null;
        for (LittleDoor door : this.collectDoorsToCheck()) {
            DoorOpeningResult subResult = door.canOpenDoor(player);
            if (subResult == null) {
                return null;
            }
            if (subResult.isEmpty()) continue;
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74782_a("e" + door.parent.getChildID(), (NBTBase)subResult.nbt);
        }
        if (nbt == null) {
            return EMPTY_OPENING_RESULT;
        }
        return new DoorOpeningResult(nbt);
    }

    public boolean canOpenDoor(@Nullable EntityPlayer player, DoorOpeningResult result) {
        if (this.isInMotion()) {
            return false;
        }
        for (LittleDoor door : this.collectDoorsToCheck()) {
            if (door.canOpenDoor(player, result)) continue;
            return false;
        }
        return true;
    }

    public LittleDoor getParentDoor() {
        if (this.activateParent && this.parent != null) {
            return ((LittleDoor)this.parent.getStructure(this.getWorld())).getParentDoor();
        }
        return this;
    }

    protected abstract void fillActivateChildren(BitSet var1);

    @Override
    public void finializePreview(LittlePreviews previews) {
        List<LittlePreviews> previewChildren = previews.getChildren();
        if (!previewChildren.isEmpty()) {
            BitSet set = new BitSet(previewChildren.size());
            this.fillActivateChildren(set);
            for (int i = 0; i < previewChildren.size(); ++i) {
                if (!previewChildren.get(i).hasStructure()) continue;
                if (set.get(i)) {
                    previewChildren.get(i).getStructureData().func_74757_a("activateParent", true);
                    continue;
                }
                previewChildren.get(i).getStructureData().func_82580_o("activateParent");
            }
        }
    }

    public abstract EntityAnimation openDoor(@Nullable EntityPlayer var1, UUIDSupplier var2, DoorOpeningResult var3, boolean var4);

    public static class DoorActivationResult {
        public final DoorOpeningResult result;
        public final EntityAnimation animation;

        public DoorActivationResult(EntityAnimation animation, DoorOpeningResult result) {
            this.animation = animation;
            this.result = result;
        }
    }

    public static class DoorOpeningResult {
        public final NBTTagCompound nbt;

        public DoorOpeningResult(NBTTagCompound nbt) {
            this.nbt = nbt;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DoorOpeningResult) {
                return this.nbt != null ? this.nbt.equals((Object)((DoorOpeningResult)obj).nbt) : ((DoorOpeningResult)obj).nbt == null;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.nbt == null;
        }

        public int hashCode() {
            return this.nbt != null ? this.nbt.hashCode() : super.hashCode();
        }

        public String toString() {
            return "" + this.nbt;
        }
    }
}

