/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.client.render.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.packet.LittleTileUpdatePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseRelative;
import com.creativemd.littletiles.common.structure.connection.StructureLinkTile;
import com.creativemd.littletiles.common.structure.connection.StructureMainTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.combine.ICombinable;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleTile
implements ICombinable {
    private static HashMap<Class<? extends LittleTile>, String> tileIDs = new HashMap();
    private static HashMap<String, Class<? extends LittleTile>> invTileIDs = new HashMap();
    public boolean invisible = false;
    public boolean glowing = false;
    public TileEntityLittleTiles te;
    public LittleTileBox box;
    protected static Field playerInChunkMapEntry = ReflectionHelper.findField(PlayerChunkMapEntry.class, (String[])new String[]{"players", "field_187283_c"});
    public IStructureConnector<LittleTile> connection;

    public static Class<? extends LittleTile> getClassByID(String id) {
        return invTileIDs.get(id);
    }

    public static String getIDByClass(Class<? extends LittleTile> LittleClass) {
        return tileIDs.get(LittleClass);
    }

    public static void registerLittleTile(Class<? extends LittleTile> LittleClass, String id) {
        tileIDs.put(LittleClass, id);
        invTileIDs.put(id, LittleClass);
    }

    public static LittleTile CreateEmptyTile(String id) {
        Class<? extends LittleTile> TileClass = LittleTile.getClassByID(id);
        if (TileClass != null) {
            try {
                return TileClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Found invalid tileID=" + id);
            }
        }
        return null;
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt) {
        if (nbt.func_74764_b("tileID")) {
            if (nbt.func_74764_b("block")) {
                Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                LittleTileBox box = new LittleTileBox(new LittleTileVec("i", nbt), new LittleTileVec("a", nbt));
                box.add(new LittleTileVec(8, 8, 8));
                LittleTileBlock tile = new LittleTileBlock(block, meta);
                tile.box = box;
                return tile;
            }
        } else {
            LittleTile tile = LittleTile.CreateEmptyTile(nbt.func_74779_i("tID"));
            if (tile != null) {
                try {
                    tile.loadTile(te, nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return tile;
        }
        return null;
    }

    public String getID() {
        return LittleTile.getIDByClass(this.getClass());
    }

    public LittleGridContext getContext() {
        return this.te.getContext();
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        this.box.convertTo(from, to);
    }

    public boolean canBeConvertedToVanilla() {
        return !this.isChildOfStructure();
    }

    public LittleTilePos getAbsolutePos() {
        return new LittleTilePos(this.te.func_174877_v(), this.getContext(), this.box.getMinVec());
    }

    @Override
    public LittleTileBox getBox() {
        return this.box;
    }

    @Override
    public void setBox(LittleTileBox box) {
        this.box = box;
    }

    public LittleTileVec getMinVec() {
        return this.box.getMinVec();
    }

    public int getMaxY() {
        return this.box.maxY;
    }

    public AxisAlignedBB getSelectedBox(BlockPos pos) {
        if (LittleTilesConfig.rendering.highlightStructureBox && this.isConnectedToStructure() && this.connection.getStructureWithoutLoading().hasLoaded()) {
            return this.connection.getStructureWithoutLoading().getSurroundingBox();
        }
        return this.box.getSelectionBox(this.getContext(), pos);
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public double getPercentVolume() {
        return this.box.getPercentVolume(this.getContext());
    }

    public LittleTileSize getSize() {
        return this.box.getSize();
    }

    public boolean doesFillEntireBlock() {
        return this.box.doesFillEntireBlock(this.getContext());
    }

    public void fillFace(LittleTileBox.LittleTileFace face) {
        LittleTileBox box = this.box;
        if (face.context != this.getContext()) {
            box = box.copy();
            box.convertTo(this.getContext(), face.context);
        }
        box.fill(face);
    }

    public void fillInSpace(boolean[][][] filled) {
        if (!this.box.isCompletelyFilled()) {
            return;
        }
        for (int x = this.box.minX; x < this.box.maxX; ++x) {
            for (int y = this.box.minY; y < this.box.maxY; ++y) {
                for (int z = this.box.minZ; z < this.box.maxZ; ++z) {
                    filled[x][y][z] = true;
                }
            }
        }
    }

    @Override
    public void fillInSpace(LittleTileBox otherBox, boolean[][][] filled) {
        this.box.fillInSpace(otherBox, filled);
    }

    public final int[] getIdentifier() {
        return this.box.getIdentifier();
    }

    public boolean is(LittleGridContext context, int[] identifier) {
        if ((identifier = LittleTileIdentifierAbsolute.convertTo(identifier, context, this.getContext())) == null) {
            return false;
        }
        return this.box.is(identifier);
    }

    public boolean isAt(int x, int y, int z) {
        return this.box.isVecInsideBox(x, y, z);
    }

    public boolean intersectsWith(LittleTileBox box) {
        return LittleTileBox.intersectsWith(this.box, box);
    }

    public List<LittleTileBox> cutOut(LittleTileBox box) {
        return this.box.cutOut(box);
    }

    public List<LittleTileBox> cutOut(List<LittleTileBox> boxes, List<LittleTileBox> cutout) {
        return this.box.cutOut(boxes, cutout);
    }

    public void getCuttingBoxes(List<LittleTileBox> boxes) {
        boxes.add(this.box);
    }

    public LittleTileBox getCompleteBox() {
        return this.box;
    }

    public LittleTileVec getCenter() {
        return this.box.getCenter();
    }

    public RayTraceResult rayTrace(Vec3d pos, Vec3d look) {
        return this.box.calculateIntercept(this.getContext(), this.te.func_174877_v(), pos, look);
    }

    public boolean equalsBox(LittleTileBox box) {
        return this.box.equals(box);
    }

    public boolean canBeCombined(LittleTile tile) {
        if (this.isChildOfStructure() != tile.isChildOfStructure()) {
            return false;
        }
        if (this.isChildOfStructure() && this.connection.getStructureWithoutLoading() != tile.connection.getStructureWithoutLoading() && !this.connection.equals(tile.connection)) {
            return false;
        }
        if (this.invisible != tile.invisible) {
            return false;
        }
        return this.glowing == tile.glowing;
    }

    public boolean canBeSplitted() {
        return true;
    }

    public void combineTiles(LittleTile tile) {
        if (this.isConnectedToStructure()) {
            this.connection.getStructure(this.te.func_145831_w()).removeTile(tile);
        }
    }

    @Override
    public boolean isChildOfStructure() {
        return this.connection != null;
    }

    public boolean isChildOfStructure(LittleStructure structure) {
        if (this.isChildOfStructure() && this.connection.isConnected(this.te.func_145831_w())) {
            return this.connection.getStructureWithoutLoading() == structure || this.connection.getStructureWithoutLoading().isChildOf(structure);
        }
        return false;
    }

    @Override
    public boolean canCombine(ICombinable combinable) {
        return this.canBeSplitted() && ((LittleTile)combinable).canBeSplitted() && this.canBeCombined((LittleTile)combinable) && ((LittleTile)combinable).canBeCombined(this);
    }

    @Override
    public void combine(ICombinable combinable) {
        this.combineTiles((LittleTile)combinable);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return !this.invisible;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        return this.invisible == tile.invisible;
    }

    public boolean sendUpdatePacketToClient() {
        if (this.supportsUpdatePacket()) {
            if (!this.te.func_145831_w().field_72995_K && this.te.func_145831_w() instanceof WorldServer) {
                PlayerChunkMap map = ((WorldServer)this.te.func_145831_w()).func_184164_w();
                ChunkPos pos = new ChunkPos(this.te.func_174877_v());
                PlayerChunkMapEntry entry = map.func_187301_b(pos.field_77276_a, pos.field_77275_b);
                try {
                    List players = (List)playerInChunkMapEntry.get(entry);
                    PacketHandler.sendPacketToPlayers((CreativeCorePacket)new LittleTileUpdatePacket(this, this.getUpdateNBT()), (Iterable)players);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public boolean requiresCompleteUpdate() {
        return false;
    }

    public void setCompleteUpdate(boolean value) {
    }

    public boolean supportsUpdatePacket() {
        return false;
    }

    public NBTTagCompound getUpdateNBT() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
    }

    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return this.getID().equals(nbt.func_74779_i("tID")) && this.glowing == nbt.func_74767_n("glowing") && this.invisible == nbt.func_74767_n("invisible") && Arrays.equals(this.box.getArray(), nbt.func_74759_k("box"));
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTile(nbt);
        nbt.func_82580_o("box");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public boolean canBeNBTGrouped(LittleTile tile) {
        return tile.canBeCombined(this) && this.canBeCombined(tile) && (this.connection == null || this.te == tile.te && this.connection.equals(tile.connection));
    }

    public void groupNBTTile(NBTTagCompound nbt, LittleTile tile) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)tile.box.getNBTIntArray());
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            NBTTagList small = new NBTTagList();
            small.func_74742_a(list.func_179238_g(i));
            copy.func_74782_a("boxes", (NBTBase)small);
            tags.add(copy);
        }
        return tags;
    }

    public void saveTile(NBTTagCompound nbt) {
        this.saveTileCore(nbt);
        this.saveTileExtra(nbt);
    }

    public void saveTileExtra(NBTTagCompound nbt) {
        if (this.invisible) {
            nbt.func_74757_a("invisible", this.invisible);
        }
        if (this.glowing) {
            nbt.func_74757_a("glowing", this.glowing);
        }
        if (this.getStructureAttribute() == LittleStructureAttribute.PREMADE) {
            nbt.func_74757_a("nodrop", true);
        }
    }

    public void saveTileCore(NBTTagCompound nbt) {
        nbt.func_74778_a("tID", this.getID());
        nbt.func_74783_a("box", this.box.getArray());
        if (this.isChildOfStructure()) {
            NBTTagCompound structureNBT = new NBTTagCompound();
            if (this.connection.isLink()) {
                ((StructureLinkBaseRelative)this.connection).writeToNBT(structureNBT);
            } else {
                this.connection.getStructureWithoutLoading().writeToNBT(structureNBT);
                structureNBT.func_74757_a("main", true);
            }
            nbt.func_74782_a("structure", (NBTBase)structureNBT);
        }
    }

    public void loadTile(TileEntityLittleTiles te, NBTTagCompound nbt) {
        this.te = te;
        this.loadTileCore(nbt);
        this.loadTileExtra(nbt);
    }

    public void loadTileExtra(NBTTagCompound nbt) {
        this.invisible = nbt.func_74767_n("invisible");
        this.glowing = nbt.func_74767_n("glowing");
    }

    public void loadTileCore(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bSize")) {
            int count = nbt.func_74762_e("bSize");
            this.box = LittleTileBox.loadBox("bBox0", nbt);
        } else if (nbt.func_74764_b("boxes")) {
            NBTTagList list = nbt.func_150295_c("boxes", 11);
            this.box = LittleTileBox.createBox(list.func_150306_c(0));
        } else if (nbt.func_74764_b("box")) {
            this.box = LittleTileBox.createBox(nbt.func_74759_k("box"));
        }
        if (nbt.func_150297_b("structure", 10)) {
            NBTTagCompound structureNBT = nbt.func_74775_l("structure");
            if (structureNBT.func_74767_n("main")) {
                LittleStructure structure;
                LittleStructure littleStructure = structure = this.connection != null && !this.connection.isLink() ? this.connection.getStructureWithoutLoading() : null;
                if (structure == null) {
                    structure = LittleStructure.createAndLoadStructure(structureNBT, this);
                } else {
                    structure.loadStructure(this);
                    Iterator<LittleTile> iterator = structure.getTiles();
                    while (iterator.hasNext()) {
                        LittleTile tile = iterator.next();
                        if (tile == this) continue;
                        tile.connection.reset();
                    }
                    structure.loadFromNBT(structureNBT);
                }
                this.connection = new StructureMainTile(this, structure);
            } else {
                this.connection = new StructureLinkTile(structureNBT, this);
            }
        } else if (nbt.func_74767_n("isStructure")) {
            if (nbt.func_74767_n("main")) {
                this.connection = new StructureMainTile(this, LittleStructure.createAndLoadStructure(nbt, this));
            } else if (nbt.func_74764_b("coX")) {
                LittleTilePosition pos = new LittleTilePosition(nbt);
                this.connection = new StructureLinkTile((TileEntity)this.te, pos.coord, LittleGridContext.get(), new int[]{pos.position.x, pos.position.y, pos.position.z}, LittleStructureAttribute.NONE, this);
                System.out.println("Converting old positioning to new relative coordinates " + pos + " to " + this.connection);
            } else {
                this.connection = new StructureLinkTile(nbt, this);
            }
        }
    }

    public void markForUpdate() {
        if (!this.te.func_145831_w().field_72995_K) {
            this.te.updateBlock();
        } else {
            this.te.updateRender();
        }
    }

    public void onPlaced(@Nullable EntityPlayer player, ItemStack stack, @Nullable EnumFacing facing) {
        this.onNeighborChangeInside();
    }

    public void place(TileList list) {
        list.add(this);
    }

    public void destroy(TileList list) {
        if (this.isChildOfStructure()) {
            if (this.isConnectedToStructure()) {
                this.connection.getStructure(this.te.func_145831_w()).onLittleTileDestroy();
            }
        } else {
            list.remove(this);
        }
    }

    @Override
    public LittleTile copy() {
        LittleTile tile = null;
        try {
            tile = (LittleTile)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid LittleTile class=" + this.getClass().getName());
            tile = null;
        }
        if (tile != null) {
            this.copyCore(tile);
            this.copyExtra(tile);
        }
        return tile;
    }

    public void assignTo(LittleTile target) {
        this.copyCore(target);
        this.copyExtra(target);
    }

    public void copyExtra(LittleTile tile) {
        tile.invisible = this.invisible;
        tile.glowing = this.glowing;
    }

    public void copyCore(LittleTile tile) {
        tile.box = this.box != null ? this.box.copy() : null;
        tile.te = this.te;
        if (this.connection != null) {
            tile.connection = this.connection.copy(tile);
        }
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = null;
        if (this.isChildOfStructure()) {
            if (this.isConnectedToStructure()) {
                stack = this.connection.getStructure(this.te.func_145831_w()).getStructureDrop();
            }
        } else {
            stack = this.getDrop();
        }
        if (stack != null) {
            drops.add(stack);
        }
        return drops;
    }

    public abstract ItemStack getDrop();

    public LittleTilePreview getPreviewTile() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTileExtra(nbt);
        nbt.func_74778_a("tID", this.getID());
        return new LittleTilePreview(this.box.copy(), nbt);
    }

    public void onNeighborChangeOutside() {
        this.onNeighborChange();
    }

    public void onNeighborChangeInside() {
        this.onNeighborChange();
    }

    public void onNeighborChange() {
    }

    public boolean needCustomRendering() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<LittleRenderingCube> getRenderingCubes(BlockRenderLayer layer) {
        if (this.invisible) {
            return new ArrayList<LittleRenderingCube>();
        }
        return this.getInternalRenderingCubes(layer);
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract List<LittleRenderingCube> getInternalRenderingCubes(BlockRenderLayer var1);

    @SideOnly(value=Side.CLIENT)
    public void renderTick(double x, double y, double z, float partialTickTime) {
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public abstract SoundType getSound();

    public void updateEntity() {
    }

    public boolean shouldTick() {
        return false;
    }

    protected abstract boolean canSawResize(EnumFacing var1, EntityPlayer var2);

    public boolean canSawResizeTile(EnumFacing facing, EntityPlayer player) {
        return !this.isChildOfStructure() && this.canSawResize(facing, player);
    }

    public boolean canBeMoved(EnumFacing facing) {
        return true;
    }

    public abstract float getExplosionResistance();

    public void onTileExplodes(Explosion explosion) {
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.isConnectedToStructure()) {
            return this.connection.getStructure(this.te.func_145831_w()).onBlockActivated(worldIn, this, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ, action);
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.glowing ? 14 : 0;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    public boolean isLadder() {
        return this.getStructureAttribute() == LittleStructureAttribute.LADDER;
    }

    public float getSlipperiness(Entity entity) {
        return 0.0f;
    }

    public boolean isMaterial(Material material) {
        return false;
    }

    public boolean isLiquid() {
        return false;
    }

    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return originalColor;
    }

    public Vec3d modifyAcceleration(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return null;
    }

    public List<LittleTileBox> getCollisionBoxes() {
        if (this.getStructureAttribute() == LittleStructureAttribute.COLLISION) {
            return new ArrayList<LittleTileBox>();
        }
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        boxes.add(this.box);
        return boxes;
    }

    public boolean shouldCheckForCollision() {
        return this.getStructureAttribute() == LittleStructureAttribute.COLLISION;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.getStructureAttribute() == LittleStructureAttribute.COLLISION && this.isConnectedToStructure()) {
            this.connection.getStructure(this.te.func_145831_w()).onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
        }
    }

    public boolean isConnectedToStructure() {
        return this.connection != null && this.connection.isConnected(this.te.func_145831_w());
    }

    public LittleStructureAttribute getStructureAttribute() {
        if (this.isChildOfStructure()) {
            return this.connection.getAttribute();
        }
        return LittleStructureAttribute.NONE;
    }

    @Deprecated
    public static class LittleTilePosition {
        public BlockPos coord;
        public LittleTileVec position;

        public LittleTilePosition(BlockPos coord, LittleTileVec position) {
            this.coord = coord;
            this.position = position;
        }

        public LittleTilePosition(String id, NBTTagCompound nbt) {
            this.coord = new BlockPos(nbt.func_74762_e(id + "coX"), nbt.func_74762_e(id + "coY"), nbt.func_74762_e(id + "coZ"));
            this.position = new LittleTileVec(id + "po", nbt);
        }

        public LittleTilePosition(NBTTagCompound nbt) {
            this("", nbt);
        }

        public void writeToNBT(String id, NBTTagCompound nbt) {
            nbt.func_74768_a(id + "coX", this.coord.func_177958_n());
            nbt.func_74768_a(id + "coY", this.coord.func_177956_o());
            nbt.func_74768_a(id + "coZ", this.coord.func_177952_p());
            this.position.writeToNBT(id + "po", nbt);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT("", nbt);
        }

        public String toString() {
            return "coord:" + this.coord + "|position:" + this.position;
        }

        public LittleTilePosition copy() {
            return new LittleTilePosition(new BlockPos((Vec3i)this.coord), this.position.copy());
        }
    }
}

