/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class LittleAbsolutePreviewsStructure
extends LittleAbsolutePreviews {
    public final NBTTagCompound nbt;
    private LittleStructure structure;

    public LittleAbsolutePreviewsStructure(NBTTagCompound nbt, LittleAbsolutePreviews previews) {
        super(previews);
        this.nbt = nbt;
    }

    public LittleAbsolutePreviewsStructure(NBTTagCompound nbt, BlockPos pos, LittlePreviews previews) {
        super(pos, previews.context);
        this.previews.addAll(previews.previews);
        this.children.addAll(previews.children);
        this.nbt = nbt;
    }

    public LittleAbsolutePreviewsStructure(NBTTagCompound nbt, BlockPos pos, LittleGridContext context) {
        super(pos, context);
        this.nbt = nbt;
    }

    @Override
    public boolean hasStructure() {
        return true;
    }

    @Override
    public void deleteCachedStructure() {
        super.deleteCachedStructure();
        this.structure = null;
    }

    @Override
    public void addChild(LittlePreviews child) {
        super.addChild(child);
        if (this.structure != null) {
            this.structure.addTempChild(child.getStructure());
        }
    }

    @Override
    public LittleStructure getStructure() {
        if (this.structure == null) {
            this.structure = LittleStructure.createAndLoadStructure(this.nbt, null);
            this.structure.createTempChildList();
            for (LittlePreviews child : this.getChildren()) {
                this.structure.addTempChild(child.getStructure());
            }
        }
        return this.structure;
    }

    @Override
    public NBTTagCompound getStructureData() {
        return this.nbt;
    }

    @Override
    public LittleAbsolutePreviewsStructure copy() {
        LittleAbsolutePreviewsStructure previews = new LittleAbsolutePreviewsStructure(this.nbt, this.pos, this.context);
        for (LittleTilePreview preview : this.previews) {
            previews.previews.add(preview.copy());
        }
        for (LittlePreviews child : this.children) {
            previews.children.add(child.copy());
        }
        return previews;
    }
}

