/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class LittleTilePos {
    public BlockPos pos;
    public LittleTileVecContext contextVec;

    public LittleTilePos(String name, NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k(name);
        if (array.length == 3) {
            LittleTileVec vec = new LittleTileVec(name, nbt);
            LittleGridContext context = LittleGridContext.get();
            this.pos = vec.getBlockPos(context);
            this.contextVec = new LittleTileVecContext(context, new LittleTileVec(vec.x - this.pos.func_177958_n() * context.size, vec.y - this.pos.func_177956_o() * context.size, vec.z - this.pos.func_177952_p() * context.size));
        } else if (array.length == 7) {
            this.pos = new BlockPos(array[0], array[1], array[2]);
            this.contextVec = new LittleTileVecContext(LittleGridContext.get(array[3]), new LittleTileVec(array[4], array[5], array[6]));
        } else {
            throw new InvalidParameterException("No valid coords given " + nbt);
        }
    }

    public LittleTilePos(RayTraceResult result, LittleGridContext context) {
        long x = context.toGridAccurate(result.field_72307_f.field_72450_a);
        long y = context.toGridAccurate(result.field_72307_f.field_72448_b);
        long z = context.toGridAccurate(result.field_72307_f.field_72449_c);
        this.pos = new BlockPos((int)Math.floor(context.toVanillaGrid(x)), (int)Math.floor(context.toVanillaGrid(y)), (int)Math.floor(context.toVanillaGrid(z)));
        this.contextVec = new LittleTileVecContext(context, new LittleTileVec((int)(x - context.toGridAccurate(this.pos.func_177958_n())), (int)(y - context.toGridAccurate(this.pos.func_177956_o())), (int)(z - context.toGridAccurate(this.pos.func_177952_p()))));
    }

    public LittleTilePos(BlockPos pos, LittleGridContext context) {
        this(pos, new LittleTileVecContext(context, new LittleTileVec(0, 0, 0)));
    }

    public LittleTilePos(BlockPos pos, LittleGridContext context, LittleTileVec vec) {
        this(pos, new LittleTileVecContext(context, vec));
    }

    public LittleTilePos(BlockPos pos, LittleTileVecContext contextVec) {
        this.pos = pos;
        this.contextVec = contextVec;
    }

    public void convertToSmallest() {
        this.contextVec.convertToSmallest();
    }

    public void convertTo(LittleGridContext to) {
        this.contextVec.convertTo(to);
    }

    public void ensureBothAreEqual(LittleTilePos pos) {
        this.contextVec.ensureBothAreEqual(pos.contextVec);
    }

    public LittleTileVecContext getRelative(LittleTilePos pos) {
        this.ensureBothAreEqual(pos);
        LittleTileVecContext newVec = new LittleTileVecContext(this.getContext(), new LittleTileVec(this.getContext(), (Vec3i)this.pos.func_177973_b((Vec3i)pos.pos)));
        newVec.vec.add(this.contextVec.vec);
        newVec.vec.sub(pos.contextVec.vec);
        pos.convertToSmallest();
        this.convertToSmallest();
        return newVec;
    }

    public void add(LittleTilePos pos) {
        this.pos = this.pos.func_177971_a((Vec3i)pos.pos);
        this.ensureBothAreEqual(pos);
        this.contextVec.vec.add(pos.contextVec.vec);
        pos.convertToSmallest();
        this.convertToSmallest();
    }

    public void sub(LittleTilePos pos) {
        this.pos = this.pos.func_177973_b((Vec3i)pos.pos);
        this.ensureBothAreEqual(pos);
        this.contextVec.vec.sub(pos.contextVec.vec);
        pos.convertToSmallest();
        this.convertToSmallest();
    }

    public void add(Vec3i vec) {
        this.pos = this.pos.func_177971_a(vec);
    }

    public void sub(Vec3i vec) {
        this.pos = this.pos.func_177973_b(vec);
    }

    public void add(LittleTileVecContext vec) {
        this.contextVec.add(vec);
    }

    public void sub(LittleTileVecContext vec) {
        this.contextVec.sub(vec);
    }

    public void removeInternalBlockOffset() {
        int amount;
        LittleGridContext context = this.getContext();
        if (this.contextVec.vec.x >= context.size) {
            amount = this.contextVec.vec.x / context.size;
            this.contextVec.vec.x -= amount * context.size;
            this.pos = this.pos.func_177982_a(amount, 0, 0);
        }
        if (this.contextVec.vec.y >= context.size) {
            amount = this.contextVec.vec.y / context.size;
            this.contextVec.vec.y -= amount * context.size;
            this.pos = this.pos.func_177982_a(0, amount, 0);
        }
        if (this.contextVec.vec.z >= context.size) {
            amount = this.contextVec.vec.z / context.size;
            this.contextVec.vec.z -= amount * context.size;
            this.pos = this.pos.func_177982_a(0, 0, amount);
        }
        if (this.contextVec.vec.x < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.contextVec.vec.x / (double)context.size));
            this.contextVec.vec.x += amount * context.size;
            this.pos = this.pos.func_177982_a(-amount, 0, 0);
        }
        if (this.contextVec.vec.y < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.contextVec.vec.y / (double)context.size));
            this.contextVec.vec.y += amount * context.size;
            this.pos = this.pos.func_177982_a(0, -amount, 0);
        }
        if (this.contextVec.vec.z < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.contextVec.vec.z / (double)context.size));
            this.contextVec.vec.z += amount * context.size;
            this.pos = this.pos.func_177982_a(0, 0, -amount);
        }
    }

    public LittleTilePos copy() {
        return new LittleTilePos(this.pos, this.contextVec.copy());
    }

    public double getPosX() {
        return (double)this.pos.func_177958_n() + this.contextVec.getPosX();
    }

    public double getPosY() {
        return (double)this.pos.func_177956_o() + this.contextVec.getPosY();
    }

    public double getPosZ() {
        return (double)this.pos.func_177952_p() + this.contextVec.getPosZ();
    }

    public Vec3d getVec() {
        return new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.contextVec.context.size, this.contextVec.vec.x, this.contextVec.vec.y, this.contextVec.vec.z});
    }

    public LittleGridContext getContext() {
        return this.contextVec.context;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof LittleTilePos) {
            LittleTilePos pos = (LittleTilePos)paramObject;
            LittleGridContext newContext = LittleGridContext.max(this.getContext(), pos.getContext());
            int multiplier = newContext.size / this.getContext().size;
            long thisX = this.pos.func_177958_n() * newContext.size + this.contextVec.vec.x * multiplier;
            long thisY = this.pos.func_177956_o() * newContext.size + this.contextVec.vec.y * multiplier;
            long thisZ = this.pos.func_177952_p() * newContext.size + this.contextVec.vec.z * multiplier;
            multiplier = newContext.size / pos.getContext().size;
            long otherX = pos.pos.func_177958_n() * newContext.size + pos.contextVec.vec.x * multiplier;
            long otherY = pos.pos.func_177956_o() * newContext.size + pos.contextVec.vec.y * multiplier;
            long otherZ = pos.pos.func_177952_p() * newContext.size + pos.contextVec.vec.z * multiplier;
            return thisX == otherX && thisY == otherY && thisZ == otherZ;
        }
        return super.equals(paramObject);
    }

    public String toString() {
        return "[" + this.pos.func_177958_n() + "," + this.pos.func_177956_o() + "," + this.pos.func_177952_p() + ",grid:" + this.contextVec.context.size + "," + this.contextVec.vec.x + "," + this.contextVec.vec.y + "," + this.contextVec.vec.z + "]";
    }
}

