/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.converting;

import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChiselAndBitsConveration {
    public static ConcurrentLinkedQueue<TileEntity> tileentities = new ConcurrentLinkedQueue();

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END) {
            LittleGridContext chiselContext = LittleGridContext.get(ChiselsAndBitsManager.convertingFrom);
            int progress = 0;
            int size = tileentities.size();
            if (!tileentities.isEmpty()) {
                System.out.println("Attempting to convert " + size + " blocks ...");
            }
            while (!tileentities.isEmpty()) {
                TileEntity te = tileentities.poll();
                List<LittleTile> tiles = ChiselsAndBitsManager.getTiles(te);
                if (tiles != null && tiles.size() > 0) {
                    te.func_145831_w().func_175656_a(te.func_174877_v(), BlockTile.getState(tiles));
                    TileEntityLittleTiles tileEntity = (TileEntityLittleTiles)te.func_145831_w().func_175625_s(te.func_174877_v());
                    tileEntity.convertTo(chiselContext);
                    tileEntity.updateTiles(x -> {
                        for (LittleTile tile : tiles) {
                            tile.te = tileEntity;
                            tile.place((TileList)x);
                        }
                    });
                }
                if (++progress % 100 != 0) continue;
                System.out.println("Converted " + progress + "/" + size + " blocks ...");
            }
            if (size > 0) {
                System.out.println("Converted " + size + " blocks ...");
            }
        }
    }

    public static void onAddedTileEntity(TileEntity te) {
        if (ChiselsAndBitsManager.isInstalled() && ChiselsAndBitsManager.isChiselsAndBitsStructure(te)) {
            tileentities.add(te);
        }
    }
}

