/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.type.LinkedHashMapDouble;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import com.creativemd.littletiles.common.utils.tooltip.TooltipUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class BlockIngredient
extends LittleIngredient<BlockIngredient>
implements Iterable<BlockIngredientEntry> {
    private int maxEntries = -1;
    private double maxVolume = -1.0;
    private List<BlockIngredientEntry> content = new ArrayList<BlockIngredientEntry>();

    public BlockIngredient setLimits(int maxEntries, double maxVolume) {
        this.maxEntries = maxEntries;
        this.maxVolume = maxVolume;
        return this;
    }

    @Override
    public BlockIngredient add(BlockIngredient ingredient) {
        BlockIngredient remaings = null;
        for (BlockIngredientEntry entry : ingredient.content) {
            BlockIngredientEntry remaing = this.add(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new BlockIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public BlockIngredient sub(BlockIngredient ingredient) {
        BlockIngredient remaings = null;
        for (BlockIngredientEntry entry : ingredient.content) {
            BlockIngredientEntry remaing = this.sub(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new BlockIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public BlockIngredientEntry add(BlockIngredientEntry ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            BlockIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.value += ingredient.value;
            if (this.maxVolume != -1.0 && entry.value > this.maxVolume) {
                BlockIngredientEntry remaining = entry.copy();
                remaining.value = entry.value - this.maxVolume;
                entry.value = this.maxVolume;
                ingredient = remaining;
                continue;
            }
            return null;
        }
        if (this.maxEntries == -1 || this.content.size() < this.maxEntries) {
            this.content.add(ingredient.copy());
            return null;
        }
        return ingredient;
    }

    @Override
    public BlockIngredientEntry sub(BlockIngredientEntry ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        for (int i = this.content.size() - 1; i >= 0; --i) {
            BlockIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.value -= ingredient.value;
            if (entry.value <= 0.0) {
                this.content.remove(i);
                if (entry.value < 0.0) {
                    ingredient = entry;
                    ingredient.value = -ingredient.value;
                    continue;
                }
            }
            return null;
        }
        return ingredient;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public BlockIngredient copy() {
        BlockIngredient copy = new BlockIngredient();
        copy.maxEntries = this.maxEntries;
        copy.maxVolume = this.maxVolume;
        this.content.forEach(x -> copy.add(x.copy()));
        return copy;
    }

    @Override
    public void print(List<String> lines, List<ItemStack> stacks) {
        for (BlockIngredientEntry entry : this.content) {
            ItemStack stack = entry.getItemStack();
            lines.add(stack.func_82833_r());
            stacks.add(stack);
        }
    }

    @Override
    public void scale(int count) {
        for (BlockIngredientEntry entry : this.content) {
            entry.scale(count);
        }
    }

    protected LinkedHashMapDouble<BlockIngredientEntry> getCombinedEntries() {
        LinkedHashMapDouble map = new LinkedHashMapDouble();
        for (BlockIngredientEntry entry : this.content) {
            map.put((Object)entry, Double.valueOf(entry.value));
        }
        return map;
    }

    public boolean isVolumeLimited() {
        return this.maxVolume > 0.0;
    }

    @Override
    public int getMinimumCount(BlockIngredient other, int availableCount) {
        int count = -1;
        LinkedHashMapDouble<BlockIngredientEntry> thisEntries = this.getCombinedEntries();
        LinkedHashMapDouble<BlockIngredientEntry> otherEntries = other.getCombinedEntries();
        for (Map.Entry entry : thisEntries.entrySet()) {
            Double value = (Double)otherEntries.get(entry.getKey());
            if (value == null) continue;
            count = (int)Math.ceil(Math.max((double)count, (Double)entry.getValue() / value));
        }
        return Math.min(count, availableCount);
    }

    @Override
    public Iterator<BlockIngredientEntry> iterator() {
        return this.content.iterator();
    }

    public List<BlockIngredientEntry> getContent() {
        return this.content;
    }

    @Override
    public String print(List<Object> objects) {
        if (this.content.size() <= 4) {
            String message = "";
            for (BlockIngredientEntry entry : this.content) {
                ItemStack stack = entry.getItemStack();
                message = message + "{" + objects.size() + "} " + TooltipUtils.printVolume(entry.value, false) + " " + stack.func_82833_r() + "\n";
                objects.add(stack);
            }
            return message;
        }
        String message = "";
        for (BlockIngredientEntry entry : this.content) {
            ItemStack stack = entry.getItemStack();
            message = message + "{" + objects.size() + "} " + TooltipUtils.printVolume(entry.value, false) + " ";
            objects.add(stack);
        }
        return message;
    }

    public String toString() {
        return this.content.toString();
    }
}

