/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BlockIngredientEntry {
    public Block block;
    public int meta;
    public double value;

    BlockIngredientEntry(Block block, int meta, double value) {
        this.block = block;
        this.meta = meta;
        this.value = value;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public ItemStack getTileItemStack() {
        ItemStack stack = new ItemStack(LittleTiles.blockTileNoTicking);
        NBTTagCompound nbt = new NBTTagCompound();
        new LittleTileSize(1, 1, 1).writeToNBT("size", nbt);
        LittleTileBlock tile = new LittleTileBlock(this.block, this.meta);
        ((LittleTile)tile).saveTileExtra(nbt);
        nbt.func_74778_a("tID", "BlockTileBlock");
        stack.func_77982_d(nbt);
        int count = (int)(this.value / LittleGridContext.get().minimumTileSize);
        if (count == 0) {
            LittleGridContext.getMax().set(stack.func_77978_p());
            count = (int)(this.value / LittleGridContext.getMax().minimumTileSize);
        }
        stack.func_190920_e(count);
        return stack;
    }

    public int hashCode() {
        return this.block.hashCode() + this.meta;
    }

    public boolean equals(Object object) {
        return object instanceof BlockIngredientEntry && ((BlockIngredientEntry)object).block == this.block && ((BlockIngredientEntry)object).meta == this.meta;
    }

    public IBlockState getState() {
        return BlockUtils.getState((Block)this.block, (int)this.meta);
    }

    public boolean is(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == this.block && stack.func_77960_j() == this.meta;
    }

    public BlockIngredientEntry copy() {
        return new BlockIngredientEntry(this.block, this.meta, this.value);
    }

    public BlockIngredientEntry copy(double value) {
        return new BlockIngredientEntry(this.block, this.meta, value);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("block", this.block.getRegistryName().toString());
        nbt.func_74768_a("meta", this.meta);
        nbt.func_74780_a("volume", this.value);
        return nbt;
    }

    public boolean isEmpty() {
        return this.value <= 0.0;
    }

    public void scale(int count) {
        this.value *= (double)count;
    }

    public String toString() {
        return "[" + this.block.getRegistryName() + "," + this.meta + "," + this.value + "]";
    }
}

