/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.ColorIngredient;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredientBase;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import com.creativemd.littletiles.common.utils.ingredients.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredientEntry;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.DyeUtils;

public abstract class LittleIngredient<T extends LittleIngredient>
extends LittleIngredientBase<T> {
    private static HashMap<Class<? extends LittleIngredient>, Integer> types = new HashMap();
    private static HashMap<Integer, Class<? extends LittleIngredient>> typesInv = new HashMap();
    private static HashMap<Class<? extends LittleIngredient>, IngredientOverflowHandler> typesOverflowHandler = new HashMap();
    private static List<IngredientConvertionHandler> typesConverationHandler = new ArrayList<IngredientConvertionHandler>();
    private static int index = 0;

    public static int indexOf(LittleIngredient ingredient) {
        return LittleIngredient.indexOf(ingredient.getClass());
    }

    public static int indexOf(Class<? extends LittleIngredient> type) {
        return types.get(type);
    }

    public static List<ItemStack> handleOverflow(LittleIngredient ingredient) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        return typesOverflowHandler.get(ingredient.getClass()).handleOverflow(ingredient);
    }

    static void extract(LittleIngredients ingredients, LittlePreviews previews, boolean onlyStructure) {
        if (!onlyStructure) {
            for (IngredientConvertionHandler handler : typesConverationHandler) {
                ingredients.add((LittleIngredient)handler.extract(previews));
            }
        }
        if (previews.hasStructure()) {
            previews.getStructure().addIngredients(ingredients);
        }
        if (previews.hasChildren()) {
            for (LittlePreviews child : previews.getChildren()) {
                LittleIngredient.extract(ingredients, child, onlyStructure);
            }
        }
    }

    public static LittleIngredients extract(LittleTilePreview preview, double volume) {
        LittleIngredients ingredients = new LittleIngredients();
        for (IngredientConvertionHandler handler : typesConverationHandler) {
            ingredients.add((LittleIngredient)handler.extract(preview, volume));
        }
        return ingredients;
    }

    public static LittleIngredients extract(LittlePreviews previews) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, previews, false);
        return ingredients;
    }

    public static LittleIngredients extractStructureOnly(LittlePreviews previews) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, previews, true);
        return ingredients;
    }

    public static LittleIngredients extractWithoutCount(ItemStack stack, boolean useLTStructures) {
        LittleIngredients ingredients = new LittleIngredients();
        ILittleTile tile = PlacementHelper.getLittleInterface(stack);
        if (tile != null) {
            if (useLTStructures && tile.hasLittlePreview(stack) && tile.containsIngredients(stack)) {
                LittleIngredient.extract(ingredients, tile.getLittlePreview(stack), false);
            }
        } else {
            for (IngredientConvertionHandler handler : typesConverationHandler) {
                ingredients.add((LittleIngredient)handler.extract(stack));
            }
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return ingredients;
    }

    public static int getSize() {
        return index + 1;
    }

    public static void registerConvationHandler(IngredientConvertionHandler converationHandler) {
        typesConverationHandler.add(converationHandler);
    }

    public static <T extends LittleIngredient> void registerType(Class<T> type, IngredientOverflowHandler<T> overflowHandler, IngredientConvertionHandler<T> converationHandler) {
        if (types.containsKey(type)) {
            throw new RuntimeException("Duplicate found! " + types);
        }
        types.put(type, index);
        typesInv.put(index, type);
        typesOverflowHandler.put(type, overflowHandler);
        if (converationHandler != null) {
            LittleIngredient.registerConvationHandler(converationHandler);
        }
        ++index;
    }

    @Override
    public abstract T copy();

    public abstract void print(List<String> var1, List<ItemStack> var2);

    @Override
    public abstract T add(T var1);

    @Override
    public abstract T sub(T var1);

    public abstract void scale(int var1);

    public abstract int getMinimumCount(T var1, int var2);

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass();
    }

    public abstract String print(List<Object> var1);

    static {
        LittleIngredient.registerType(BlockIngredient.class, new IngredientOverflowHandler<BlockIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(BlockIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(overflow);
            }
        }, new IngredientConvertionHandler<BlockIngredient>(){

            @Override
            public BlockIngredient extract(ItemStack stack) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block != null && !(block instanceof BlockAir) && LittleAction.isBlockValid(BlockUtils.getState((Block)block, (int)stack.func_77960_j()))) {
                    BlockIngredient ingredient = new BlockIngredient();
                    ingredient.add(IngredientUtils.getBlockIngredient(block, stack.func_77960_j(), 1.0));
                    return ingredient;
                }
                return null;
            }

            @Override
            public BlockIngredient extract(LittlePreviews previews) {
                BlockIngredient ingredient = new BlockIngredient();
                for (LittleTilePreview preview : previews) {
                    if (!preview.canBeConvertedToBlockEntry()) continue;
                    ingredient.add(preview.getBlockIngredient(previews.context));
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public BlockIngredient extract(LittleTilePreview preview, double volume) {
                BlockIngredient ingredient = new BlockIngredient();
                BlockIngredientEntry entry = preview.getBlockIngredient(LittleGridContext.get());
                entry.value = volume;
                ingredient.add(entry);
                return ingredient;
            }
        });
        LittleIngredient.registerType(ColorIngredient.class, new IngredientOverflowHandler<ColorIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(ColorIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(overflow);
            }
        }, new IngredientConvertionHandler<ColorIngredient>(){
            Field dyeColor = ReflectionHelper.findField(EnumDyeColor.class, (String[])new String[]{"colorValue", "field_193351_w"});

            @Override
            public ColorIngredient extract(ItemStack stack) {
                if (DyeUtils.isDye((ItemStack)stack)) {
                    Optional optional = DyeUtils.colorFromStack((ItemStack)stack);
                    if (!optional.isPresent()) {
                        return null;
                    }
                    try {
                        ColorIngredient color = ColorIngredient.getColors(this.dyeColor.getInt(optional.get()));
                        color.scale(SpecialServerConfig.dyeVolume);
                        return color;
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public ColorIngredient extract(LittlePreviews previews) {
                ColorIngredient ingredient = new ColorIngredient();
                for (LittleTilePreview preview : previews) {
                    if (!preview.canBeConvertedToBlockEntry()) continue;
                    ingredient.add(ColorIngredient.getColors(previews.context, preview));
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public ColorIngredient extract(LittleTilePreview preview, double volume) {
                ColorIngredient ingredient = new ColorIngredient();
                ingredient.add(ColorIngredient.getColors(preview, volume));
                return ingredient;
            }
        });
        LittleIngredient.registerType(StackIngredient.class, new IngredientOverflowHandler<StackIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(StackIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (StackIngredientEntry entry : overflow) {
                    ItemStack stack = entry.stack.func_77946_l();
                    stack.func_190920_e(entry.count);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, null);
    }

    public static abstract class IngredientConvertionHandler<T extends LittleIngredient> {
        public abstract T extract(ItemStack var1);

        public abstract T extract(LittlePreviews var1);

        public abstract T extract(LittleTilePreview var1, double var2);
    }

    public static abstract class IngredientOverflowHandler<T extends LittleIngredient> {
        public abstract List<ItemStack> handleOverflow(T var1) throws NotEnoughIngredientsException.NotEnoughSpaceException;
    }
}

