/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.type.LinkedHashMapInteger;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredientEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class StackIngredient
extends LittleIngredient<StackIngredient>
implements Iterable<StackIngredientEntry> {
    private List<StackIngredientEntry> content = new ArrayList<StackIngredientEntry>();
    private int stackLimit = -1;
    private int maxEntries = -1;

    public StackIngredient() {
    }

    public StackIngredient(List<ItemStack> stacks) {
        stacks.forEach(x -> this.content.add(new StackIngredientEntry((ItemStack)x, x.func_190916_E())));
    }

    public StackIngredient(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.add(new StackIngredientEntry(stack, stack.func_190916_E()));
        }
    }

    public StackIngredient setLimits(int maxEntries, int stackLimit) {
        this.maxEntries = maxEntries;
        this.stackLimit = stackLimit;
        return this;
    }

    @Override
    public Iterator<StackIngredientEntry> iterator() {
        return this.content.iterator();
    }

    @Override
    public StackIngredient copy() {
        StackIngredient copy = new StackIngredient();
        copy.stackLimit = this.stackLimit;
        copy.maxEntries = this.maxEntries;
        this.content.forEach(x -> copy.content.add(x.copy()));
        return copy;
    }

    @Override
    public void print(List<String> lines, List<ItemStack> stacks) {
        for (StackIngredientEntry entry : this.content) {
            lines.add(entry.stack.func_82833_r());
            stacks.add(entry.stack);
        }
    }

    @Override
    public StackIngredientEntry add(StackIngredientEntry ingredient) {
        if (ingredient.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            StackIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.count += ingredient.count;
            if (this.stackLimit != -1 && entry.count > this.stackLimit) {
                StackIngredientEntry remaining = entry.copy();
                remaining.count = entry.count - this.stackLimit;
                entry.count = this.stackLimit;
                ingredient = remaining;
                continue;
            }
            return null;
        }
        if (this.maxEntries == -1 || this.content.size() < this.maxEntries) {
            this.content.add(ingredient.copy());
            return null;
        }
        return ingredient;
    }

    @Override
    public StackIngredient add(StackIngredient ingredient) {
        StackIngredient remaings = null;
        for (StackIngredientEntry entry : ingredient.content) {
            StackIngredientEntry remaing = this.add(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new StackIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public StackIngredientEntry sub(StackIngredientEntry ingredient) {
        if (ingredient.isEmpty()) {
            return null;
        }
        for (int i = this.content.size() - 1; i >= 0; --i) {
            StackIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.count -= ingredient.count;
            if (entry.count <= 0) {
                this.content.remove(i);
                if (entry.count < 0) {
                    ingredient = entry;
                    ingredient.count = -ingredient.count;
                    continue;
                }
            }
            return null;
        }
        return ingredient;
    }

    @Override
    public StackIngredient sub(StackIngredient ingredient) {
        StackIngredient remaings = null;
        for (StackIngredientEntry entry : ingredient.content) {
            StackIngredientEntry remaing = this.sub(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new StackIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public void scale(int count) {
        for (StackIngredientEntry entry : this.content) {
            entry.scale(count);
        }
    }

    protected LinkedHashMapInteger<StackIngredientEntry> getCombinedEntries() {
        LinkedHashMapInteger map = new LinkedHashMapInteger();
        for (StackIngredientEntry entry : this.content) {
            map.put((Object)entry, Integer.valueOf(entry.count));
        }
        return map;
    }

    public boolean isStackLimited() {
        return this.stackLimit > 0;
    }

    @Override
    public int getMinimumCount(StackIngredient other, int availableCount) {
        int count = -1;
        LinkedHashMapInteger<StackIngredientEntry> thisEntries = this.getCombinedEntries();
        LinkedHashMapInteger<StackIngredientEntry> otherEntries = other.getCombinedEntries();
        for (Map.Entry entry : thisEntries.entrySet()) {
            Integer value = (Integer)otherEntries.get(entry.getKey());
            if (value == null) continue;
            count = (int)Math.ceil(Math.max(count, (Integer)entry.getValue() / value));
        }
        return Math.min(count, availableCount);
    }

    public List<StackIngredientEntry> getContent() {
        return this.content;
    }

    @Override
    public String print(List<Object> objects) {
        if (this.content.size() <= 4) {
            String message = "";
            for (StackIngredientEntry entry : this.content) {
                message = message + "{" + objects.size() + "} " + entry.count + " " + entry.stack.func_82833_r() + "\n";
                objects.add(entry.stack);
            }
            return message;
        }
        String message = "";
        for (StackIngredientEntry entry : this.content) {
            message = message + "{" + objects.size() + "} " + entry.count + " ";
            objects.add(entry.stack);
        }
        return message;
    }

    public String toString() {
        return this.content.toString();
    }
}

