/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class StackIngredientEntry {
    public final ItemStack stack;
    public int count;

    public StackIngredientEntry(ItemStack stack, int count) {
        this.stack = stack;
        this.count = count;
    }

    public int hashCode() {
        return this.stack.func_77973_b().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StackIngredientEntry) {
            return InventoryUtils.isItemStackEqual((ItemStack)this.stack, (ItemStack)((StackIngredientEntry)obj).stack);
        }
        return false;
    }

    public String toString() {
        return this.stack.toString();
    }

    public boolean drain(List<ItemStack> inventory) {
        Iterator<ItemStack> iterator = inventory.iterator();
        while (iterator.hasNext()) {
            ItemStack invStack = iterator.next();
            if (!InventoryUtils.isItemStackEqual((ItemStack)invStack, (ItemStack)this.stack)) continue;
            int amount = Math.min(this.stack.func_190916_E(), invStack.func_190916_E());
            if (amount > 0) {
                invStack.func_190918_g(amount);
                this.stack.func_190918_g(amount);
            }
            if (invStack.func_190926_b()) {
                iterator.remove();
            }
            if (!this.stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public StackIngredientEntry copy() {
        return new StackIngredientEntry(this.stack, this.count);
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public void scale(int count) {
        this.count *= count;
    }
}

