/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.shape;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.shape.DragShapeBox;
import com.creativemd.littletiles.common.utils.shape.DragShapeCylinder;
import com.creativemd.littletiles.common.utils.shape.DragShapeLine;
import com.creativemd.littletiles.common.utils.shape.DragShapeSliced;
import com.creativemd.littletiles.common.utils.shape.DragShapeSphere;
import com.creativemd.littletiles.common.utils.shape.DragShapeWall;
import com.creativemd.littletiles.common.utils.shape.SelectShape;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DragShape {
    public static LinkedHashMap<String, DragShape> shapes = new LinkedHashMap();
    public static DragShape box = new DragShapeBox();
    public static DragShape sphere = new DragShapeSphere();
    public static DragShape cylinder = new DragShapeCylinder();
    public static DragShape wall = new DragShapeWall();
    public static DragShape line = new DragShapeLine();
    public static DragShape slice = new DragShapeSliced();
    public static DragShape defaultShape = box;
    public final String key;

    public static DragShape getShape(String name) {
        DragShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public DragShape(String name) {
        shapes.put(name, this);
        this.key = name;
        new SelectShape.DragSelectShape(this);
    }

    public abstract LittleBoxes getBoxes(LittleBoxes var1, LittleTileVec var2, LittleTileVec var3, EntityPlayer var4, NBTTagCompound var5, boolean var6, LittleTilePos var7, LittleTilePos var8);

    public abstract void addExtraInformation(NBTTagCompound var1, List<String> var2);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2, LittleGridContext var3);

    public abstract void rotate(NBTTagCompound var1, Rotation var2);

    public abstract void flip(NBTTagCompound var1, EnumFacing.Axis var2);
}

