/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.tooltip;

import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.util.text.translation.I18n;

public class TooltipUtils {
    public static String printRGB(int color) {
        int r = ColorUtils.getRed((int)color);
        int g = ColorUtils.getGreen((int)color);
        int b = ColorUtils.getBlue((int)color);
        int a = ColorUtils.getAlpha((int)color);
        return "" + ChatFormatting.RED + r + " " + ChatFormatting.GREEN + g + " " + ChatFormatting.BLUE + b + (a < 255 ? " " + ChatFormatting.WHITE + a : "");
    }

    public static String printVolume(double volume, boolean extended) {
        String text = "";
        int fullBlocks = (int)volume;
        int pixels = (int)Math.ceil((volume - (double)fullBlocks) * (double)LittleGridContext.get().maxTilesPerBlock);
        if (fullBlocks > 0) {
            text = text + fullBlocks + (extended ? " " + (fullBlocks == 1 ? I18n.func_74838_a((String)"volume.unit.big.single") : I18n.func_74838_a((String)"volume.unit.big.multiple")) : I18n.func_74838_a((String)"volume.unit.big.short"));
        }
        if (pixels > 0) {
            if (fullBlocks > 0) {
                text = text + " ";
            }
            text = text + pixels + (extended ? " " + (pixels == 1 ? I18n.func_74838_a((String)"volume.unit.small.single") : I18n.func_74838_a((String)"volume.unit.small.multiple")) : I18n.func_74838_a((String)"volume.unit.small.short"));
        }
        return text;
    }
}

