/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import futurepack.api.ItemPredicates;
import futurepack.common.crafting.FPZentrifugeManager;
import futurepack.common.crafting.ZentrifugeRecipe;
import futurepack.depend.api.OreDictPredicate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleFuturePack
extends ModuleBase {
    public static final HashMap<IOreEntry, String> ORE_SECONDARIES = Maps.newHashMap();

    @Override
    public String getName() {
        return "futurepack";
    }

    @Override
    public List<String> getDependencies() {
        return Lists.newArrayList((Object[])new String[]{"dust"});
    }

    @Override
    public EnumSet<EnumOreType> getOreTypes() {
        return Utils.enumSetOf((Enum[])EnumOreType.ORE);
    }

    @Override
    public List<String> getOreBlacklist() {
        return Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Tin", "Copper", "Zinc", "Magnetite", "Silver", "Lead", "Iridium", "Titanium", "Unobtainium", "Tungsten", "Platinum", "Cobalt", "Naquadah", "Nickel", "Molybdenum", "Wulfenit", "Beryllium", "Manganese", "Magnesium", "DevilsIron", "Diamond", "Emerald", "Lapis", "Quartz", "Ruby", "Amethyst", "Cinnabar", "Apatite", "Olivine", "Coal", "Sulfur", "Pyrite"});
    }

    @Override
    public void registerConfigs(Configuration config) {
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            String value = config.get(Utils.to_under_score(entry.getOreName()), "futurePackSecondary", "minecraft:cobblestone@0x3", "Secondary output of this ore using the centrifuge. (FuturePack)").setRequiresMcRestart(true).getString();
            ORE_SECONDARIES.put(entry, value);
        }
    }

    @Override
    public void init() {
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            switch (entry.getOreType()) {
                case DUST: {
                    ModuleFuturePack.addCentrifugeRecipe("ore" + entry.getOreName(), 4, new ItemStack[]{Utils.getOreStack("dust", entry, 12), Utils.parseItemStack(ORE_SECONDARIES.get(entry)), ModuleFuturePack.getExtraStack(entry)}, Utils.energyI(entry, 6.0), Utils.energyI(entry, 200.0));
                    break;
                }
                case GEM: {
                    ModuleFuturePack.addCentrifugeRecipe("ore" + entry.getOreName(), 4, new ItemStack[]{Utils.getOreStack("gem", entry, 12), Utils.parseItemStack(ORE_SECONDARIES.get(entry)), ModuleFuturePack.getExtraStack(entry)}, Utils.energyI(entry, 6.0), Utils.energyI(entry, 200.0));
                    break;
                }
                case INGOT: {
                    ModuleFuturePack.addCentrifugeRecipe("ore" + entry.getOreName(), 4, new ItemStack[]{Utils.getOreStack("dust", entry, 10), Utils.parseItemStack(ORE_SECONDARIES.get(entry)), ModuleFuturePack.getExtraStack(entry)}, Utils.energyI(entry, 6.0), Utils.energyI(entry, 200.0));
                    break;
                }
            }
        }
    }

    public static ItemStack getExtraStack(IOreEntry entry) {
        switch (Utils.oreNameToType(entry.getExtra())) {
            case GEM: {
                return Utils.getOreStackExtra("gem", entry, 1);
            }
            case DUST: 
            case INGOT: {
                return Utils.getOreStackExtra("dust", entry, 3);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void addCentrifugeRecipe(ItemStack in, ItemStack[] out, int support, int time) {
        ZentrifugeRecipe recipe = FPZentrifugeManager.addRecipe((ItemStack)in, (ItemStack[])out, (int)support);
        recipe.setTime(time);
    }

    public static void addCentrifugeRecipe(String in, int size, ItemStack[] out, int support, int time) {
        ZentrifugeRecipe recipe = FPZentrifugeManager.addRecipe((ItemPredicates)new OreDictPredicate(in, size), (ItemStack[])out, (int)support);
        recipe.setTime(time);
    }
}

