/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.IChiselFace;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.asm.CTMCoreMethods;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelUtil;
import team.chisel.ctm.client.state.CTMExtendedState;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
implements IBakedModel {
    private static Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    @Nonnull
    private final IModelCTM model;
    @Nonnull
    private final IBakedModel parent;
    @Nonnull
    private final Overrides overrides = new Overrides();
    protected final ListMultimap<BlockRenderLayer, BakedQuad> genQuads = MultimapBuilder.enumKeys(BlockRenderLayer.class).arrayListValues().build();
    protected final Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> faceQuads = Tables.newCustomTable((Map)Maps.newEnumMap(BlockRenderLayer.class), () -> Maps.newEnumMap(EnumFacing.class));
    private final EnumMap<EnumFacing, ImmutableList<BakedQuad>> noLayerCache = new EnumMap(EnumFacing.class);
    private ImmutableList<BakedQuad> noSideNoLayerCache;
    public static final Map<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)AbstractCTMBakedModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).build();
    public static final TRSRTransformation DEFAULT_TRANSFORM = AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    protected static final BlockRenderLayer[] LAYERS = BlockRenderLayer.values();

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ImmutableList<BakedQuad> ret;
        if (CTMCoreMethods.renderingDamageModel.get().booleanValue()) {
            return this.parent.func_188616_a(state, side, rand);
        }
        IBakedModel parent = this.getParent(rand);
        ProfileUtil.start("ctm_models");
        AbstractCTMBakedModel baked = this;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (Minecraft.func_71410_x().field_71441_e != null && state instanceof CTMExtendedState) {
            ProfileUtil.start("state_creation");
            CTMExtendedState ext = (CTMExtendedState)state;
            RenderContextList ctxList = ext.getContextList(ext.getClean(), baked);
            Object2LongMap<ICTMTexture<?>> serialized = ctxList.serialized();
            ProfileUtil.endAndStart("model_creation");
            baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(ext.getClean(), serialized, parent), () -> this.createModel(state, this.model, ctxList, rand));
            ProfileUtil.end();
        } else if (state != null) {
            ProfileUtil.start("model_creation");
            baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, null, this.getParent(rand)), () -> this.createModel(state, this.model, null, rand));
            ProfileUtil.end();
        }
        ProfileUtil.start("quad_lookup");
        if (side != null && layer != null) {
            ret = (List)baked.faceQuads.get((Object)layer, (Object)side);
        } else if (side != null) {
            AbstractCTMBakedModel _baked = baked;
            ret = (List)this.noLayerCache.computeIfAbsent(side, f -> ImmutableList.copyOf((Collection)_baked.faceQuads.column(f).values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        } else if (layer != null) {
            ret = baked.genQuads.get((Object)layer);
        } else {
            ret = this.noSideNoLayerCache;
            if (ret == null) {
                ret = this.noSideNoLayerCache = ImmutableList.copyOf((Collection)baked.genQuads.values().stream().distinct().collect(Collectors.toList()));
            }
        }
        ProfileUtil.end();
        ProfileUtil.end();
        return ret;
    }

    @Nonnull
    public IBakedModel getParent(long rand) {
        if (this.getParent() instanceof WeightedBakedModel) {
            return ((WeightedBakedModel)this.parent).func_188627_a(rand);
        }
        return this.getParent();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        IChiselFace face = this.model.getDefaultFace();
        return face != null ? face.getParticle() : this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)TRANSFORMS.getOrDefault(cameraTransformType, DEFAULT_TRANSFORM).getMatrix());
    }

    protected abstract AbstractCTMBakedModel createModel(IBlockState var1, @Nonnull IModelCTM var2, RenderContextList var3, long var4);

    protected AbstractCTMBakedModel withNewParent(@Nonnull IBakedModel parent) {
        return new ModelBakedCTM(this.getModel(), parent);
    }

    private <T> T applyToParent(long rand, Function<AbstractCTMBakedModel, T> func) {
        IBakedModel parent = this.getParent(rand);
        if (parent instanceof AbstractCTMBakedModel) {
            return func.apply((AbstractCTMBakedModel)parent);
        }
        return null;
    }

    protected ICTMTexture<?> getOverrideTexture(long rand, int tintIndex, String iconName) {
        ICTMTexture ret = this.getModel().getOverrideTexture(tintIndex, iconName);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideTexture(rand, tintIndex, iconName));
        }
        return ret;
    }

    protected ICTMTexture<?> getTexture(long rand, String iconName) {
        ICTMTexture ret = this.getModel().getTexture(iconName);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, iconName));
        }
        return ret;
    }

    protected TextureAtlasSprite getOverrideSprite(long rand, int tintIndex) {
        TextureAtlasSprite ret = this.getModel().getOverrideSprite(tintIndex);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
        }
        return ret;
    }

    public Collection<ICTMTexture<?>> getCTMTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getModel().getCTMTextures());
        if (this.getParent() instanceof AbstractCTMBakedModel) {
            builder.addAll(((AbstractCTMBakedModel)this.getParent()).getCTMTextures());
        }
        return builder.build();
    }

    @ConstructorProperties(value={"model", "parent"})
    public AbstractCTMBakedModel(@Nonnull IModelCTM model, @Nonnull IBakedModel parent) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.model = model;
        this.parent = parent;
    }

    @Nonnull
    public IModelCTM getModel() {
        return this.model;
    }

    @Nonnull
    public IBakedModel getParent() {
        return this.parent;
    }

    private static class State {
        @Nonnull
        private final IBlockState cleanState;
        @Nullable
        private final Object2LongMap<ICTMTexture<?>> serializedContext;
        @Nonnull
        private final IBakedModel parent;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            if (this.parent != other.parent) {
                return false;
            }
            return !(this.serializedContext == null ? other.serializedContext != null : !this.serializedContext.equals(other.serializedContext));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            return result;
        }

        @Nonnull
        public IBlockState getCleanState() {
            return this.cleanState;
        }

        @Nullable
        public Object2LongMap<ICTMTexture<?>> getSerializedContext() {
            return this.serializedContext;
        }

        @Nonnull
        public IBakedModel getParent() {
            return this.parent;
        }

        @ConstructorProperties(value={"cleanState", "serializedContext", "parent"})
        public State(@Nonnull IBlockState cleanState, @Nullable Object2LongMap<ICTMTexture<?>> serializedContext, @Nonnull IBakedModel parent) {
            if (cleanState == null) {
                throw new NullPointerException("cleanState");
            }
            if (parent == null) {
                throw new NullPointerException("parent");
            }
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
            this.parent = parent;
        }

        public String toString() {
            return "AbstractCTMBakedModel.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ", parent=" + this.getParent() + ")";
        }
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrideList {
        public Overrides() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ResourceLocation location;
            IBlockState state;
            Block block = null;
            if (stack.func_77973_b() instanceof ItemBlock) {
                block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            }
            IBlockState iBlockState = state = block == null ? null : block.func_176223_P();
            if (!stack.func_190926_b() && stack.func_77973_b().func_185040_i() && (location = AbstractCTMBakedModel.this.parent.func_188617_f().func_188021_a(stack, world, entity)) != null) {
                ModelResourceLocation overrideLoc = ModelLoader.getInventoryVariant((String)location.toString());
                IBakedModel newParent = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(overrideLoc);
                return (IBakedModel)itemcache.get((Object)overrideLoc, () -> AbstractCTMBakedModel.this.withNewParent(newParent).createModel(state, AbstractCTMBakedModel.this.model, null, 0L));
            }
            ModelResourceLocation mrl = ModelUtil.getMesh(stack);
            if (mrl == null) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            return (IBakedModel)itemcache.get((Object)mrl, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, null, 0L));
        }
    }
}

