/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.plugins.vanilla.BlockDrop;
import cubex2.cs4.util.IntRange;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class BlockDropDeserializer
implements JsonDeserializer<BlockDrop> {
    public BlockDrop deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement amountElem = this.getAndRemoveElem(json, "amount");
        JsonElement fortuneElem = this.getAndRemoveElem(json, "fortuneAmount");
        WrappedItemStack item = (WrappedItemStack)context.deserialize(json, WrappedItemStack.class);
        IntRange amount = amountElem != null ? (IntRange)context.deserialize(amountElem, IntRange.class) : IntRange.create(1, 1);
        IntRange fortuneAmount = fortuneElem != null ? (IntRange)context.deserialize(fortuneElem, IntRange.class) : IntRange.ZERO;
        return new BlockDrop(item, amount, fortuneAmount);
    }

    @Nullable
    private JsonElement getAndRemoveElem(JsonElement json, String elemName) {
        JsonObject object;
        JsonElement elem = null;
        if (json.isJsonObject() && (object = json.getAsJsonObject()).has(elemName)) {
            elem = object.get(elemName);
            object.remove(elemName);
        }
        return elem;
    }
}

