/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import cubex2.cs4.mixin.Mixin;
import cubex2.cs4.plugins.vanilla.BlockCarpetWithSubtypes;
import cubex2.cs4.plugins.vanilla.ContentBlockBase;
import cubex2.cs4.plugins.vanilla.ContentBlockButton;
import cubex2.cs4.plugins.vanilla.ContentBlockCarpet;
import cubex2.cs4.plugins.vanilla.ContentBlockCrops;
import cubex2.cs4.plugins.vanilla.ContentBlockFence;
import cubex2.cs4.plugins.vanilla.ContentBlockFenceGate;
import cubex2.cs4.plugins.vanilla.ContentBlockFluid;
import cubex2.cs4.plugins.vanilla.ContentBlockOrientable;
import cubex2.cs4.plugins.vanilla.ContentBlockPane;
import cubex2.cs4.plugins.vanilla.ContentBlockPressurePlate;
import cubex2.cs4.plugins.vanilla.ContentBlockSimple;
import cubex2.cs4.plugins.vanilla.ContentBlockSlab;
import cubex2.cs4.plugins.vanilla.ContentBlockSnow;
import cubex2.cs4.plugins.vanilla.ContentBlockStairs;
import cubex2.cs4.plugins.vanilla.ContentBlockTorch;
import cubex2.cs4.plugins.vanilla.ContentBlockTrapDoor;
import cubex2.cs4.plugins.vanilla.ContentBlockWall;
import cubex2.cs4.plugins.vanilla.block.BlockButton;
import cubex2.cs4.plugins.vanilla.block.BlockCarpet;
import cubex2.cs4.plugins.vanilla.block.BlockCrops;
import cubex2.cs4.plugins.vanilla.block.BlockFence;
import cubex2.cs4.plugins.vanilla.block.BlockFenceGate;
import cubex2.cs4.plugins.vanilla.block.BlockFenceWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockFluid;
import cubex2.cs4.plugins.vanilla.block.BlockMixin;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableDirectional;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableDirectionalWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableHorizontal;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableHorizontalWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableVertical;
import cubex2.cs4.plugins.vanilla.block.BlockOrientableVerticalWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockPane;
import cubex2.cs4.plugins.vanilla.block.BlockPaneWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockPressurePlate;
import cubex2.cs4.plugins.vanilla.block.BlockSimple;
import cubex2.cs4.plugins.vanilla.block.BlockSimpleWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockSlab;
import cubex2.cs4.plugins.vanilla.block.BlockSlabWithSubtypes;
import cubex2.cs4.plugins.vanilla.block.BlockSnow;
import cubex2.cs4.plugins.vanilla.block.BlockStairs;
import cubex2.cs4.plugins.vanilla.block.BlockTorch;
import cubex2.cs4.plugins.vanilla.block.BlockTrapDoor;
import cubex2.cs4.plugins.vanilla.block.BlockWall;
import cubex2.cs4.plugins.vanilla.block.BlockWallWithSubtypes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BlockFactory {
    private static Class<? extends Block> simpleClass = BlockFactory.createClass(BlockSimple.class, BlockMixin.class);
    private static Class<? extends Block> simpleSubtypeClass = BlockFactory.createClass(BlockSimpleWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> directionalClass = BlockFactory.createClass(BlockOrientableDirectional.class, BlockMixin.class);
    private static Class<? extends Block> directionalSubtypeClass = BlockFactory.createClass(BlockOrientableDirectionalWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> verticalClass = BlockFactory.createClass(BlockOrientableVertical.class, BlockMixin.class);
    private static Class<? extends Block> verticalSubtypeClass = BlockFactory.createClass(BlockOrientableVerticalWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> horizontalClass = BlockFactory.createClass(BlockOrientableHorizontal.class, BlockMixin.class);
    private static Class<? extends Block> horizontalSubtypeClass = BlockFactory.createClass(BlockOrientableHorizontalWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> fenceClass = BlockFactory.createClass(BlockFence.class, BlockMixin.class);
    private static Class<? extends Block> fenceSubtypeClass = BlockFactory.createClass(BlockFenceWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> stairsClass = BlockFactory.createClass(BlockStairs.class, BlockMixin.class);
    private static Class<? extends Block> slabClass = BlockFactory.createClass(BlockSlab.class, BlockMixin.class);
    private static Class<? extends Block> slabSubtypeClass = BlockFactory.createClass(BlockSlabWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> fluidClass = BlockFactory.createClass(BlockFluid.class, BlockMixin.class);
    private static Class<? extends Block> carpetClass = BlockFactory.createClass(BlockCarpet.class, BlockMixin.class);
    private static Class<? extends Block> carpetSubtypeClass = BlockFactory.createClass(BlockCarpetWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> snowClass = BlockFactory.createClass(BlockSnow.class, BlockMixin.class);
    private static Class<? extends Block> cropsClass = BlockFactory.createClass(BlockCrops.class, BlockMixin.class);
    private static Class<? extends Block> fenceGateClass = BlockFactory.createClass(BlockFenceGate.class, BlockMixin.class);
    private static Class<? extends Block> wallClass = BlockFactory.createClass(BlockWall.class, BlockMixin.class);
    private static Class<? extends Block> wallSubtypeClass = BlockFactory.createClass(BlockWallWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> trapDoorClass = BlockFactory.createClass(BlockTrapDoor.class, BlockMixin.class);
    private static Class<? extends Block> torchClass = BlockFactory.createClass(BlockTorch.class, BlockMixin.class);
    private static Class<? extends Block> buttonClass = BlockFactory.createClass(BlockButton.class, BlockMixin.class);
    private static Class<? extends Block> paneClass = BlockFactory.createClass(BlockPane.class, BlockMixin.class);
    private static Class<? extends Block> paneSubtypeClass = BlockFactory.createClass(BlockPaneWithSubtypes.class, BlockMixin.class);
    private static Class<? extends Block> pressurePlateClass = BlockFactory.createClass(BlockPressurePlate.class, BlockMixin.class);

    public static Block createSimple(ContentBlockSimple content) {
        return BlockFactory.newInstance(simpleClass, content);
    }

    public static Block createSimpleSubtype(ContentBlockSimple content) {
        return BlockFactory.newInstance(simpleSubtypeClass, content);
    }

    public static Block createDirectional(ContentBlockOrientable content) {
        return BlockFactory.newInstance(directionalClass, content);
    }

    public static Block createDirectionalSubtype(ContentBlockOrientable content) {
        return BlockFactory.newInstance(directionalSubtypeClass, content);
    }

    public static Block createVertical(ContentBlockOrientable content) {
        return BlockFactory.newInstance(verticalClass, content);
    }

    public static Block createVerticalSubtype(ContentBlockOrientable content) {
        return BlockFactory.newInstance(verticalSubtypeClass, content);
    }

    public static Block createHorizontal(ContentBlockOrientable content) {
        return BlockFactory.newInstance(horizontalClass, content);
    }

    public static Block createHorizontalSubtype(ContentBlockOrientable content) {
        return BlockFactory.newInstance(horizontalSubtypeClass, content);
    }

    public static Block createFence(ContentBlockFence content) {
        return BlockFactory.newInstance(fenceClass, content);
    }

    public static Block createFenceSubtype(ContentBlockFence content) {
        return BlockFactory.newInstance(fenceSubtypeClass, content);
    }

    public static Block createStairs(ContentBlockStairs content) {
        return BlockFactory.newInstance(stairsClass, content);
    }

    public static Block createSlab(ContentBlockSlab content) {
        return BlockFactory.newInstance(slabClass, content);
    }

    public static Block createSlabSubtype(ContentBlockSlab content) {
        return BlockFactory.newInstance(slabSubtypeClass, content);
    }

    public static Block createFluid(ContentBlockFluid content) {
        return BlockFactory.newInstance(fluidClass, content);
    }

    public static Block createCarpet(ContentBlockCarpet content) {
        return BlockFactory.newInstance(carpetClass, content);
    }

    public static Block createCarpetSubtype(ContentBlockCarpet content) {
        return BlockFactory.newInstance(carpetSubtypeClass, content);
    }

    public static Block createCrops(ContentBlockCrops content) {
        return BlockFactory.newInstance(cropsClass, content);
    }

    public static Block createSnow(ContentBlockSnow content) {
        return BlockFactory.newInstance(snowClass, content);
    }

    public static Block createFenceGate(ContentBlockFenceGate content) {
        return BlockFactory.newInstance(fenceGateClass, content);
    }

    public static Block createWall(ContentBlockWall content) {
        return BlockFactory.newInstance(wallClass, content);
    }

    public static Block createWallSubtype(ContentBlockWall content) {
        return BlockFactory.newInstance(wallSubtypeClass, content);
    }

    public static Block createTrapDoor(ContentBlockTrapDoor content) {
        return BlockFactory.newInstance(trapDoorClass, content);
    }

    public static Block createTorch(ContentBlockTorch content) {
        return BlockFactory.newInstance(torchClass, content);
    }

    public static Block createButton(ContentBlockButton content) {
        return BlockFactory.newInstance(buttonClass, content);
    }

    public static Block createPane(ContentBlockPane content) {
        return BlockFactory.newInstance(paneClass, content);
    }

    public static Block createPaneSubtype(ContentBlockPane content) {
        return BlockFactory.newInstance(paneSubtypeClass, content);
    }

    public static Block createPressurePlate(ContentBlockPressurePlate content) {
        return BlockFactory.newInstance(pressurePlateClass, content);
    }

    private static <T extends ContentBlockBase> Block newInstance(Class<? extends Block> blockClass, T content) {
        try {
            return blockClass.getConstructor(Material.class, content.getClass()).newInstance(content.material, content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends Block> createClass(Class<?> baseClass, Class<?> ... mixins) {
        return Mixin.create(baseClass.getName().replace('.', '/') + "_created", BlockFactory::checkForPublicConstructor, baseClass, mixins);
    }

    private static void checkForPublicConstructor(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || (method.access & 1) != 1) continue;
            return;
        }
        throw new RuntimeException(" Block Class " + node.name + " has no public constructor");
    }
}

