/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.util.NBTUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTimeAccelerator
extends Entity
implements IEntityAdditionalSpawnData {
    int remainingTime;
    private static final DataParameter<Integer> TIME_RATE = EntityDataManager.func_187226_a(EntityTimeAccelerator.class, (DataSerializer)DataSerializers.field_187192_b);
    BlockPos target;
    static Class clazz;

    public EntityTimeAccelerator(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
        this.field_70180_af.func_187214_a(TIME_RATE, (Object)1);
    }

    public EntityTimeAccelerator(World worldIn, BlockPos target, double posX, double posY, double posZ) {
        this(worldIn);
        this.target = target;
        this.func_70107_b(posX, posY, posZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(int remainingTime) {
        this.remainingTime = remainingTime;
    }

    public void func_70030_z() {
        super.func_70030_z();
        TileEntity targetTE = this.field_70170_p.func_175625_s(this.target);
        boolean horror = false;
        if (clazz != null && targetTE instanceof ITickable) {
            horror = clazz.isInstance(targetTE);
        }
        for (int i = 0; i < this.getTimeRate(); ++i) {
            IBlockState targetBlock;
            targetTE = this.field_70170_p.func_175625_s(this.target);
            if (!(targetTE == null || !(targetTE instanceof ITickable) || horror && this.field_70170_p.field_72995_K)) {
                ((ITickable)targetTE).func_73660_a();
            }
            if (this.field_70170_p.field_73012_v.nextInt(1365) != 0 || !(targetBlock = this.field_70170_p.func_180495_p(this.target)).func_177230_c().func_149653_t()) continue;
            targetBlock.func_177230_c().func_180645_a(this.field_70170_p, this.target, targetBlock, this.field_70170_p.field_73012_v);
        }
        --this.remainingTime;
        if (this.remainingTime == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.target = NBTUtil.readBlockPosFromNBT(compound, "target");
        this.remainingTime = compound.func_74762_e("remainingTime");
        this.setTimeRate(compound.func_74762_e("timeRate"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        NBTUtil.writeBlockPosToNBT(compound, "target", this.target);
        compound.func_74768_a("remainingTime", this.remainingTime);
        compound.func_74768_a("timeRate", this.getTimeRate());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.target.func_177958_n());
        buffer.writeInt(this.target.func_177956_o());
        buffer.writeInt(this.target.func_177952_p());
    }

    public void readSpawnData(ByteBuf ad) {
        this.target = new BlockPos(ad.readInt(), ad.readInt(), ad.readInt());
    }

    public int getTimeRate() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_RATE);
    }

    public void setTimeRate(int timeRate) {
        this.field_70180_af.func_187227_b(TIME_RATE, (Object)timeRate);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    static {
        try {
            clazz = Class.forName("cofh.core.block.TileCore");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

