/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lumien.randomthings.handler.floo.FlooNetworkHandler;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.NBTUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityFlooBrick
extends TileEntityBase {
    boolean amMaster;
    UUID uuid;
    EnumFacing facing = EnumFacing.WEST;
    List<BlockPos> children = new ArrayList<BlockPos>();
    UUID masterUUID;

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.amMaster) {
            FlooNetworkHandler handler;
            TileEntity masterTE;
            if (this.masterUUID != null && (masterTE = (handler = FlooNetworkHandler.get(worldIn)).getFirePlaceTE(worldIn, this.masterUUID)) instanceof TileEntityFlooBrick) {
                ((TileEntityFlooBrick)masterTE).breakBlock(worldIn, masterTE.func_174877_v(), state);
            }
        } else {
            for (BlockPos children : this.children) {
                worldIn.func_175656_a(children, Blocks.field_150336_V.func_176223_P());
            }
            FlooNetworkHandler.get(worldIn).brokenMaster(worldIn, pos, this);
            worldIn.func_175656_a(this.field_174879_c, Blocks.field_150336_V.func_176223_P());
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K && this.uuid != null) {
            FlooNetworkHandler.get(this.field_145850_b).updatePosition(this.uuid, this.field_174879_c);
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74757_a("amMaster", this.amMaster);
        if (this.amMaster) {
            compound.func_74782_a("uuid", (NBTBase)net.minecraft.nbt.NBTUtil.func_186862_a((UUID)this.uuid));
            compound.func_74768_a("facing", this.facing.ordinal());
            NBTTagList childrenTagList = new NBTTagList();
            for (BlockPos pos : this.children) {
                NBTTagCompound childrenCompound = new NBTTagCompound();
                NBTUtil.writeBlockPosToNBT(childrenCompound, "pos", pos);
                childrenTagList.func_74742_a((NBTBase)childrenCompound);
            }
            compound.func_74782_a("children", (NBTBase)childrenTagList);
        } else if (this.masterUUID != null) {
            compound.func_74782_a("masterUUID", (NBTBase)net.minecraft.nbt.NBTUtil.func_186862_a((UUID)this.masterUUID));
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.amMaster = compound.func_74767_n("amMaster");
        if (this.amMaster) {
            this.uuid = net.minecraft.nbt.NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("uuid"));
            this.facing = EnumFacing.field_82609_l[compound.func_74762_e("facing")];
            NBTTagList childrenTagList = compound.func_150295_c("children", 10);
            for (int i = 0; i < childrenTagList.func_74745_c(); ++i) {
                NBTTagCompound childrenCompound = childrenTagList.func_150305_b(i);
                this.children.add(NBTUtil.readBlockPosFromNBT(childrenCompound, "pos"));
            }
        } else if (compound.func_74764_b("masterUUID")) {
            this.masterUUID = net.minecraft.nbt.NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("masterUUID"));
        }
    }

    public UUID getFirePlaceUid() {
        return this.amMaster ? this.uuid : this.masterUUID;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public boolean isMaster() {
        return this.amMaster;
    }

    public UUID getUid() {
        return this.uuid;
    }

    public void initToChild(UUID masterUUID) {
        this.amMaster = false;
        this.masterUUID = masterUUID;
    }

    public void initToMaster(List<BlockPos> brickList, EnumFacing teleportFacing, UUID uuid) {
        this.uuid = uuid;
        this.amMaster = true;
        this.children = brickList;
        this.facing = teleportFacing;
    }

    public List<BlockPos> getChildren() {
        return this.children;
    }
}

