/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.library.Gauge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

@net.minecraftforge.common.config.Config(modid="immersiverailroading")
public class Config {
    public static ConfigDamage damage;
    public static ConfigBalance balance;
    public static ConfigDebug debug;

    public static void init() {
        if (ConfigBalance.dieselFuels.size() == 0) {
            ConfigBalance.dieselFuels.put("oil", 100);
            ConfigBalance.dieselFuels.put("oil_heavy", 70);
            ConfigBalance.dieselFuels.put("oil_dense", 110);
            ConfigBalance.dieselFuels.put("oil_distilled", 50);
            ConfigBalance.dieselFuels.put("fuel_dense", 110);
            ConfigBalance.dieselFuels.put("fuel_mixed_heavy", 130);
            ConfigBalance.dieselFuels.put("fuel_light", 150);
            ConfigBalance.dieselFuels.put("fuel_mixed_light", 100);
            ConfigBalance.dieselFuels.put("diesel", 200);
            ConfigBalance.dieselFuels.put("biodiesel", 170);
            ConfigBalance.dieselFuels.put("biofuel", 170);
            ConfigBalance.dieselFuels.put("ethanol", 170);
            ConfigBalance.dieselFuels.put("gasoline", 100);
            ConfigBalance.dieselFuels.put("refined_fuel", 150);
            ConfigBalance.dieselFuels.put("refined_oil", 100);
            ConfigBalance.dieselFuels.put("lpg", 150);
            ConfigBalance.dieselFuels.put("kerosene", 180);
            ConfigBalance.dieselFuels.put("fuel", 180);
            ConfigBalance.dieselFuels.put("olive_oil", 40);
            ConfigManager.sync((String)"immersiverailroading", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static boolean isFuelRequired(Gauge gauge) {
        return ConfigBalance.FuelRequired && (ConfigBalance.ModelFuelRequired || !gauge.isModel());
    }

    public static class ConfigDebug {
        @Config.Comment(value={"Speed up IR stock server tick stepping to compensate for tps lag"})
        public static boolean serverTickCompensation = true;
        @Config.Comment(value={"Range between couplers to try coupling"})
        public static double couplerRange = 0.3;
        @Config.Comment(value={"Deep Snow on tracks"})
        public static boolean deepSnow = false;
        @Config.Comment(value={"How fast deep snow should melt, 0 = disabled, 20 = fast, 400 = slow"})
        public static int snowMeltRate = 0;
        @Config.Comment(value={"Keep rolling stock loaded even when it is not moving"})
        public static boolean keepStockLoaded = false;
        @Config.Comment(value={"Print extra chunk loading info"})
        public static boolean debugLog = false;
        @Config.Comment(value={"DEBUG: Buckets infinite fill/empty tanks"})
        public static boolean debugInfiniteLiquids = false;
        @Config.Comment(value={"Time between open computers poll ticks for augments"})
        public static int ocPollDelayTicks = 1;
        @Config.Comment(value={"DEV ONLY: How much to artifically lag the server (per world)"})
        public static int lagServer = 0;
        @Config.Comment(value={"Old Narrow track placement (single width instead of 3)"})
        public static boolean oldNarrowWidth = false;
    }

    public static class ConfigBalance {
        @Config.Comment(value={"Models require fuel"})
        public static boolean ModelFuelRequired = true;
        @Config.Comment(value={"All gauges require fuel"})
        public static boolean FuelRequired = true;
        @Config.Comment(value={"Slope Multiplier: Higher numbers increase slowdown, lower numbers decrease slowdown"})
        public static double slopeMultiplier = 1.0;
        @Config.Comment(value={"Brake Multiplier: Higher numbers increase slowdown, lower numbers decrease slowdown"})
        public static double brakeMultiplier = 1.0;
        @Config.Comment(value={"Traction Multiplier: Higher numbers decreases wheel slip, lower numders increase wheel slip"})
        public static double tractionMultiplier = 1.0;
        @Config.Comment(value={"How heavy is a single block in Kg"})
        public static int blockWeight = 10;
        @Config.Comment(value={"MilliBuckets per Liter"})
        public static int MB_PER_LITER = 1;
        @Config.Comment(value={"Cost to place down a tie"})
        public static double TieCostMultiplier = 0.25;
        @Config.Comment(value={"Cost to place down a rail"})
        public static double RailCostMultiplier = 0.25;
        @Config.Comment(value={"Cost to place down rail bed"})
        public static double BedCostMultiplier = 0.25;
        @Config.Comment(value={"If more than X% of the tracks are above non solid blocks, break the track"})
        public static double trackFloatingPercent = 0.05;
        @Config.Comment(value={"Diesel Fuel Efficiency"})
        public static int locoDieselFuelEfficiency = 100;
        @Config.Comment(value={"Steam Fuel Efficiency"})
        public static int locoSteamFuelEfficiency = 100;
        @Config.Comment(value={"How fast the steam locomotive should heat up.  1 is real world (slow), 72 is scaled to minecraft time"})
        public static int locoHeatTimeScale = 72;
        @Config.Comment(value={"How fast the diesel locomotive should heat up. 1 is real world (slow), 72 is scaled to minecraft time"})
        public static int dieselLocoHeatTimeScale = 72;
        @Config.Comment(value={"How much water the locomotive should use"})
        public static float locoWaterUsage = 10.0f;
        @Config.Comment(value={"How much you get payed per meter the villager traveled (default 1 emerald per km)"})
        public static double villagerPayoutPerMeter = 0.001;
        @Config.Comment(value={"Distance the villagers will hear the conductor's whistle"})
        public static double villagerConductorDistance = 50.0;
        @Config.Comment(value={"Villager payout items"})
        public static String[] villagerPayoutItems = new String[]{Items.field_151166_bC.getRegistryName().toString()};
        @Config.Comment(value={"Fuels for diesel Locomotives\nNote: Naphtha of Thermal Foundation is internally registered as 'refined oil'."})
        public static Map<String, Integer> dieselFuels = new HashMap<String, Integer>();
        @Config.Comment(value={"Water Substitutes"})
        public static String[] waterTypes = new String[]{"water", "dist_water", "hot_spring_water", "purified_water"};
        @Config.Comment(value={"Allow diesel locomotive engine overheating"})
        public static boolean canDieselEnginesOverheat = true;
        @Config.Comment(value={"Only select Locomotives with suitable equipment can be radio-controlled"})
        public static boolean RadioEquipmentRequired = true;
        @Config.Comment(value={"Range of radio-control, positive integer"})
        public static int RadioRange = 500;
        @Config.Comment(value={"Energy cost (RF) per radio transmission per metre"})
        public static int RadioCostPerMetre = 0;
        @Config.Comment(value={"Prevent stock from being built outside the recommended and model gauges"})
        public static boolean DesignGaugeLock = false;

        public static List<Item> getVillagerPayout() {
            ArrayList<Item> items = new ArrayList<Item>();
            for (String irl : villagerPayoutItems) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(irl));
                if (item == null) continue;
                items.add(item);
            }
            return items;
        }
    }

    public static class ConfigDamage {
        @Config.Comment(value={"Enable Boiler Explosions"})
        public static boolean explosionsEnabled = true;
        @Config.Comment(value={"Enable environmental damage of Boiler Explosions"})
        public static boolean explosionEnvDamageEnabled = true;
        @Config.Comment(value={"km/h to damage 1 heart on collision"})
        public static double entitySpeedDamage = 10.0;
        @Config.Comment(value={"Trains should break blocks"})
        public static boolean TrainsBreakBlocks = true;
        @Config.Comment(value={"Break blocks around the border of the tracks in creative"})
        public static boolean enableSideBlockClearing = true;
        @Config.Comment(value={"Clear blocsk in creative mode when placing tracks"})
        public static boolean creativePlacementClearsBlocks = true;
        @Config.Comment(value={"Requires solid blocks to be placed under the rails"})
        public static boolean requireSolidBlocks = true;
        @Config.Comment(value={"Drop snowballs when the train can't push a block out of the way"})
        public static boolean dropSnowBalls = false;
        @Config.Comment(value={"Trains get destroyed by Mob explosions"})
        public static boolean trainMobExplosionDamage = true;
    }
}

