/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.entity.CarTank;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.registry.TenderDefinition;
import cam72cam.immersiverailroading.util.LiquidUtil;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class Tender
extends CarTank {
    public Tender(World world) {
        this(world, null);
    }

    public Tender(World world, String defID) {
        super(world, defID);
    }

    @Override
    public TenderDefinition getDefinition() {
        return super.getDefinition(TenderDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.TENDER;
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return LiquidUtil.getWater();
    }

    @Override
    public int getInventorySize() {
        return this.getDefinition().getInventorySize(this.gauge) + 2;
    }

    public int getInventoryWidth() {
        return this.getDefinition().getInventoryWidth(this.gauge);
    }

    @Override
    protected void initContainerFilter() {
        this.cargoItems.filter.clear();
        this.cargoItems.filter.put(this.getInventorySize() - 2, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.filter.put(this.getInventorySize() - 1, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.defaultFilter = SlotFilter.BURNABLE;
    }

    @Override
    protected int[] getContainerInputSlots() {
        return new int[]{this.getInventorySize() - 2};
    }

    @Override
    protected int[] getContainertOutputSlots() {
        return new int[]{this.getInventorySize() - 1};
    }
}

