/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ItemPickerGUI;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.OreHelper;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CraftPicker
extends GuiScreen {
    private ItemPickerGUI stockSelector;
    private ItemPickerGUI itemSelector;
    private NonNullList<ItemStack> items;
    private Consumer<ItemStack> onChoose;

    public CraftPicker(ItemStack current, CraftingType craftType, Consumer<ItemStack> onChoose) {
        this.onChoose = onChoose;
        this.items = NonNullList.func_191196_a();
        IRItems.ITEM_ROLLING_STOCK_COMPONENT.func_150895_a(ItemTabs.COMPONENT_TAB, this.items);
        NonNullList stock = NonNullList.func_191196_a();
        IRItems.ITEM_ROLLING_STOCK.func_150895_a(ItemTabs.LOCOMOTIVE_TAB, (NonNullList<ItemStack>)stock);
        IRItems.ITEM_ROLLING_STOCK.func_150895_a(ItemTabs.PASSENGER_TAB, (NonNullList<ItemStack>)stock);
        IRItems.ITEM_ROLLING_STOCK.func_150895_a(ItemTabs.STOCK_TAB, (NonNullList<ItemStack>)stock);
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            boolean isCastable;
            EntityRollingStockDefinition def;
            ItemComponentType comp = ItemComponent.getComponentType(item);
            if (comp.isWooden(def = ItemDefinition.get(item))) {
                toRemove.add(item);
                continue;
            }
            boolean bl = isCastable = craftType == CraftingType.CASTING && comp.crafting == CraftingType.CASTING_HAMMER;
            if (comp.crafting == craftType || isCastable) continue;
            toRemove.add(item);
        }
        this.items.removeAll(toRemove);
        this.stockSelector = new ItemPickerGUI((NonNullList<ItemStack>)stock, this::onStockExit);
        toRemove = new ArrayList();
        for (ItemStack itemStock : stock) {
            boolean hasComponent = false;
            for (ItemStack item : this.items) {
                if (!this.isPartOf(itemStock, item)) continue;
                hasComponent = true;
                break;
            }
            if (!hasComponent) {
                toRemove.add(itemStock);
                continue;
            }
            if (!this.isPartOf(itemStock, current)) continue;
            this.stockSelector.choosenItem = itemStock;
        }
        stock.removeAll(toRemove);
        if (craftType == CraftingType.CASTING) {
            stock.add((Object)new ItemStack((Item)IRItems.ITEM_CAST_RAIL, 1));
            stock.add(OreHelper.IR_STEEL_INGOT.getOres().get(0));
            stock.add(OreHelper.IR_STEEL_BLOCK.getOres().get(0));
            IRItems.ITEM_AUGMENT.func_150895_a(ItemTabs.MAIN_TAB, (NonNullList<ItemStack>)stock);
        }
        this.itemSelector = new ItemPickerGUI((NonNullList<ItemStack>)NonNullList.func_191196_a(), this::onItemExit);
        if (current != null && current.func_77973_b() == IRItems.ITEM_ROLLING_STOCK_COMPONENT) {
            this.itemSelector.choosenItem = current;
        }
    }

    private boolean isPartOf(ItemStack stock, ItemStack item) {
        if (stock == null || item == null) {
            return false;
        }
        if (stock.func_77973_b() != IRItems.ITEM_ROLLING_STOCK) {
            return false;
        }
        if (item.func_77973_b() != IRItems.ITEM_ROLLING_STOCK_COMPONENT) {
            return false;
        }
        return ItemDefinition.getID(item).equals(ItemDefinition.getID(stock));
    }

    private void setupItemSelector() {
        NonNullList filteredItems = NonNullList.func_191196_a();
        for (ItemStack item : this.items) {
            if (!this.isPartOf(this.stockSelector.choosenItem, item)) continue;
            filteredItems.add((Object)item);
        }
        this.itemSelector.setItems((NonNullList<ItemStack>)filteredItems);
    }

    private void onStockExit(ItemStack stack) {
        if (stack == null) {
            this.onChoose.accept(null);
        } else {
            this.setupItemSelector();
            if (this.itemSelector.hasOptions()) {
                this.field_146297_k.func_147108_a((GuiScreen)this.itemSelector);
            } else {
                this.itemSelector.choosenItem = null;
                this.onChoose.accept(stack);
            }
        }
    }

    private void onItemExit(ItemStack stack) {
        if (stack == null) {
            this.field_146297_k.func_147108_a((GuiScreen)this.stockSelector);
        } else {
            this.onChoose.accept(stack);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.stockSelector.choosenItem != null) {
            this.setupItemSelector();
            if (this.itemSelector.hasOptions()) {
                this.field_146297_k.func_147108_a((GuiScreen)this.itemSelector);
                return;
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.stockSelector);
    }
}

