/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.gui.GuiScrollBar;
import cam72cam.immersiverailroading.gui.ItemButton;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;

public class ItemPickerGUI
extends GuiScreen {
    private NonNullList<ItemStack> items;
    private List<Vec3i> buttonCoordList = Lists.newArrayList();
    public ItemStack choosenItem;
    private Consumer<ItemStack> onExit;
    private GuiScrollBar scrollBar;

    public ItemPickerGUI(NonNullList<ItemStack> items, Consumer<ItemStack> onExit) {
        this.items = items;
        this.onExit = onExit;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
        this.func_73866_w_();
    }

    public boolean hasOptions() {
        return this.items.size() != 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (button instanceof GuiScrollBar) continue;
            if (this.scrollBar != null) {
                button.field_146129_i = this.buttonCoordList.get(button.field_146127_k).func_177956_o() - (int)Math.floor(this.scrollBar.getValue() * 32.0);
            }
            if (!((ItemButton)button).isMouseOver(mouseX, mouseY)) continue;
            this.func_146285_a(((ItemButton)button).stack, mouseX, mouseY);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        int i;
        if (this.field_146294_l == 0 || this.field_146295_m == 0) {
            return;
        }
        int startX = this.field_146294_l / 16;
        int startY = this.field_146295_m / 8;
        int stacksX = this.field_146294_l * 7 / 8 / 32;
        int stacksY = this.field_146295_m * 7 / 8 / 32;
        this.field_146292_n.clear();
        this.buttonCoordList.clear();
        startX += Math.max(0, (stacksX - this.items.size()) / 2) * 32;
        for (i = 0; i < this.items.size(); ++i) {
            int col = i % stacksX;
            int row = i / stacksX;
            this.field_146292_n.add(new ItemButton(i, (ItemStack)this.items.get(i), startX + col * 32, startY + row * 32));
            this.buttonCoordList.add(new Vec3i(startX + col * 32, startY + row * 32, 0));
        }
        int rows = i / stacksX + 2;
        if (stacksY < rows) {
            this.scrollBar = new GuiScrollBar(i++, this.field_146294_l - 30, 4, 20, this.field_146295_m - 8, "", 0.0, rows - stacksY, 0.0, null);
            this.field_146292_n.add(this.scrollBar);
        }
    }

    public void func_146284_a(GuiButton button) throws IOException {
        for (GuiButton itemButton : this.field_146292_n) {
            if (itemButton != button || button instanceof GuiScrollBar) continue;
            this.choosenItem = ((ItemButton)button).stack;
            this.onExit.accept(this.choosenItem);
            break;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.onExit.accept(null);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }
}

