/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mezz.jei.api.ingredients.ISlowRenderItem", modid="jei")
public class ItemTrackBlueprint
extends Item {
    public static final String NAME = "item_rail";

    public ItemTrackBlueprint() {
        this.func_77655_b("immersiverailroading:item_rail");
        this.setRegistryName(new ResourceLocation("immersiverailroading", NAME));
        this.func_77637_a(ItemTabs.MAIN_TAB);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K && handIn == EnumHand.MAIN_HAND) {
            playerIn.openGui((Object)ImmersiveRailroading.instance, GuiTypes.RAIL.ordinal(), worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == EnumHand.OFF_HAND) {
            RailSettings info = ItemTrackBlueprint.settings(stack);
            ItemStack blockinfo = world.func_180495_p(pos).func_177230_c().func_185473_a(world, pos, world.func_180495_p(pos));
            info = player.func_70093_af() ? new RailSettings(info.gauge, info.track, info.type, info.length, info.quarters, info.posType, info.direction, info.railBed, blockinfo, info.isPreview, info.isGradeCrossing) : new RailSettings(info.gauge, info.track, info.type, info.length, info.quarters, info.posType, info.direction, blockinfo, info.railBedFill, info.isPreview, info.isGradeCrossing);
            ItemTrackBlueprint.settings(stack, info);
            return EnumActionResult.SUCCESS;
        }
        if (BlockUtil.canBeReplaced(world, (pos = pos.func_177984_a()).func_177977_b(), true) && (!BlockUtil.isIRRail(world, pos.func_177977_b()) || (double)TileRailBase.get((IBlockAccess)world, pos.func_177977_b()).getRailHeight() < 0.5)) {
            pos = pos.func_177977_b();
        }
        PlacementInfo placementInfo = new PlacementInfo(stack, player.func_70079_am(), pos, hitX, hitY, hitZ);
        if (ItemTrackBlueprint.settings((ItemStack)stack).isPreview) {
            if (!BlockUtil.canBeReplaced(world, pos, false)) {
                pos = pos.func_177984_a();
            }
            world.func_175656_a(pos, IRBlocks.BLOCK_RAIL_PREVIEW.func_176223_P());
            TileRailPreview te = TileRailPreview.get((IBlockAccess)world, pos);
            if (te != null) {
                te.setup(stack, placementInfo);
            }
            return EnumActionResult.SUCCESS;
        }
        RailInfo info = new RailInfo(player.field_70170_p, stack, placementInfo, null);
        info.build(player);
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        RailSettings settings = ItemTrackBlueprint.settings(stack);
        tooltip.add(GuiText.TRACK_TYPE.toString(new Object[]{settings.type}));
        tooltip.add(GuiText.TRACK_GAUGE.toString(settings.gauge));
        tooltip.add(GuiText.TRACK_LENGTH.toString(settings.length));
        tooltip.add(GuiText.TRACK_POSITION.toString(new Object[]{settings.posType}));
        tooltip.add(GuiText.TRACK_DIRECTION.toString(new Object[]{settings.direction}));
        tooltip.add(GuiText.TRACK_RAIL_BED.toString(settings.railBed.func_82833_r()));
        tooltip.add(GuiText.TRACK_RAIL_BED_FILL.toString(settings.railBedFill.func_82833_r()));
        tooltip.add((settings.isPreview ? GuiText.TRACK_PLACE_BLUEPRINT_TRUE : GuiText.TRACK_PLACE_BLUEPRINT_FALSE).toString());
        tooltip.add(GuiText.TRACK_QUARTERS.toString((double)settings.quarters * 90.0 / 4.0));
    }

    public static void settings(ItemStack stack, RailSettings settings) {
        stack.func_77982_d(settings.toNBT());
    }

    public static RailSettings settings(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new RailSettings(stack.func_77978_p());
    }
}

