/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.util.math.Vec3d;

public class RenderComponent {
    public final RenderComponentType type;
    public final int id;
    public final String side;
    public final Set<String> modelIDs;
    public final String pos;
    public final double scale;
    private boolean wooden;
    public final Vec3d min;
    public final Vec3d max;

    public static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups) {
        return RenderComponent.parse(name, def, groups, -1, "", "");
    }

    public static RenderComponent parseID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id) {
        return RenderComponent.parse(name, def, groups, id, "", "");
    }

    public static RenderComponent parseSide(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String side) {
        return RenderComponent.parse(name, def, groups, -1, side, "");
    }

    public static RenderComponent parsePos(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos) {
        return RenderComponent.parse(name, def, groups, -1, "", pos);
    }

    public static RenderComponent parsePosID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos, int id) {
        return RenderComponent.parse(name, def, groups, id, "", pos);
    }

    private static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id, String side, String pos) {
        HashSet<String> modelIDs = new HashSet<String>();
        String idStr = id != -1 ? "" + id : "";
        boolean wooden = true;
        for (String group : groups) {
            if (!Pattern.matches(name.regex.replace("#SIDE#", side).replaceAll("#ID#", idStr).replaceAll("#POS#", pos), group)) continue;
            modelIDs.add(group);
            if (group.contains("WOOD")) continue;
            wooden = false;
        }
        if (modelIDs.size() == 0) {
            return null;
        }
        Vec3d min = def.getModel().minOfGroup(modelIDs);
        Vec3d max = def.getModel().maxOfGroup(modelIDs);
        groups.removeAll(modelIDs);
        return new RenderComponent(modelIDs, name, id, side, pos, 1.0, wooden, min, max);
    }

    private RenderComponent(Set<String> modelIDs, RenderComponentType type, int id, String side, String pos, double scale, boolean wooden, Vec3d min, Vec3d max) {
        this.modelIDs = modelIDs;
        this.type = type;
        this.id = id;
        this.side = side;
        this.pos = pos;
        this.scale = scale;
        this.wooden = wooden;
        this.min = min;
        this.max = max;
    }

    public Vec3d min() {
        return this.min.func_186678_a(this.scale);
    }

    public Vec3d max() {
        return this.max.func_186678_a(this.scale);
    }

    public Vec3d center() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return new Vec3d((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
    }

    public double height() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72448_b - min.field_72448_b;
    }

    public double length() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72450_a - min.field_72450_a;
    }

    public double width() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72449_c - min.field_72449_c;
    }

    public boolean isWooden() {
        return this.wooden;
    }

    public RenderComponent scale(Gauge gauge) {
        return new RenderComponent(this.modelIDs, this.type, this.id, this.side, this.pos, gauge.scale(), this.wooden, this.min, this.max);
    }

    public String toString() {
        return String.format("%s%s%s%s%s", new Object[]{this.type, this.id, this.side, this.pos, this.scale});
    }
}

