/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RailRollerMultiblock
extends Multiblock {
    public static final String NAME = "RAIL_MACHINE";
    private static final BlockPos render = new BlockPos(0, 0, 0);
    private static final BlockPos crafter = new BlockPos(1, 1, 15);
    private static final BlockPos input = new BlockPos(1, 0, 0);
    private static final BlockPos output = new BlockPos(1, 0, 29);
    private static final BlockPos power = new BlockPos(1, 2, 15);

    private static MultiblockComponent[][][] componentGenerator() {
        MultiblockComponent[][][] result = new MultiblockComponent[30][][];
        MultiblockComponent[] bed = new MultiblockComponent[]{RailRollerMultiblock.S_SCAF(), RailRollerMultiblock.S_SCAF()};
        for (int i = 0; i < 30; ++i) {
            result[i] = i >= 11 && i <= 18 ? new MultiblockComponent[][]{{RailRollerMultiblock.L_ENG(), RailRollerMultiblock.L_ENG()}, {RailRollerMultiblock.H_ENG(), RailRollerMultiblock.H_ENG()}, {RailRollerMultiblock.L_ENG(), RailRollerMultiblock.L_ENG()}} : new MultiblockComponent[][]{bed};
        }
        return result;
    }

    public RailRollerMultiblock() {
        super(NAME, RailRollerMultiblock.componentGenerator());
    }

    @Override
    public BlockPos placementPos() {
        return input;
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, BlockPos origin, Rotation rot) {
        return new RailRollerInstance(world, origin, rot);
    }

    public class RailRollerInstance
    extends Multiblock.MultiblockInstance {
        public RailRollerInstance(World world, BlockPos origin, Rotation rot) {
            super(RailRollerMultiblock.this, world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(EntityPlayer player, EnumHand hand, BlockPos offset) {
            if (this.world.field_72995_K) {
                return false;
            }
            if (!player.func_70093_af()) {
                ItemStack held = player.func_184586_b(hand);
                if (held.func_190926_b() && this.outputFull()) {
                    TileMultiblock outputTe = this.getTile(output);
                    if (outputTe == null) {
                        return false;
                    }
                    ItemStack outstack = outputTe.getContainer().getStackInSlot(0);
                    this.world.func_72838_d((Entity)new EntityItem(this.world, player.field_70165_t, player.field_70163_u, player.field_70161_v, outstack));
                    outputTe.getContainer().setStackInSlot(0, ItemStack.field_190927_a);
                } else if (held.func_77973_b() == IRItems.ITEM_CAST_RAIL) {
                    TileMultiblock inputTe = this.getTile(input);
                    if (inputTe == null) {
                        return false;
                    }
                    if (inputTe.getContainer().getStackInSlot(0).func_190926_b()) {
                        ItemStack inputStack = held.func_77946_l();
                        inputStack.func_190920_e(1);
                        inputTe.getContainer().setStackInSlot(0, inputStack);
                        held.func_190918_g(1);
                        player.func_184611_a(hand, held);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isRender(BlockPos offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(BlockPos offset) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public void tick(BlockPos offset) {
            if (!offset.equals((Object)crafter)) {
                return;
            }
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            TileMultiblock inputTe = this.getTile(input);
            if (inputTe == null) {
                return;
            }
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.field_72995_K) {
                if (craftingTe.getRenderTicks() % 10L == 0L && craftingTe.getCraftProgress() != 0) {
                    this.world.func_184134_a((double)craftingTe.func_174877_v().func_177958_n(), (double)craftingTe.func_174877_v().func_177956_o(), (double)craftingTe.func_174877_v().func_177952_p(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 0.2f, false);
                }
                return;
            }
            if (craftingTe.getCraftProgress() != 0) {
                IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
                energy.extractEnergy(32, false);
                craftingTe.setCraftProgress(Math.max(0, craftingTe.getCraftProgress() - 1));
            }
            float progress = craftingTe.getCraftProgress();
            ItemStack input = inputTe.getContainer().getStackInSlot(0);
            ItemStack output = outputTe.getContainer().getStackInSlot(0);
            if (progress == 0.0f && input.func_77973_b() == IRItems.ITEM_CAST_RAIL && output.func_190926_b()) {
                progress = 100.0f;
                craftingTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = new ItemStack((Item)IRItems.ITEM_RAIL, 10);
                ItemGauge.set(out, ItemGauge.get(input));
                outputTe.getContainer().setStackInSlot(0, out);
                input.func_190918_g(1);
                inputTe.getContainer().setStackInSlot(0, input);
            }
        }

        @Override
        public boolean canInsertItem(BlockPos offset, int slot, ItemStack stack) {
            return offset.equals((Object)input) && stack.func_77973_b() == IRItems.ITEM_CAST_RAIL;
        }

        @Override
        public boolean isOutputSlot(BlockPos offset, int slot) {
            return offset.equals((Object)output);
        }

        @Override
        public int getSlotLimit(BlockPos offset, int slot) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(BlockPos offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
            return energy.getEnergyStored() > 32;
        }

        public int getCraftProgress() {
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return 0;
            }
            return craftingTe.getCraftProgress();
        }

        public boolean outputFull() {
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return false;
            }
            return !outputTe.getContainer().getStackInSlot(0).func_190926_b();
        }
    }
}

