/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.sound.ISound;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SoundPacket
implements IMessage {
    private String soundfile;
    private Vec3d pos;
    private Vec3d motion;
    private float volume;
    private float pitch;
    private int distance;
    private Gauge gauge;

    public SoundPacket() {
    }

    public SoundPacket(String soundfile, Vec3d pos, Vec3d motion, float volume, float pitch, int distance, Gauge gauge) {
        this.soundfile = soundfile;
        this.pos = pos;
        this.motion = motion;
        this.volume = volume;
        this.pitch = pitch;
        this.distance = distance;
        this.gauge = gauge;
    }

    public void fromBytes(ByteBuf buf) {
        this.soundfile = BufferUtil.readString(buf);
        this.pos = BufferUtil.readVec3d(buf);
        this.motion = BufferUtil.readVec3d(buf);
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.distance = buf.readInt();
        this.gauge = Gauge.from(buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        BufferUtil.writeString(buf, this.soundfile);
        BufferUtil.writeVec3d(buf, this.pos);
        BufferUtil.writeVec3d(buf, this.motion);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeInt(this.distance);
        buf.writeDouble(this.gauge.value());
    }

    public static class Handler
    implements IMessageHandler<SoundPacket, IMessage> {
        public IMessage onMessage(SoundPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(SoundPacket message, MessageContext ctx) {
            ISound snd = ImmersiveRailroading.proxy.newSound(new ResourceLocation(message.soundfile), false, message.distance, message.gauge);
            snd.setVelocity(message.motion);
            snd.setVolume(message.volume);
            snd.setPitch(message.pitch);
            snd.disposable();
            snd.play(message.pos);
        }
    }
}

