/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import trackapi.lib.ITrack;
import trackapi.lib.Util;

public class MovementTrack {
    public static ITrack findTrack(World world, Vec3d currentPosition, float trainYaw, double gauge) {
        Vec3d[] positions = new Vec3d[]{currentPosition, currentPosition.func_178787_e(VecUtil.fromWrongYaw(1.0, trainYaw)), currentPosition.func_178787_e(VecUtil.fromWrongYaw(-1.0, trainYaw))};
        double[] heightSkew = new double[]{0.0, 0.25, -0.25, 0.5, -0.5, 0.75, -0.75};
        for (Vec3d pos : positions) {
            for (double height : heightSkew) {
                ITrack te = Util.getTileEntity((World)world, (Vec3d)pos.func_72441_c(0.0, height + currentPosition.field_72448_b % 1.0, 0.0), (boolean)true);
                if (te != null && Gauge.from(te.getTrackGauge()) == Gauge.from(gauge)) {
                    return te;
                }
                TileRailBase rail = TileRailBase.get((IBlockAccess)world, new BlockPos(pos.func_72441_c(0.0, height + currentPosition.field_72448_b % 1.0, 0.0)));
                if (rail == null || rail.getParentReplaced() == null) continue;
                return rail;
            }
        }
        return null;
    }

    public static Vec3d nextPosition(World world, Vec3d currentPosition, TileRail rail, float trainYaw, double distanceMeters) {
        double maxDelta = 0.5;
        if (distanceMeters > maxDelta) {
            ITrack te;
            for (double dist = 0.0; dist < distanceMeters - maxDelta; dist += maxDelta) {
                te = MovementTrack.findTrack(world, currentPosition, trainYaw, rail.getTrackGauge());
                if (te == null) {
                    return currentPosition;
                }
                Vec3d pastPos = currentPosition;
                currentPosition = te.getNextPosition(currentPosition, VecUtil.fromWrongYaw(maxDelta, trainYaw));
                trainYaw = VecUtil.toWrongYaw(pastPos.func_72444_a(currentPosition));
            }
            te = MovementTrack.findTrack(world, currentPosition, trainYaw, rail.getTrackGauge());
            if (te == null) {
                return currentPosition;
            }
            return te.getNextPosition(currentPosition, VecUtil.fromWrongYaw(distanceMeters % maxDelta, trainYaw));
        }
        return MovementTrack.nextPositionInner(world, currentPosition, rail, trainYaw, distanceMeters);
    }

    public static Vec3d nextPositionInner(World world, Vec3d currentPosition, TileRail rail, float trainYaw, double distanceMeters) {
        Vec3d delta = VecUtil.fromWrongYaw(distanceMeters, trainYaw);
        if (rail == null) {
            if (!world.field_72995_K) {
                return null;
            }
            return currentPosition.func_178787_e(delta);
        }
        double railHeight = rail.info.getTrackHeight();
        double distance = delta.func_72433_c();
        double heightOffset = railHeight * rail.info.settings.gauge.scale();
        if (rail.info.settings.type == TrackItems.CROSSING) {
            delta = VecUtil.fromWrongYaw(distance, EnumFacing.func_176733_a((double)trainYaw).func_185119_l());
            return currentPosition.func_178787_e(delta);
        }
        if (rail.info.settings.type == TrackItems.TURNTABLE) {
            double tablePos = rail.getParentTile().info.tablePos;
            currentPosition = currentPosition.func_178787_e(delta);
            Vec3d center = new Vec3d((Vec3i)rail.getParentTile().func_174877_v()).func_72441_c(0.5, 1.0 + heightOffset, 0.5);
            double fromCenter = currentPosition.func_72438_d(center);
            float angle = 22.5f * (float)tablePos + rail.info.placementInfo.facing().func_185119_l();
            Vec3d forward = center.func_178787_e(VecUtil.fromWrongYaw(fromCenter, angle));
            Vec3d backward = center.func_178787_e(VecUtil.fromWrongYaw(fromCenter, angle + 180.0f));
            if (forward.func_72438_d(currentPosition) < backward.func_72438_d(currentPosition)) {
                return forward;
            }
            return backward;
        }
        if (rail.info.getBuilder() instanceof IIterableTrack) {
            List<PosStep> positions = ((IIterableTrack)((Object)rail.info.getBuilder())).getPath(0.25);
            Vec3d center = rail.info.placementInfo.placementPosition;
            Vec3d relative = currentPosition.func_178788_d(center);
            PosStep close = positions.get(0);
            for (PosStep pos : positions) {
                if (!(close.func_72438_d(relative) > pos.func_72438_d(relative))) continue;
                close = pos;
            }
            Vec3d estimatedPosition = currentPosition.func_178787_e(delta);
            Vec3d closePos = center.func_178787_e((Vec3d)close).func_72441_c(0.0, heightOffset, 0.0);
            double distToClose = closePos.func_72438_d(estimatedPosition);
            Vec3d curveDelta = new Vec3d(distToClose, 0.0, 0.0);
            curveDelta = VecUtil.rotatePitch(curveDelta, -close.pitch);
            curveDelta = VecUtil.rotateYaw(curveDelta, close.yaw);
            Vec3d forward = closePos.func_178787_e(curveDelta);
            Vec3d backward = closePos.func_178788_d(curveDelta);
            if (forward.func_72438_d(estimatedPosition) < backward.func_72438_d(estimatedPosition)) {
                return forward;
            }
            return backward;
        }
        return currentPosition.func_178787_e(delta);
    }
}

