/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.util.Speed;

public class PhysicsAccummulator {
    public double tractiveEffortNewtons = 0.0;
    public double airBrake = 0.0;
    public double rollingResistanceNewtons = 0.0;
    public double gradeForceNewtons = 0.0;
    public double massToMoveKg = 0.0;
    public double brakeAdhesionNewtons = 0.0;
    public int count = 0;
    private TickPos pos;

    public PhysicsAccummulator(TickPos pos) {
        this.pos = pos;
    }

    public void accumulate(EntityRollingStock stock, Boolean direction) {
        ++this.count;
        this.massToMoveKg += stock.getWeight();
        if (!(stock instanceof EntityMoveableRollingStock)) {
            return;
        }
        EntityMoveableRollingStock movable = (EntityMoveableRollingStock)stock;
        double stockMassLb = 2.20462 * stock.getWeight();
        this.rollingResistanceNewtons += 0.0015 * stockMassLb * (double)4.44822f;
        double grade = -Math.tan(Math.toRadians(this.pos.rotationPitch % 90.0f)) * Config.ConfigBalance.slopeMultiplier;
        this.gradeForceNewtons += stockMassLb / 100.0 * (grade * 100.0) * (double)4.44822f;
        if (stock instanceof Locomotive) {
            Locomotive loco = (Locomotive)stock;
            this.tractiveEffortNewtons += loco.getTractiveEffortNewtons(this.pos.speed) * (double)(direction != false ? 1 : -1);
            this.airBrake += Math.min(1.0, Math.pow((double)loco.getAirBrake() * loco.getDefinition().getBrakePower(), 2.0)) * loco.slipCoefficient();
            this.brakeAdhesionNewtons += (double)loco.getDefinition().getStartingTractionNewtons(stock.gauge);
        } else {
            this.brakeAdhesionNewtons += stock.getWeight() * 0.25 * 0.25 * (double)4.44822f;
        }
        int slowdown = movable.getSpeedRetarderSlowdown(this.pos);
        this.rollingResistanceNewtons += (double)slowdown * stockMassLb / 300.0;
    }

    public Speed getVelocity() {
        double airBrakeNewtons = this.brakeAdhesionNewtons * Math.min(this.airBrake, 1.0) * Config.ConfigBalance.brakeMultiplier;
        double tractiveAccell = this.tractiveEffortNewtons / this.massToMoveKg;
        double resistanceAccell = this.rollingResistanceNewtons / this.massToMoveKg;
        double gradeAccell = this.gradeForceNewtons / this.massToMoveKg;
        double brakeAccell = airBrakeNewtons / this.massToMoveKg;
        double currentMCVelocity = this.pos.speed.minecraft();
        double deltaAccellTractiveMCVelocity = Speed.fromMetric(tractiveAccell).minecraft();
        double deltaAccellGradeMCVelocity = Speed.fromMetric(gradeAccell).minecraft();
        double deltaAccellRollingResistanceMCVelocity = Speed.fromMetric(resistanceAccell).minecraft();
        double deltaAccellBrakeMCVelocity = Speed.fromMetric(brakeAccell).minecraft();
        double deltaDecell = -1.0 * Math.copySign(Math.min(Math.abs(currentMCVelocity), deltaAccellRollingResistanceMCVelocity + deltaAccellBrakeMCVelocity), currentMCVelocity);
        double newMCVelocity = currentMCVelocity + deltaAccellTractiveMCVelocity + deltaAccellGradeMCVelocity + deltaDecell;
        if (Math.abs(newMCVelocity) < 0.001) {
            newMCVelocity = 0.0;
        }
        return Speed.fromMinecraft(newMCVelocity);
    }
}

