/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.util.RealBB;
import cam72cam.immersiverailroading.util.TextUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityRollingStockDefinition {
    public final String defID;
    private String name = "Unknown";
    private String modelerName = "N/A";
    private String packName = "N/A";
    private OBJModel model;
    public Map<String, String> textureNames = null;
    private Vec3d passengerCenter = new Vec3d(0.0, 0.0, 0.0);
    private float bogeyFront;
    private float bogeyRear;
    private float couplerOffsetFront;
    private float couplerOffsetRear;
    public float dampeningAmount;
    private boolean scalePitch;
    public double frontBounds;
    public double rearBounds;
    private double heightBounds;
    private double widthBounds;
    private double passengerCompartmentLength;
    private double passengerCompartmentWidth;
    private int weight;
    private int maxPassengers;
    protected double internal_model_scale;
    protected double internal_inv_scale;
    public Gauge recommended_gauge;
    public Boolean shouldSit;
    public ResourceLocation wheel_sound;
    private Map<RenderComponentType, List<RenderComponent>> renderComponents;
    ArrayList<ItemComponentType> itemComponents;
    private Map<RenderComponent, double[][]> partMapCache = new HashMap<RenderComponent, double[][]>();
    private int xRes;
    private int zRes;
    List<Vec3d> blocksInBounds = null;

    public abstract EntityRollingStock instance(World var1);

    public final EntityRollingStock spawn(World world, Vec3d pos, EnumFacing facing, Gauge gauge, String texture) {
        EntityRollingStock stock = this.instance(world);
        stock.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        stock.field_70126_B = facing.func_185119_l();
        stock.field_70177_z = facing.func_185119_l();
        stock.gauge = gauge;
        stock.texture = texture;
        world.func_72838_d((Entity)stock);
        return stock;
    }

    public EntityRollingStockDefinition(String defID, JsonObject data) throws Exception {
        this.defID = defID;
        if (data == null) {
            this.renderComponents = new HashMap<RenderComponentType, List<RenderComponent>>();
            this.itemComponents = new ArrayList();
            return;
        }
        this.parseJson(data);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.REMAINING, this, this.parseComponents()), true);
    }

    public boolean shouldScalePitch() {
        return this.scalePitch;
    }

    public void parseJson(JsonObject data) throws Exception {
        this.name = data.get("name").getAsString();
        if (data.has("modeler")) {
            this.modelerName = data.get("modeler").getAsString();
        }
        if (data.has("pack")) {
            this.packName = data.get("pack").getAsString();
        }
        float darken = 0.0f;
        if (data.has("darken_model")) {
            darken = data.get("darken_model").getAsFloat();
        }
        this.internal_model_scale = 1.0;
        this.internal_inv_scale = 1.0;
        this.recommended_gauge = Gauge.from(1.435);
        if (data.has("model_gauge_m")) {
            this.recommended_gauge = Gauge.from(data.get("model_gauge_m").getAsDouble());
            this.internal_model_scale = 1.435 / data.get("model_gauge_m").getAsDouble();
        }
        if (data.has("recommended_gauge_m")) {
            this.recommended_gauge = Gauge.from(data.get("recommended_gauge_m").getAsDouble());
        }
        if (this.recommended_gauge != Gauge.from(1.435)) {
            this.internal_inv_scale = 1.435 / this.recommended_gauge.value();
        }
        this.model = new OBJModel(new ResourceLocation(data.get("model").getAsString()), darken, this.internal_model_scale);
        this.textureNames = new LinkedHashMap<String, String>();
        this.textureNames.put(null, "Default");
        if (data.has("tex_variants")) {
            JsonElement variants = data.get("tex_variants");
            for (Object variant : variants.getAsJsonObject().entrySet()) {
                this.textureNames.put(((JsonElement)variant.getValue()).getAsString(), (String)variant.getKey());
            }
        }
        ResourceLocation alt_textures = new ResourceLocation("immersiverailroading", this.defID.replace(".json", "_variants.json"));
        try {
            List<InputStream> alts = ImmersiveRailroading.proxy.getResourceStreamAll(alt_textures);
            for (InputStream inputStream : alts) {
                JsonParser parser = new JsonParser();
                JsonElement variants = parser.parse((Reader)new InputStreamReader(inputStream));
                for (Map.Entry variant : variants.getAsJsonObject().entrySet()) {
                    this.textureNames.put(((JsonElement)variant.getValue()).getAsString(), (String)variant.getKey());
                }
            }
        }
        catch (FileNotFoundException alts) {
            // empty catch block
        }
        JsonObject passenger = data.get("passenger").getAsJsonObject();
        this.passengerCenter = new Vec3d(passenger.get("center_x").getAsDouble(), passenger.get("center_y").getAsDouble() - 0.35, 0.0).func_186678_a(this.internal_model_scale);
        this.passengerCompartmentLength = passenger.get("length").getAsDouble() * this.internal_model_scale;
        this.passengerCompartmentWidth = passenger.get("width").getAsDouble() * this.internal_model_scale;
        this.maxPassengers = passenger.get("slots").getAsInt();
        if (passenger.has("should_sit")) {
            this.shouldSit = passenger.get("should_sit").getAsBoolean();
        }
        this.bogeyFront = (float)((double)data.get("trucks").getAsJsonObject().get("front").getAsFloat() * this.internal_model_scale);
        this.bogeyRear = (float)((double)data.get("trucks").getAsJsonObject().get("rear").getAsFloat() * this.internal_model_scale);
        this.dampeningAmount = 0.75f;
        if (data.has("sound_dampening_percentage") && data.get("sound_dampening_percentage").getAsFloat() >= 0.0f && data.get("sound_dampening_percentage").getAsFloat() <= 1.0f) {
            this.dampeningAmount = data.get("sound_dampening_percentage").getAsFloat();
        }
        this.scalePitch = true;
        if (data.has("scale_pitch")) {
            this.scalePitch = data.get("scale_pitch").getAsBoolean();
        }
        if (data.has("couplers")) {
            this.couplerOffsetFront = (float)((double)data.get("couplers").getAsJsonObject().get("front_offset").getAsFloat() * this.internal_model_scale);
            this.couplerOffsetRear = (float)((double)data.get("couplers").getAsJsonObject().get("rear_offset").getAsFloat() * this.internal_model_scale);
        }
        this.frontBounds = -this.model.minOfGroup(this.model.groups()).field_72450_a + (double)this.couplerOffsetFront;
        this.rearBounds = this.model.maxOfGroup(this.model.groups()).field_72450_a + (double)this.couplerOffsetRear;
        this.widthBounds = this.model.widthOfGroups(this.model.groups());
        ArrayList<String> heightGroups = new ArrayList<String>();
        for (String group : this.model.groups()) {
            boolean ignore = false;
            for (RenderComponentType rct : RenderComponentType.values()) {
                if (rct.collisionsEnabled) continue;
                for (int i = 0; i < 10; ++i) {
                    if (!Pattern.matches(rct.regex.replace("#ID#", "" + i), group)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) break;
            }
            if (ignore) continue;
            heightGroups.add(group);
        }
        this.heightBounds = this.model.heightOfGroups(heightGroups);
        this.weight = (int)Math.ceil((double)data.get("properties").getAsJsonObject().get("weight_kg").getAsInt() * this.internal_inv_scale);
        JsonObject jsonObject = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        this.wheel_sound = jsonObject != null && jsonObject.has("wheels") ? new ResourceLocation("immersiverailroading", jsonObject.get("wheels").getAsString()) : new ResourceLocation("immersiverailroading", "sounds/default/track_wheels.ogg");
    }

    protected void addComponentIfExists(RenderComponent renderComponent, boolean itemComponent) {
        if (renderComponent != null) {
            if (!this.renderComponents.containsKey((Object)renderComponent.type)) {
                this.renderComponents.put(renderComponent.type, new ArrayList());
            }
            this.renderComponents.get((Object)renderComponent.type).add(renderComponent);
            if (itemComponent && renderComponent.type != RenderComponentType.REMAINING) {
                this.itemComponents.add(ItemComponentType.from(renderComponent.type));
            }
        }
    }

    protected boolean unifiedBogies() {
        return true;
    }

    protected Set<String> parseComponents() {
        int i;
        this.renderComponents = new HashMap<RenderComponentType, List<RenderComponent>>();
        this.itemComponents = new ArrayList();
        HashSet<String> groups = new HashSet<String>();
        groups.addAll(this.model.groups());
        for (i = 0; i < 100; ++i) {
            if (this.unifiedBogies()) {
                this.addComponentIfExists(RenderComponent.parsePosID(RenderComponentType.BOGEY_POS_WHEEL_X, this, groups, "FRONT", i), true);
                this.addComponentIfExists(RenderComponent.parsePosID(RenderComponentType.BOGEY_POS_WHEEL_X, this, groups, "REAR", i), true);
            } else {
                this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.BOGEY_FRONT_WHEEL_X, this, groups, i), true);
                this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.BOGEY_REAR_WHEEL_X, this, groups, i), true);
            }
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.FRAME_WHEEL_X, this, groups, i), true);
        }
        if (this.unifiedBogies()) {
            this.addComponentIfExists(RenderComponent.parsePos(RenderComponentType.BOGEY_POS, this, groups, "FRONT"), true);
            this.addComponentIfExists(RenderComponent.parsePos(RenderComponentType.BOGEY_POS, this, groups, "REAR"), true);
        } else {
            this.addComponentIfExists(RenderComponent.parse(RenderComponentType.BOGEY_FRONT, this, groups), true);
            this.addComponentIfExists(RenderComponent.parse(RenderComponentType.BOGEY_REAR, this, groups), true);
        }
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FRAME, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.SHELL, this, groups), true);
        for (i = 100; i >= 1; --i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.CARGO_FILL_X, this, groups, i), false);
        }
        return groups;
    }

    public RenderComponent getComponent(RenderComponentType name, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        return this.renderComponents.get((Object)name).get(0).scale(gauge);
    }

    public RenderComponent getComponent(RenderComponentType name, String pos, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            if (c.pos.equals(pos)) {
                return c.scale(gauge);
            }
            if (!c.side.equals(pos)) continue;
            return c.scale(gauge);
        }
        return null;
    }

    public RenderComponent getComponent(RenderComponent comp, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)comp.type)) {
            return null;
        }
        for (RenderComponent c : this.getComponents(comp.type, gauge)) {
            if (!c.equals(comp)) continue;
            return c;
        }
        return null;
    }

    public List<RenderComponent> getComponents(RenderComponentType name, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        ArrayList<RenderComponent> components = new ArrayList<RenderComponent>();
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            components.add(c.scale(gauge));
        }
        return components;
    }

    public List<RenderComponent> getComponents(RenderComponentType name, String pos, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        ArrayList<RenderComponent> components = new ArrayList<RenderComponent>();
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            if (!c.pos.equals(pos)) continue;
            components.add(c.scale(gauge));
        }
        return components;
    }

    public Vec3d getPassengerCenter(Gauge gauge) {
        return this.passengerCenter.func_186678_a(gauge.scale());
    }

    public Vec3d correctPassengerBounds(Gauge gauge, Vec3d pos) {
        double gs = gauge.scale();
        if (pos.field_72450_a > this.passengerCompartmentLength * gs) {
            pos = new Vec3d(this.passengerCompartmentLength * gs, pos.field_72448_b, pos.field_72449_c);
        }
        if (pos.field_72450_a < -this.passengerCompartmentLength * gs) {
            pos = new Vec3d(-this.passengerCompartmentLength * gs, pos.field_72448_b, pos.field_72449_c);
        }
        if (Math.abs(pos.field_72449_c) > this.passengerCompartmentWidth / 2.0 * gs) {
            pos = new Vec3d(pos.field_72450_a, pos.field_72448_b, Math.copySign(this.passengerCompartmentWidth / 2.0 * gs, pos.field_72449_c));
        }
        return pos;
    }

    public boolean isAtFront(Gauge gauge, Vec3d pos) {
        return pos.field_72450_a >= this.passengerCompartmentLength * gauge.scale();
    }

    public boolean isAtRear(Gauge gauge, Vec3d pos) {
        return pos.field_72450_a <= -this.passengerCompartmentLength * gauge.scale();
    }

    public List<ItemComponentType> getItemComponents() {
        return this.itemComponents;
    }

    public float getBogeyFront(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyFront;
    }

    public float getBogeyRear(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyRear;
    }

    public double getCouplerPosition(EntityCoupleableRollingStock.CouplerType coupler, Gauge gauge) {
        switch (coupler) {
            case FRONT: {
                return gauge.scale() * this.frontBounds;
            }
            case BACK: {
                return gauge.scale() * this.rearBounds;
            }
        }
        return 0.0;
    }

    public void initHeightMap() {
        ImmersiveRailroading.info("Generating heightmap %s", this.defID);
        double ratio = 8.0;
        this.xRes = (int)Math.ceil((this.frontBounds + this.rearBounds) * ratio);
        this.zRes = (int)Math.ceil(this.widthBounds * ratio);
        int precision = (int)Math.ceil(this.heightBounds * 4.0);
        for (List<RenderComponent> rcl : this.renderComponents.values()) {
            for (RenderComponent rc : rcl) {
                if (!rc.type.collisionsEnabled) continue;
                double[][] heightMap = new double[this.xRes][this.zRes];
                for (String group : rc.modelIDs) {
                    int[] faces;
                    for (int face : faces = this.model.groups.get(group)) {
                        Path2D.Double path = new Path2D.Double();
                        double fheight = 0.0;
                        boolean first = true;
                        for (int[] point : this.model.points(face)) {
                            Vec3d vert = this.model.vertices(point[0]);
                            vert = vert.func_72441_c(this.frontBounds, 0.0, this.widthBounds / 2.0);
                            if (first) {
                                ((Path2D)path).moveTo(vert.field_72450_a * ratio, vert.field_72449_c * ratio);
                                first = false;
                            } else {
                                ((Path2D)path).lineTo(vert.field_72450_a * ratio, vert.field_72449_c * ratio);
                            }
                            fheight += vert.field_72448_b / 3.0;
                        }
                        Rectangle2D bounds = path.getBounds2D();
                        if (bounds.getWidth() * bounds.getHeight() < 1.0) continue;
                        for (int x = 0; x < this.xRes; ++x) {
                            for (int z = 0; z < this.zRes; ++z) {
                                double relX = this.xRes - 1 - x;
                                double relZ = z;
                                if (!bounds.contains(relX, relZ) || !path.contains(relX, relZ)) continue;
                                double relHeight = fheight / this.heightBounds;
                                relHeight = (double)((int)Math.ceil(relHeight * (double)precision)) / (double)precision;
                                heightMap[x][z] = Math.max(heightMap[x][z], relHeight);
                            }
                        }
                    }
                }
                this.partMapCache.put(rc, heightMap);
            }
        }
    }

    public IconPart[][] getIcon(int i) {
        ImmersiveRailroading.info("Generating model icon map %s...", this.defID);
        IconPart[][] map = new IconPart[i][i];
        double nx = Math.max(this.heightBounds, this.widthBounds) / (double)map.length;
        double xoff = 0.0;
        if (this.heightBounds > this.widthBounds) {
            xoff = (this.heightBounds - this.widthBounds) / 2.0;
        }
        ArrayList<Integer> faces = new ArrayList<Integer>();
        for (List<RenderComponent> rcl : this.renderComponents.values()) {
            for (RenderComponent rc : rcl) {
                if (!rc.type.collisionsEnabled) continue;
                for (String group : rc.modelIDs) {
                    for (int face : this.model.groups.get(group)) {
                        faces.add(face);
                    }
                }
            }
        }
        final float[] depthCache = new float[this.model.faceVerts.length / 9];
        Iterator iterator = faces.iterator();
        while (iterator.hasNext()) {
            int f = (Integer)iterator.next();
            float sum = 0.0f;
            for (Object point : (Object)this.model.points(f)) {
                Vec3d pt = this.model.vertices((int)point[0]);
                sum = (float)((double)sum + pt.field_72450_a);
            }
            depthCache[f] = sum / 3.0f;
        }
        faces.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Float.compare(depthCache[o1], depthCache[o2]);
            }
        });
        iterator = faces.iterator();
        while (iterator.hasNext()) {
            int f = (Integer)iterator.next();
            Material mtl = this.model.materials.get(this.model.faceMTLs[f]);
            if (mtl == null || mtl.name == "") continue;
            Path2D.Double path = new Path2D.Double();
            boolean first = true;
            float vu = 0.0f;
            float vv = 0.0f;
            for (int[] point : this.model.points(f)) {
                Vec2f vt = point[1] != -1 ? this.model.vertexTextures(point[1]) : Vec2f.ZERO;
                vu += vt.x / 3.0f;
                vv += vt.y / 3.0f;
                Vec3d vert = this.model.vertices(point[0]);
                vert = vert.func_72441_c(0.0, 0.0, this.widthBounds / 2.0);
                if (first) {
                    ((Path2D)path).moveTo(vert.field_72449_c / nx + xoff / nx, vert.field_72448_b / nx);
                } else {
                    ((Path2D)path).lineTo(vert.field_72449_c / nx + xoff / nx, vert.field_72448_b / nx);
                }
                first = false;
            }
            Rectangle2D bounds = path.getBounds2D();
            if (bounds.getWidth() * bounds.getHeight() < 1.0) continue;
            int minZ = (int)Math.max(0.0, bounds.getMinX() - 2.0);
            int maxZ = (int)Math.min(bounds.getMaxX() + 2.0, (double)i);
            int minY = (int)Math.max(0.0, bounds.getMinY() - 2.0);
            int maxY = (int)Math.min(bounds.getMaxY() + 2.0, (double)i);
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    double relY;
                    double relZ;
                    if (map[z][y] != null || !bounds.contains(relZ = (double)z, relY = (double)y) || !path.contains(relZ, relY)) continue;
                    map[z][y] = new IconPart(mtl.name, vu, vv);
                }
            }
        }
        return map;
    }

    public double[][] createHeightMap(EntityBuildableRollingStock stock) {
        double[][] heightMap = new double[this.xRes][this.zRes];
        ArrayList<RenderComponentType> availComponents = new ArrayList<RenderComponentType>();
        for (ItemComponentType itemComponentType : stock.getItemComponents()) {
            availComponents.addAll(itemComponentType.render);
        }
        for (List list : this.renderComponents.values()) {
            for (RenderComponent rc : list) {
                if (!rc.type.collisionsEnabled) continue;
                if (availComponents.contains((Object)rc.type)) {
                    availComponents.remove((Object)rc.type);
                } else if (rc.type != RenderComponentType.REMAINING || !stock.isBuilt()) continue;
                double[][] pm = this.partMapCache.get(rc);
                for (int x = 0; x < this.xRes; ++x) {
                    for (int z = 0; z < this.zRes; ++z) {
                        heightMap[x][z] = Math.max(heightMap[x][z], pm[x][z]);
                    }
                }
            }
        }
        return heightMap;
    }

    public RealBB getBounds(EntityMoveableRollingStock stock, Gauge gauge) {
        return (RealBB)new RealBB(gauge.scale() * this.frontBounds, gauge.scale() * -this.rearBounds, gauge.scale() * this.widthBounds, gauge.scale() * this.heightBounds, stock.field_70177_z).func_191194_a(stock.func_174791_d());
    }

    public List<Vec3d> getBlocksInBounds(Gauge gauge) {
        if (this.blocksInBounds == null) {
            this.blocksInBounds = new ArrayList<Vec3d>();
            double minX = gauge.scale() * -this.rearBounds;
            double maxX = gauge.scale() * this.frontBounds;
            double minY = gauge.scale() * 0.0;
            double maxY = gauge.scale() * this.heightBounds;
            double minZ = gauge.scale() * -this.widthBounds / 2.0;
            double maxZ = gauge.scale() * this.widthBounds / 2.0;
            for (double x = minX; x <= maxX + 1.0; x += 1.0) {
                for (double y = minY; y <= maxY + 1.0; y += 1.0) {
                    for (double z = minZ; z <= maxZ + 1.0; z += 1.0) {
                        this.blocksInBounds.add(new Vec3d(x, y, z));
                    }
                }
            }
        }
        return this.blocksInBounds;
    }

    public String name() {
        String transStr;
        String[] sp = this.defID.replaceAll(".json", "").split("/");
        String localStr = String.format("%s:entity.%s.%s", "immersiverailroading", sp[sp.length - 2], sp[sp.length - 1]);
        return localStr != (transStr = TextUtil.translate(localStr)) ? transStr : this.name;
    }

    public List<String> getTooltip(Gauge gauge) {
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(GuiText.WEIGHT_TOOLTIP.toString(this.getWeight(gauge)));
        tips.add(GuiText.MODELER_TOOLTIP.toString(this.modelerName));
        tips.add(GuiText.PACK_TOOLTIP.toString(this.packName));
        return tips;
    }

    public double getPassengerCompartmentWidth(Gauge gauge) {
        return gauge.scale() * this.passengerCompartmentWidth;
    }

    public OBJModel getModel() {
        return this.model;
    }

    public int getWeight(Gauge gauge) {
        return (int)Math.ceil(gauge.scale() * (double)this.weight);
    }

    public double getHeight(Gauge gauge) {
        return gauge.scale() * this.heightBounds;
    }

    public double getLength(Gauge gauge) {
        return gauge.scale() * this.frontBounds + this.rearBounds;
    }

    public int getMaxPassengers() {
        return this.maxPassengers;
    }

    public boolean acceptsPassengers() {
        return false;
    }

    public boolean acceptsLivestock() {
        return false;
    }

    @SideOnly(value=Side.SERVER)
    public void clearModel() {
        this.model = null;
    }

    public class IconPart {
        public final String mtl;
        public final float u;
        public final float v;

        public IconPart(String mtl, float u, float v) {
            this.mtl = mtl;
            this.u = u;
            this.v = v;
        }
    }
}

