/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.TrackComponent;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.util.OreHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class TrackDefinition {
    public final String trackID;
    public final String name;
    public final List<TrackModel> models;
    public final Map<TrackComponent, List<TrackMaterial>> materials = new HashMap<TrackComponent, List<TrackMaterial>>();

    public TrackDefinition(String trackID, JsonObject object) throws Exception {
        this.trackID = trackID;
        this.name = object.get("name").getAsString();
        this.models = new ArrayList<TrackModel>();
        for (Map.Entry entry : object.getAsJsonObject("models").entrySet()) {
            this.models.add(new TrackModel((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
        }
        JsonObject mats = object.getAsJsonObject("materials");
        for (TrackComponent comp : TrackComponent.values()) {
            if (!mats.has(comp.name())) continue;
            ArrayList<TrackMaterial> parts = new ArrayList<TrackMaterial>();
            for (JsonElement part : mats.get(comp.name()).getAsJsonArray()) {
                parts.add(new TrackMaterial(part.getAsJsonObject().get("item").getAsString(), part.getAsJsonObject().get("cost").getAsFloat()));
            }
            if (parts.size() <= 0) continue;
            this.materials.put(comp, parts);
        }
    }

    public TrackModel getTrackForGauge(double gauge) {
        for (TrackModel model : this.models) {
            if (!model.canRender(gauge)) continue;
            return model;
        }
        ImmersiveRailroading.warn("Bad track gauge def for %s - %s", this.trackID, gauge);
        return this.models.get(0);
    }

    public static class TrackMaterial {
        public final String item;
        public final float cost;
        public final int meta;

        public TrackMaterial(String item, float cost) {
            if (item.contains("|")) {
                this.item = item.split("\\|")[0];
                this.meta = Integer.parseInt(item.split("\\|")[1]);
            } else {
                this.item = item;
                this.meta = 0;
            }
            this.cost = cost;
        }

        public List<ItemStack> examples() {
            ArrayList<ItemStack> examples = new ArrayList<ItemStack>();
            if (this.item.startsWith("ore:")) {
                String oreName = this.item.replace("ore:", "");
                if (oreName.equals("irRail")) {
                    examples.addAll((Collection<ItemStack>)OreHelper.IR_RAIL.getOres());
                }
                if (oreName.equals("irTie")) {
                    examples.addAll((Collection<ItemStack>)OreHelper.IR_TIE.getOres());
                }
                examples.addAll((Collection<ItemStack>)OreDictionary.getOres((String)oreName));
            } else {
                examples.add(new ItemStack(Item.func_111206_d((String)this.item), 1, this.meta));
            }
            return examples;
        }

        public boolean matches(ItemStack stack) {
            if (this.item.startsWith("ore:")) {
                String oreName = this.item.replace("ore:", "");
                if (oreName.equals("irRail")) {
                    return OreHelper.IR_RAIL.matches(stack, false);
                }
                if (oreName.equals("irTie")) {
                    return OreHelper.IR_TIE.matches(stack, false);
                }
                return OreHelper.oreDictionaryContainsMatch(false, (NonNullList<ItemStack>)OreDictionary.getOres((String)oreName), stack);
            }
            return stack.func_77973_b() == Item.func_111206_d((String)this.item) && stack.func_77960_j() == this.meta;
        }
    }
}

