/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.TrackDefinition;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.entity.StockModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.common.ProgressManager;

public class StockRenderCache {
    private static Map<String, StockModel> render_cache = new HashMap<String, StockModel>();
    private static Map<TrackModel, OBJRender> track_cache = new HashMap<TrackModel, OBJRender>();
    private static boolean isCachePrimed = false;

    public static void clearRenderCache() {
        for (StockModel stockModel : render_cache.values()) {
            stockModel.freeGL();
        }
        for (OBJRender oBJRender : track_cache.values()) {
            oBJRender.freeGL();
        }
        render_cache = new HashMap<String, StockModel>();
        track_cache = new HashMap<TrackModel, OBJRender>();
        isCachePrimed = false;
    }

    private static void tryPrimeRenderCache() {
        if (isCachePrimed) {
            return;
        }
        isCachePrimed = true;
        ProgressManager.ProgressBar origBar = null;
        Iterator itr = ProgressManager.barIterator();
        while (itr.hasNext()) {
            origBar = (ProgressManager.ProgressBar)itr.next();
        }
        ProgressManager.pop(origBar);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Uploading IR Textures", (int)DefinitionManager.getDefinitionNames().size());
        for (String string : DefinitionManager.getDefinitionNames()) {
            bar.step(DefinitionManager.getDefinition(string).name());
            ImmersiveRailroading.info(string, new Object[0]);
            StockModel renderer = StockRenderCache.getRender(string);
            renderer.bindTexture();
            renderer.draw();
            renderer.restoreTexture();
            ClientProxy.renderCacheLimiter.reset();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        for (TrackDefinition trackDefinition : DefinitionManager.getTracks()) {
            ImmersiveRailroading.info(trackDefinition.trackID, new Object[0]);
            for (TrackModel model : trackDefinition.models) {
                StockRenderCache.getTrackRenderer(model).bindTexture();
                StockRenderCache.getTrackRenderer(model).draw();
                StockRenderCache.getTrackRenderer(model).restoreTexture();
                ClientProxy.renderCacheLimiter.reset();
            }
        }
    }

    public static StockModel getRender(String defID) {
        EntityRollingStockDefinition def;
        if (!render_cache.containsKey(defID) && (def = DefinitionManager.getDefinition(defID)) != null) {
            render_cache.put(defID, new StockModel(def.getModel(), def.textureNames.keySet()));
        }
        return render_cache.get(defID);
    }

    public static OBJRender getTrackRenderer(TrackModel model) {
        if (!track_cache.containsKey(model)) {
            track_cache.put(model, new OBJRender(model));
        }
        return track_cache.get(model);
    }

    public static void tryPrime() {
        StockRenderCache.tryPrimeRenderCache();
    }
}

