/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.model.obj.Vec2f;
import java.nio.FloatBuffer;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VBA {
    private Map<String, Pair<Integer, Integer>> groupIdx;
    private boolean isVBO;
    private int size;
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private FloatBuffer colorBuffer;
    private FloatBuffer texBuffer;
    private int vbo = -1;
    private int vnbo = -1;
    private int vtbo = -1;
    private int vcbo = -1;
    private boolean has_vn = true;

    public VBA(int size) {
        this.size = size;
        this.vertexBuffer = BufferUtils.createFloatBuffer((int)(size * 3 * 3));
        this.normalBuffer = BufferUtils.createFloatBuffer((int)(size * 3 * 3));
        this.colorBuffer = BufferUtils.createFloatBuffer((int)(size * 3 * 4));
        this.texBuffer = BufferUtils.createFloatBuffer((int)(size * 3 * 2));
        this.isVBO = OpenGlHelper.func_176075_f();
    }

    public VBA(int size, Map<String, Pair<Integer, Integer>> groupIdx) {
        this(size);
        this.groupIdx = groupIdx;
    }

    public void addPoint(Vec3d v, Vec3d vn, Vec2f vt, float r, float g, float b, float a) {
        this.vertexBuffer.put((float)v.field_72450_a);
        this.vertexBuffer.put((float)v.field_72448_b);
        this.vertexBuffer.put((float)v.field_72449_c);
        if (vn != null) {
            this.normalBuffer.put((float)vn.field_72450_a);
            this.normalBuffer.put((float)vn.field_72448_b);
            this.normalBuffer.put((float)vn.field_72449_c);
        } else {
            this.has_vn = false;
        }
        this.texBuffer.put(vt.x);
        this.texBuffer.put(vt.y);
        this.colorBuffer.put(r);
        this.colorBuffer.put(g);
        this.colorBuffer.put(b);
        this.colorBuffer.put(a);
    }

    public void draw() {
        if (this.isVBO) {
            this.drawVBO(null);
        } else {
            this.drawVBA(null);
        }
    }

    public void draw(Iterable<String> groups) {
        if (this.isVBO) {
            this.drawVBO(groups);
        } else {
            this.drawVBA(groups);
        }
    }

    private void drawVBO(Iterable<String> groups) {
        int prev = GL11.glGetInteger((int)34964);
        if (this.vbo == -1) {
            this.vertexBuffer.flip();
            this.colorBuffer.flip();
            this.normalBuffer.flip();
            this.texBuffer.flip();
            this.vbo = GL15.glGenBuffers();
            this.vnbo = GL15.glGenBuffers();
            this.vtbo = GL15.glGenBuffers();
            this.vcbo = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.vbo);
            GL15.glBufferData((int)34962, (FloatBuffer)this.vertexBuffer, (int)35044);
            if (this.has_vn) {
                GL15.glBindBuffer((int)34962, (int)this.vnbo);
                GL15.glBufferData((int)34962, (FloatBuffer)this.normalBuffer, (int)35044);
            }
            GL15.glBindBuffer((int)34962, (int)this.vtbo);
            GL15.glBufferData((int)34962, (FloatBuffer)this.texBuffer, (int)35044);
            GL15.glBindBuffer((int)34962, (int)this.vcbo);
            GL15.glBufferData((int)34962, (FloatBuffer)this.colorBuffer, (int)35044);
            this.vertexBuffer = null;
            this.normalBuffer = null;
            this.texBuffer = null;
            this.colorBuffer = null;
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
        if (this.has_vn) {
            GL11.glEnableClientState((int)32885);
        }
        GL15.glBindBuffer((int)34962, (int)this.vtbo);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)this.vcbo);
        GL11.glColorPointer((int)4, (int)5126, (int)0, (long)0L);
        if (this.has_vn) {
            GL15.glBindBuffer((int)34962, (int)this.vnbo);
            GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        }
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        if (groups == null) {
            GL11.glDrawArrays((int)4, (int)0, (int)(this.size * 3));
        } else {
            for (String group : groups) {
                Pair<Integer, Integer> info = this.groupIdx.get(group);
                GL11.glDrawArrays((int)4, (int)((Integer)info.getKey() * 3), (int)((Integer)info.getValue() * 3));
            }
        }
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        if (this.has_vn) {
            GL11.glDisableClientState((int)32885);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL15.glBindBuffer((int)34962, (int)prev);
    }

    private void drawVBA(Iterable<String> groups) {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
        if (this.has_vn) {
            GL11.glEnableClientState((int)32885);
        }
        this.vertexBuffer.flip();
        this.colorBuffer.flip();
        this.normalBuffer.flip();
        this.texBuffer.flip();
        GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)this.texBuffer);
        GL11.glColorPointer((int)4, (int)16, (FloatBuffer)this.colorBuffer);
        if (this.has_vn) {
            GL11.glNormalPointer((int)12, (FloatBuffer)this.normalBuffer);
        }
        GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)this.vertexBuffer);
        if (groups == null) {
            GL11.glDrawArrays((int)4, (int)0, (int)(this.size * 3));
        } else {
            for (String group : groups) {
                Pair<Integer, Integer> info = this.groupIdx.get(group);
                GL11.glDrawArrays((int)4, (int)((Integer)info.getKey() * 3), (int)((Integer)info.getValue() * 3));
            }
        }
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        if (this.has_vn) {
            GL11.glDisableClientState((int)32885);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void free() {
        this.vertexBuffer = null;
        this.normalBuffer = null;
        this.texBuffer = null;
        this.colorBuffer = null;
        if (this.isVBO) {
            GL15.glDeleteBuffers((int)this.vbo);
            GL15.glDeleteBuffers((int)this.vnbo);
            GL15.glDeleteBuffers((int)this.vtbo);
            GL15.glDeleteBuffers((int)this.vcbo);
        }
    }
}

