/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.entity;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.EntitySmokeParticle;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.render.entity.ParticleRender;
import cam72cam.immersiverailroading.render.rail.RailBuilderRender;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.RailInfo;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

public class RenderOverride {
    private static final Predicate<Entity> IN_RENDER_DISTANCE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return RenderOverride.isInRenderDistance(p_apply_1_.func_174791_d());
        }
    };

    public static Vec3d getCameraPos(float partialTicks) {
        Entity playerrRender = Minecraft.func_71410_x().func_175606_aa();
        double d0 = playerrRender.field_70142_S + (playerrRender.field_70165_t - playerrRender.field_70142_S) * (double)partialTicks;
        double d1 = playerrRender.field_70137_T + (playerrRender.field_70163_u - playerrRender.field_70137_T) * (double)partialTicks;
        double d2 = playerrRender.field_70136_U + (playerrRender.field_70161_v - playerrRender.field_70136_U) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }

    private static ICamera getCamera(float partialTicks) {
        Frustum camera = new Frustum();
        Vec3d cameraPos = RenderOverride.getCameraPos(partialTicks);
        camera.func_78547_a(cameraPos.field_72450_a, cameraPos.field_72448_b, cameraPos.field_72449_c);
        return camera;
    }

    private static boolean isInRenderDistance(Vec3d pos) {
        return Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(pos) < (double)((Minecraft.func_71410_x().field_71474_y.field_151451_c + 1) * 16 + 50);
    }

    public static void renderStock(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass != 0 && ConfigGraphics.useShaderFriendlyRender) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ir_entity");
        ICamera camera = RenderOverride.getCamera(partialTicks);
        World world = Minecraft.func_71410_x().field_71439_g.func_130014_f_();
        List entities = world.func_175644_a(EntityRollingStock.class, IN_RENDER_DISTANCE);
        for (EntityRollingStock entity : entities) {
            if (!camera.func_78546_a(entity.func_184177_bl())) continue;
            Minecraft.func_71410_x().func_175598_ae().func_188388_a((Entity)entity, partialTicks, true);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public static void renderParticles(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass != 1 && ConfigGraphics.useShaderFriendlyRender) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ir_particles");
        GlStateManager.func_179132_a((boolean)false);
        ICamera camera = RenderOverride.getCamera(partialTicks);
        Vec3d ep = RenderOverride.getCameraPos(partialTicks);
        World world = Minecraft.func_71410_x().field_71439_g.func_130014_f_();
        List smokeEnts = world.func_175644_a(EntitySmokeParticle.class, IN_RENDER_DISTANCE);
        Comparator compare = (e1, e2) -> {
            Double p1 = e1.func_174791_d().func_72436_e(ep);
            Double p2 = e1.func_174791_d().func_72436_e(ep);
            return p1.compareTo(p2);
        };
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ent_sort");
        Collections.sort(smokeEnts, compare);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        ParticleRender.shader.bind();
        GLBoolTracker light = new GLBoolTracker(2896, false);
        GLBoolTracker cull = new GLBoolTracker(2884, false);
        GLBoolTracker tex = new GLBoolTracker(3553, false);
        GLBoolTracker blend = new GLBoolTracker(3042, true);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71424_I.func_76320_a("render_particle");
        for (EntitySmokeParticle entity : smokeEnts) {
            if (!camera.func_78546_a(entity.func_184177_bl())) continue;
            Minecraft.func_71410_x().func_175598_ae().func_188388_a((Entity)entity, partialTicks, true);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        blend.restore();
        tex.restore();
        cull.restore();
        light.restore();
        ParticleRender.shader.unbind();
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public static void renderTiles(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass != 0 && ConfigGraphics.useShaderFriendlyRender) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ir_tile");
        ICamera camera = RenderOverride.getCamera(partialTicks);
        Vec3d cameraPos = RenderOverride.getCameraPos(partialTicks);
        GLBoolTracker blend = new GLBoolTracker(3042, false);
        ArrayList entities = new ArrayList(Minecraft.func_71410_x().field_71439_g.func_130014_f_().field_147482_g);
        for (TileEntity te : entities) {
            RailInfo info;
            if (!(te instanceof TileRail) || !((TileRail)te).isLoaded() || !camera.func_78546_a(te.getRenderBoundingBox()) || !RenderOverride.isInRenderDistance(new Vec3d((Vec3i)te.func_174877_v())) || (info = ((TileRail)te).info) == null) continue;
            GL11.glPushMatrix();
            int i = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            if (info.settings.type == TrackItems.SWITCH) {
                info = info.withType(TrackItems.STRAIGHT);
            }
            Vec3d pos = info.placementInfo.placementPosition.func_178788_d(cameraPos);
            GL11.glTranslated((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
            RailBuilderRender.renderRailBuilder(info);
            GL11.glPopMatrix();
        }
        blend.restore();
        ClientProxy proxy = (ClientProxy)ImmersiveRailroading.proxy;
        Collection<TileRailPreview> previews = proxy.getPreviews();
        if (previews != null && previews.size() > 0) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("tile_rail_preview");
            blend = new GLBoolTracker(3042, true);
            GL11.glBlendFunc((int)32771, (int)1);
            if (GLContext.getCapabilities().OpenGL14) {
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            }
            for (TileRailPreview preview : previews) {
                if (!preview.func_145830_o()) {
                    preview.func_145834_a(Minecraft.func_71410_x().field_71439_g.field_70170_p);
                }
                for (BuilderBase builder : ((IIterableTrack)((Object)preview.getRailRenderInfo().getBuilder(preview.func_174877_v()))).getSubBuilders()) {
                    RailInfo info = builder.info;
                    Vec3d placementPosition = info.placementInfo.placementPosition;
                    if (!RenderOverride.isInRenderDistance(placementPosition)) continue;
                    placementPosition = placementPosition.func_178788_d(cameraPos);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)placementPosition.field_72450_a, (double)placementPosition.field_72448_b, (double)placementPosition.field_72449_c);
                    RailRenderUtil.render(info, true);
                    GL11.glPopMatrix();
                }
            }
            GL11.glBlendFunc((int)770, (int)771);
            if (GLContext.getCapabilities().OpenGL14) {
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            blend.restore();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }
}

