/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.entity;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.MultiRenderComponent;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class StockModel
extends OBJRender {
    private static final int MALLET_ANGLE_REAR = -45;
    private boolean isBuilt;
    private List<RenderComponentType> availComponents;
    private double distanceTraveled;

    public StockModel(OBJModel objModel, Collection<String> textureNames) {
        super(objModel, textureNames);
    }

    private void initComponents(EntityBuildableRollingStock stock) {
        this.isBuilt = stock.isBuilt();
        if (!this.isBuilt) {
            this.availComponents = new ArrayList<RenderComponentType>();
            for (ItemComponentType item : stock.getItemComponents()) {
                this.availComponents.addAll(item.render);
            }
        }
    }

    private void drawComponent(RenderComponent component) {
        if (component != null) {
            if (!this.isBuilt) {
                if (!this.availComponents.contains((Object)component.type)) {
                    return;
                }
                this.availComponents.remove((Object)component.type);
            }
            Minecraft.func_71410_x().field_71424_I.func_76320_a("render");
            GL11.glPushMatrix();
            GL11.glScaled((double)component.scale, (double)component.scale, (double)component.scale);
            this.drawGroups(component.modelIDs);
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    private void drawComponents(List<RenderComponent> components) {
        if (components == null) {
            return;
        }
        for (RenderComponent component : components) {
            this.drawComponent(component);
        }
    }

    public void draw(EntityRollingStock stock, float partialTicks) {
        GLBoolTracker tex = new GLBoolTracker(3553, super.hasTexture());
        if (stock instanceof EntityMoveableRollingStock) {
            EntityMoveableRollingStock mstock = (EntityMoveableRollingStock)stock;
            this.distanceTraveled = (double)mstock.distanceTraveled + mstock.getCurrentSpeed().minecraft() * (double)mstock.getTickSkew() * (double)partialTicks * 1.1;
        } else {
            this.distanceTraveled = 0.0;
        }
        this.bindTexture(stock.texture);
        if (stock instanceof LocomotiveSteam) {
            this.drawSteamLocomotive((LocomotiveSteam)stock);
        } else if (stock instanceof LocomotiveDiesel) {
            this.drawDieselLocomotive((LocomotiveDiesel)stock);
        } else if (stock instanceof EntityMoveableRollingStock) {
            this.drawStandardStock((EntityMoveableRollingStock)stock);
        } else {
            this.draw();
        }
        this.drawCargo(stock);
        this.restoreTexture();
        tex.restore();
    }

    public void drawCargo(EntityRollingStock stock) {
        if (stock instanceof Freight) {
            Freight freight = (Freight)stock;
            FreightDefinition def = freight.getDefinition();
            int fill = freight.getPercentCargoFull();
            List<RenderComponent> cargoLoads = def.getComponents(RenderComponentType.CARGO_FILL_X, stock.gauge);
            if (cargoLoads != null) {
                for (RenderComponent cargoLoad : cargoLoads) {
                    if (cargoLoad.id > fill) continue;
                    this.drawComponent(cargoLoad);
                    if (!def.shouldShowCurrentLoadOnly()) continue;
                    break;
                }
            }
        }
    }

    private void drawStandardStock(EntityMoveableRollingStock stock) {
        Vec3d wheelPos;
        double relDist;
        double circumference;
        List<RenderComponent> wheels;
        EntityRollingStockDefinition def = stock.getDefinition();
        this.initComponents(stock);
        this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
        this.drawFrameWheels(stock);
        if (def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-def.getBogeyFront(stock.gauge)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(180.0f - stock.getFrontYaw()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)def.getBogeyFront(stock.gauge), (float)0.0f, (float)0.0f);
            this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge));
            wheels = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "FRONT", stock.gauge);
            if (wheels != null) {
                for (RenderComponent wheel : wheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (def.getComponent(RenderComponentType.BOGEY_POS, stock.gauge) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-def.getBogeyRear(stock.gauge)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(180.0f - stock.getRearYaw()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)def.getBogeyRear(stock.gauge), (float)0.0f, (float)0.0f);
            this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "REAR", stock.gauge));
            wheels = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "REAR", stock.gauge);
            if (wheels != null) {
                for (RenderComponent wheel : wheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (this.isBuilt) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawFrameWheels(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def = stock.getDefinition();
        List<RenderComponent> wheels = def.getComponents(RenderComponentType.FRAME_WHEEL_X, stock.gauge);
        if (wheels != null) {
            for (RenderComponent wheel : wheels) {
                double circumference = wheel.height() * 3.1415927410125732;
                double relDist = this.distanceTraveled % circumference;
                Vec3d wheelPos = wheel.center();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                this.drawComponent(wheel);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void drawDieselLocomotive(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def = stock.getDefinition();
        this.drawStandardStock(stock);
        this.drawComponent(def.getComponent(RenderComponentType.FUEL_TANK, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ALTERNATOR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ENGINE_BLOCK, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.GEARBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FLUID_COUPLING, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FINAL_DRIVE, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.TORQUE_CONVERTER, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.FAN_X, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.DRIVE_SHAFT_X, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
    }

    private void drawSteamLocomotive(LocomotiveSteam stock) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        this.initComponents(stock);
        this.drawBogies(stock);
        this.drawFrameWheels(stock);
        switch (def.getValveGear()) {
            case WALSCHAERTS: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "RIGHT", -90, wheel.height(), center.center(), wheel.center(), false);
                break;
            }
            case TRI_WALSCHAERTS: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "RIGHT", -240, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "CENTER", -120, wheel.height(), wheels.get(0).center(), wheels.get(0).center(), false);
                break;
            }
            case MALLET_WALSCHAERTS: 
            case GARRAT: {
                GL11.glPushMatrix();
                RenderComponent frontLocomotive = def.getComponent(RenderComponentType.FRONT_LOCOMOTIVE, stock.gauge);
                Vec3d frontVec = frontLocomotive.center();
                Vec3d frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge)));
                Vec3d frontNext = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge) - 0.5));
                float frontWheelYaw = VecUtil.toYaw(frontPos.func_178788_d(frontNext));
                float frontYaw = VecUtil.toYaw(frontPos) + stock.field_70177_z + 180.0f;
                float frontPitch = -VecUtil.toPitch(VecUtil.rotateYaw(frontPos, stock.field_70177_z + 180.0f)) + 90.0f + stock.field_70125_A;
                GL11.glRotated((double)frontYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)frontPitch, (double)0.0, (double)0.0, (double)1.0);
                if (frontPos.func_72438_d(frontNext) > 0.1) {
                    GL11.glTranslated((double)frontVec.field_72450_a, (double)frontVec.field_72448_b, (double)frontVec.field_72449_c);
                    GL11.glRotated((double)(frontWheelYaw + stock.field_70177_z - frontYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)(-frontVec.field_72450_a), (double)(-frontVec.field_72448_b), (double)(-frontVec.field_72449_c));
                }
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_FRONT_X, stock.gauge);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_FRONT, stock.gauge));
                this.drawComponent(frontLocomotive);
                this.drawDrivingWheels(stock, wheels);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                boolean reverse = def.getValveGear() == ValveGearType.GARRAT;
                this.drawWalschaerts(stock, "LEFT_FRONT", 0, wheel.height(), center.center(), wheel.center(), reverse);
                this.drawWalschaerts(stock, "RIGHT_FRONT", -90, wheel.height(), center.center(), wheel.center(), reverse);
                GL11.glPopMatrix();
                List<RenderComponent> wheels2 = def.getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, stock.gauge);
                MultiRenderComponent center2 = new MultiRenderComponent(wheels2).scale(stock.gauge);
                this.drawDrivingWheels(stock, wheels2);
                RenderComponent wheel2 = wheels2.get(wheels2.size() / 2);
                this.drawWalschaerts(stock, "LEFT_REAR", -45, center2.height(), center2.center(), wheel2.center(), false);
                this.drawWalschaerts(stock, "RIGHT_REAR", -135, center2.height(), center2.center(), wheel2.center(), false);
                break;
            }
            case CLIMAX: {
                break;
            }
            case SHAY: {
                break;
            }
            case HIDDEN: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                break;
            }
            case STEPHENSON: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawStephenson(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center());
                this.drawStephenson(stock, "RIGHT", -90, wheel.height(), center.center(), wheel.center());
                break;
            }
            case T1: {
                this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_FRONT, stock.gauge));
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_FRONT_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawT1(stock, "LEFT_FRONT", 0, wheel.height(), center.center(), wheel.center());
                this.drawT1(stock, "RIGHT_FRONT", -90, wheel.height(), center.center(), wheel.center());
                wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                center = new MultiRenderComponent(wheels).scale(stock.gauge);
                wheel = wheels.get(wheels.size() / 2);
                this.drawT1(stock, "LEFT_REAR", -45, wheel.height(), center.center(), wheel.center());
                this.drawT1(stock, "RIGHT_REAR", -135, wheel.height(), center.center(), wheel.center());
            }
        }
        this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BOILER_SEGMENT_X, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FIREBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SMOKEBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_REAR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.PIPING, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CYLINDER_SIDE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
        if (stock.isBuilt()) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawDrivingWheels(LocomotiveSteam stock, List<RenderComponent> wheels) {
        for (RenderComponent wheel : wheels) {
            double circumference = wheel.height() * 3.1415927410125732;
            double relDist = this.distanceTraveled % circumference;
            double wheelAngle = 360.0 * relDist / circumference;
            if (wheel.type == RenderComponentType.WHEEL_DRIVER_REAR_X) {
                wheelAngle += -45.0;
            }
            Vec3d wheelPos = wheel.center();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
            GlStateManager.func_179114_b((float)((float)wheelAngle), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
            this.drawComponent(wheel);
            GlStateManager.func_179121_F();
        }
    }

    private void drawBogies(EntityMoveableRollingStock stock) {
        Vec3d wheelPos;
        double relDist;
        double circumference;
        EntityRollingStockDefinition def = stock.getDefinition();
        RenderComponent frontBogey = def.getComponent(RenderComponentType.BOGEY_FRONT, stock.gauge);
        List<RenderComponent> frontBogeyWheels = def.getComponents(RenderComponentType.BOGEY_FRONT_WHEEL_X, stock.gauge);
        RenderComponent rearBogey = def.getComponent(RenderComponentType.BOGEY_REAR, stock.gauge);
        List<RenderComponent> rearBogeyWheels = def.getComponents(RenderComponentType.BOGEY_REAR_WHEEL_X, stock.gauge);
        if (frontBogey != null) {
            Vec3d frontVec = frontBogey.center();
            Vec3d frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge)));
            Vec3d frontNext = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge) - 0.5));
            float frontWheelYaw = VecUtil.toYaw(frontPos.func_178788_d(frontNext));
            float frontYaw = VecUtil.toYaw(frontPos) + stock.field_70177_z + 180.0f;
            float frontPitch = -VecUtil.toPitch(VecUtil.rotateYaw(frontPos, stock.field_70177_z + 180.0f)) + 90.0f + stock.field_70125_A;
            GL11.glPushMatrix();
            GL11.glRotated((double)frontYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)frontPitch, (double)0.0, (double)0.0, (double)1.0);
            if (frontPos.func_72438_d(frontNext) > 0.1) {
                GL11.glTranslated((double)frontVec.field_72450_a, (double)frontVec.field_72448_b, (double)frontVec.field_72449_c);
                GL11.glRotated((double)(frontWheelYaw + stock.field_70177_z - frontYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)(-frontVec.field_72450_a), (double)(-frontVec.field_72448_b), (double)(-frontVec.field_72449_c));
            }
            this.drawComponent(frontBogey);
            if (frontBogeyWheels != null) {
                for (RenderComponent wheel : frontBogeyWheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GL11.glRotatef((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        if (rearBogey != null) {
            Vec3d rearVec = rearBogey.center();
            EntityMoveableRollingStock.PosRot rearPos = stock.predictRearBogeyPosition((float)(-rearVec.field_72450_a - (double)def.getBogeyRear(stock.gauge)));
            EntityMoveableRollingStock.PosRot rearNext = stock.predictRearBogeyPosition((float)(-rearVec.field_72450_a - (double)def.getBogeyRear(stock.gauge) - 0.5));
            float rearWheelYaw = VecUtil.toYaw(rearPos.func_178788_d(rearNext));
            float rearYaw = VecUtil.toYaw(rearPos) + stock.field_70177_z;
            float rearPitch = VecUtil.toPitch(VecUtil.rotateYaw(rearPos, stock.field_70177_z + 180.0f)) - 90.0f + stock.field_70125_A;
            GL11.glPushMatrix();
            GL11.glRotated((double)rearYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rearPitch, (double)0.0, (double)0.0, (double)1.0);
            if (rearPos.func_72438_d(rearNext) > 0.1) {
                GL11.glTranslated((double)rearVec.field_72450_a, (double)rearVec.field_72448_b, (double)rearVec.field_72449_c);
                GL11.glRotated((double)(rearWheelYaw + stock.field_70177_z - rearYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)(-rearVec.field_72450_a), (double)(-rearVec.field_72448_b), (double)(-rearVec.field_72449_c));
            }
            this.drawComponent(rearBogey);
            if (rearBogeyWheels != null) {
                for (RenderComponent wheel : rearBogeyWheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GL11.glRotatef((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void drawStephenson(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.field_72450_a - wheelCenter.field_72450_a;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        this.drawComponent(connectingRod);
        GL11.glPopMatrix();
        Vec3d drivingRodRotPoint = new Vec3d(drivingRod.max().field_72450_a - drivingRod.height() / 2.0, drivingRod.center().field_72448_b, drivingRod.max().field_72449_c);
        float drivingRodAngle = (float)Math.toDegrees(MathHelper.func_181159_b((double)connRodMovment.field_72449_c, (double)(drivingRod.length() - drivingRod.height())));
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        GL11.glTranslated((double)drivingRodRotPoint.field_72450_a, (double)drivingRodRotPoint.field_72448_b, (double)drivingRodRotPoint.field_72449_c);
        GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-drivingRodRotPoint.field_72450_a), (double)(-drivingRodRotPoint.field_72448_b), (double)(-drivingRodRotPoint.field_72449_c));
        this.drawComponent(drivingRod);
        GL11.glPopMatrix();
        double pistonDelta = connRodMovment.field_72450_a - connRodRadius;
        GL11.glPushMatrix();
        GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
        this.drawComponent(pistonRod);
        GL11.glPopMatrix();
    }

    private void drawT1(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.field_72450_a - wheelCenter.field_72450_a;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        this.drawComponent(connectingRod);
        GL11.glPopMatrix();
        Vec3d drivingRodRotPoint = new Vec3d(drivingRod.max().field_72450_a - drivingRod.height() / 2.0, drivingRod.center().field_72448_b, drivingRod.max().field_72449_c);
        float drivingRodAngle = (float)Math.toDegrees(MathHelper.func_181159_b((double)connRodMovment.field_72449_c, (double)(drivingRod.length() - drivingRod.height())));
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        GL11.glTranslated((double)drivingRodRotPoint.field_72450_a, (double)drivingRodRotPoint.field_72448_b, (double)drivingRodRotPoint.field_72449_c);
        GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-drivingRodRotPoint.field_72450_a), (double)(-drivingRodRotPoint.field_72448_b), (double)(-drivingRodRotPoint.field_72449_c));
        this.drawComponent(drivingRod);
        GL11.glPopMatrix();
        double pistonDelta = connRodMovment.field_72450_a - connRodRadius;
        GL11.glPushMatrix();
        GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
        this.drawComponent(pistonRod);
        GL11.glPopMatrix();
    }

    private RenderComponent requireComponent(LocomotiveSteamDefinition def, RenderComponentType rct, String side, Gauge gauge) {
        RenderComponent comp = def.getComponent(rct, side, gauge);
        if (comp == null) {
            ImmersiveRailroading.error("Missing component for %s: %s %s", new Object[]{def.name(), rct, side});
        }
        return comp;
    }

    private void drawWalschaerts(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos, boolean reverse) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        if (reverse) {
            wheelAngle -= 90.0;
        }
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        RenderComponent crossHead = this.requireComponent(def, RenderComponentType.UNION_LINK_SIDE, side, stock.gauge);
        RenderComponent combinationLever = this.requireComponent(def, RenderComponentType.COMBINATION_LEVER_SIDE, side, stock.gauge);
        RenderComponent returnCrank = this.requireComponent(def, RenderComponentType.ECCENTRIC_CRANK_SIDE, side, stock.gauge);
        RenderComponent returnCrankRod = this.requireComponent(def, RenderComponentType.ECCENTRIC_ROD_SIDE, side, stock.gauge);
        RenderComponent slottedLink = this.requireComponent(def, RenderComponentType.EXPANSION_LINK_SIDE, side, stock.gauge);
        RenderComponent radiusBar = this.requireComponent(def, RenderComponentType.RADIUS_BAR_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.field_72450_a - wheelCenter.field_72450_a;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        this.drawComponent(connectingRod);
        GL11.glPopMatrix();
        Vec3d drivingRodRotPoint = new Vec3d((reverse ? drivingRod.min() : drivingRod.max()).field_72450_a - drivingRod.height() / 2.0, drivingRod.center().field_72448_b, (reverse ? drivingRod.min() : drivingRod.max()).field_72449_c);
        float drivingRodAngle = (float)Math.toDegrees(MathHelper.func_181159_b((double)(reverse ? -connRodMovment.field_72449_c : connRodMovment.field_72449_c), (double)(drivingRod.length() - drivingRod.height())));
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
        GL11.glTranslated((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        GL11.glTranslated((double)drivingRodRotPoint.field_72450_a, (double)drivingRodRotPoint.field_72448_b, (double)drivingRodRotPoint.field_72449_c);
        GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-drivingRodRotPoint.field_72450_a), (double)(-drivingRodRotPoint.field_72448_b), (double)(-drivingRodRotPoint.field_72449_c));
        this.drawComponent(drivingRod);
        GL11.glPopMatrix();
        double pistonDelta = connRodMovment.field_72450_a - connRodRadius;
        GL11.glPushMatrix();
        GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
        this.drawComponent(pistonRod);
        this.drawComponent(crossHead);
        GL11.glPopMatrix();
        Vec3d returnCrankRotPoint = reverse ? returnCrank.min().func_72441_c(returnCrank.height() / 2.0, returnCrank.height() / 2.0, 0.0) : returnCrank.max().func_72441_c(-returnCrank.height() / 2.0, -returnCrank.height() / 2.0, 0.0);
        Vec3d wheelRotationOffset = reverse ? VecUtil.fromWrongYaw(returnCrankRotPoint.field_72450_a - wheelPos.field_72450_a, (float)wheelAngle) : VecUtil.fromWrongYaw(returnCrankRotPoint.field_72450_a - wheelPos.field_72450_a, (float)wheelAngle);
        Vec3d returnCrankOriginOffset = wheelPos.func_72441_c(wheelRotationOffset.field_72450_a, wheelRotationOffset.field_72449_c, 0.0);
        double returnCrankAngle = wheelAngle + 90.0 + 30.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)returnCrankOriginOffset.field_72450_a, (double)returnCrankOriginOffset.field_72448_b, (double)0.0);
        GL11.glRotated((double)returnCrankAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-returnCrankRotPoint.field_72450_a), (double)(-returnCrankRotPoint.field_72448_b), (double)0.0);
        this.drawComponent(returnCrank);
        GL11.glPopMatrix();
        double returnCrankLength = -(returnCrank.length() - returnCrank.height() / 2.0 - returnCrankRod.height() / 2.0);
        Vec3d returnCrankRotationOffset = VecUtil.fromWrongYaw(returnCrankLength, (float)returnCrankAngle + (float)(reverse ? 90 : -90));
        Vec3d returnCrankRodOriginOffset = returnCrankOriginOffset.func_72441_c(returnCrankRotationOffset.field_72450_a, returnCrankRotationOffset.field_72449_c, 0.0);
        Vec3d returnCrankRodRotPoint = reverse ? returnCrankRod.min().func_72441_c(returnCrankRod.height() / 2.0, returnCrankRod.height() / 2.0, 0.0) : returnCrankRod.max().func_72441_c(-returnCrankRod.height() / 2.0, -returnCrankRod.height() / 2.0, 0.0);
        double returnCrankRodLength = returnCrankRod.length() - returnCrankRod.height() / 2.0;
        double slottedLinkLowest = slottedLink.min().field_72448_b + slottedLink.width() / 2.0;
        double returnCrankRodFudge = reverse ? Math.abs(slottedLink.center().field_72450_a - (returnCrankRodOriginOffset.field_72450_a + returnCrankRodLength)) / 3.0 : Math.abs(slottedLink.center().field_72450_a - (returnCrankRodOriginOffset.field_72450_a - returnCrankRodLength)) / 3.0;
        float returnCrankRodRot = reverse ? -VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.field_72448_b + returnCrankRodFudge, 0.0, returnCrankRodLength)) : VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.field_72448_b + returnCrankRodFudge, 0.0, returnCrankRodLength));
        GL11.glPushMatrix();
        GL11.glTranslated((double)returnCrankRodOriginOffset.field_72450_a, (double)returnCrankRodOriginOffset.field_72448_b, (double)0.0);
        GL11.glRotated((double)returnCrankRodRot, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-returnCrankRodRotPoint.field_72450_a), (double)(-returnCrankRodRotPoint.field_72448_b), (double)0.0);
        this.drawComponent(returnCrankRod);
        GL11.glPopMatrix();
        Vec3d returnCrankRodRotationOffset = VecUtil.fromWrongYaw(returnCrankRodLength, returnCrankRodRot + (float)(reverse ? -90 : 90));
        Vec3d returnCrankRodFarPoint = returnCrankRodOriginOffset.func_72441_c(returnCrankRodRotationOffset.field_72450_a, returnCrankRodRotationOffset.field_72449_c, 0.0);
        Vec3d slottedLinkRotPoint = slottedLink.center();
        double slottedLinkRot = Math.toDegrees(MathHelper.func_181159_b((double)(-slottedLinkRotPoint.field_72450_a + returnCrankRodFarPoint.field_72450_a), (double)(slottedLinkRotPoint.field_72448_b - returnCrankRodFarPoint.field_72448_b)));
        GL11.glPushMatrix();
        GL11.glTranslated((double)slottedLinkRotPoint.field_72450_a, (double)slottedLinkRotPoint.field_72448_b, (double)0.0);
        GL11.glRotated((double)slottedLinkRot, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-slottedLinkRotPoint.field_72450_a), (double)(-slottedLinkRotPoint.field_72448_b), (double)0.0);
        this.drawComponent(slottedLink);
        GL11.glPopMatrix();
        float throttle = stock.getThrottle();
        double forwardMax = (slottedLink.min().field_72448_b - slottedLinkRotPoint.field_72448_b) * 0.4;
        double forwardMin = (slottedLink.max().field_72448_b - slottedLinkRotPoint.field_72448_b) * 0.65;
        double throttleSlotPos = 0.0;
        throttleSlotPos = throttle > 0.0f ? forwardMax * (double)throttle : forwardMin * (double)(-throttle);
        double radiusBarSliding = Math.sin(Math.toRadians(-slottedLinkRot)) * throttleSlotPos;
        Vec3d radiusBarClose = reverse ? radiusBar.min() : radiusBar.max();
        float raidiusBarAngle = reverse ? -(VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos)) + 90.0f) : VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos += slottedLinkRotPoint.field_72448_b - radiusBar.max().field_72448_b)) + 90.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)throttleSlotPos, (double)0.0);
        GL11.glTranslated((double)radiusBarSliding, (double)0.0, (double)0.0);
        GL11.glTranslated((double)radiusBarClose.field_72450_a, (double)radiusBarClose.field_72448_b, (double)0.0);
        GL11.glRotated((double)raidiusBarAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-radiusBarClose.field_72450_a), (double)(-radiusBarClose.field_72448_b), (double)0.0);
        this.drawComponent(radiusBar);
        GL11.glPopMatrix();
        Vec3d radiusBarFar = reverse ? radiusBar.max() : radiusBar.min();
        Vec3d radiusBarFarPoint = radiusBarFar.func_72441_c(radiusBarSliding + combinationLever.width() / 2.0, 0.0, 0.0);
        Vec3d combinationLeverRotPos = combinationLever.min().func_72441_c(combinationLever.width() / 2.0, combinationLever.width() / 2.0, 0.0);
        Vec3d delta = radiusBarFarPoint.func_178788_d(combinationLeverRotPos.func_72441_c(pistonDelta, 0.0, 0.0));
        float combinationLeverAngle = VecUtil.toWrongYaw(new Vec3d(delta.field_72450_a, 0.0, delta.field_72448_b));
        GL11.glPushMatrix();
        GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
        GL11.glTranslated((double)combinationLeverRotPos.field_72450_a, (double)combinationLeverRotPos.field_72448_b, (double)0.0);
        GL11.glRotated((double)combinationLeverAngle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-combinationLeverRotPos.field_72450_a), (double)(-combinationLeverRotPos.field_72448_b), (double)0.0);
        this.drawComponent(combinationLever);
        GL11.glPopMatrix();
    }
}

