/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.multiblock.SteamHammerMultiblock;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class SteamHammerRender
implements IMultiblockRender {
    private OBJRender renderer;
    private ArrayList<String> hammer;
    private ArrayList<String> rest;

    public SteamHammerRender() {
        try {
            this.renderer = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading:models/multiblocks/steam_hammer.obj"), -0.1f));
            this.hammer = new ArrayList();
            this.rest = new ArrayList();
            for (String group : this.renderer.model.groups()) {
                if (group.contains("Hammer")) {
                    this.hammer.add(group);
                    continue;
                }
                this.rest.add(group);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(TileMultiblock te, double x, double y, double z, float partialTicks) {
        GLBoolTracker tex = new GLBoolTracker(3553, this.renderer.hasTexture());
        this.renderer.bindTexture();
        SteamHammerMultiblock.SteamHammerInstance mb = (SteamHammerMultiblock.SteamHammerInstance)te.getMultiblock();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        GL11.glRotated((double)te.getRotation(), (double)0.0, (double)1.0, (double)0.0);
        this.renderer.drawGroups(this.rest);
        if (mb != null && mb.hasPower()) {
            if (te.getCraftProgress() != 0) {
                GL11.glTranslated((double)0.0, (double)(-Math.abs(((float)te.getRenderTicks() + partialTicks) % 10.0f - 5.0f) / 4.0f), (double)0.0);
            } else {
                GL11.glTranslated((double)0.0, (double)(-Math.abs(((float)te.getRenderTicks() + partialTicks) % 30.0f - 15.0f) / 14.0f), (double)0.0);
            }
        }
        this.renderer.drawGroups(this.hammer);
        GL11.glPopMatrix();
        this.renderer.restoreTexture();
        tex.restore();
    }
}

