/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.vecmath.SingularMatrixException;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class RailBuilderRender {
    private static DisplayListCache displayLists = new DisplayListCache();

    public static void renderRailBuilder(RailInfo info) {
        TrackModel model = DefinitionManager.getTrack(info.settings.track, info.settings.gauge.value());
        if (model == null) {
            return;
        }
        OBJRender trackRenderer = StockRenderCache.getTrackRenderer(model);
        Integer displayList = (Integer)displayLists.get(info.uniqueID);
        if (displayList == null) {
            if (!ClientProxy.renderCacheLimiter.canRender()) {
                return;
            }
            displayList = ClientProxy.renderCacheLimiter.newList(() -> {
                GL11.glPushMatrix();
                for (BuilderBase.VecYawPitch piece : info.getBuilder().getRenderData()) {
                    Matrix4 m = new Matrix4();
                    m.translate(piece.field_72450_a, piece.field_72448_b, piece.field_72449_c);
                    m.rotate(Math.toRadians(piece.getYaw()), 0.0, 1.0, 0.0);
                    m.rotate(Math.toRadians(piece.getPitch()), 1.0, 0.0, 0.0);
                    m.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                    if (piece.getLength() != -1.0f) {
                        m.scale((double)piece.getLength() / info.settings.gauge.scale(), 1.0, 1.0);
                    }
                    double scale = info.settings.gauge.scale();
                    m.scale(scale, scale, scale);
                    m.transpose();
                    FloatBuffer fbm = BufferUtils.createFloatBuffer((int)16);
                    fbm.put(new float[]{(float)m.m00, (float)m.m01, (float)m.m02, (float)m.m03, (float)m.m10, (float)m.m11, (float)m.m12, (float)m.m13, (float)m.m20, (float)m.m21, (float)m.m22, (float)m.m23, (float)m.m30, (float)m.m31, (float)m.m32, (float)m.m33});
                    fbm.flip();
                    GL11.glMultMatrix((FloatBuffer)fbm);
                    if (piece.getGroups().size() != 0) {
                        ArrayList<String> groups = new ArrayList<String>();
                        for (String baseGroup : piece.getGroups()) {
                            for (String groupName : trackRenderer.model.groups()) {
                                if (!groupName.contains(baseGroup)) continue;
                                groups.add(groupName);
                            }
                        }
                        trackRenderer.drawGroups(groups);
                    } else {
                        trackRenderer.draw();
                    }
                    try {
                        m.invert();
                        fbm = BufferUtils.createFloatBuffer((int)16);
                        fbm.put(new float[]{(float)m.m00, (float)m.m01, (float)m.m02, (float)m.m03, (float)m.m10, (float)m.m11, (float)m.m12, (float)m.m13, (float)m.m20, (float)m.m21, (float)m.m22, (float)m.m23, (float)m.m30, (float)m.m31, (float)m.m32, (float)m.m33});
                        fbm.flip();
                        GL11.glMultMatrix((FloatBuffer)fbm);
                    }
                    catch (SingularMatrixException e) {
                        GL11.glPopMatrix();
                        GL11.glPushMatrix();
                    }
                }
                GL11.glPopMatrix();
            });
            displayLists.put(info.uniqueID, displayList);
        }
        trackRenderer.bindTexture();
        Minecraft.func_71410_x().field_71424_I.func_76320_a("dl");
        GL11.glCallList((int)displayList);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        trackRenderer.restoreTexture();
    }
}

