/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty.opencomputers;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.thirdparty.CommonAPI;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RadioCtrlCardDriver
implements DriverItem {
    public boolean worksWith(ItemStack stack) {
        return stack != null && stack.func_77973_b() == IRItems.ITEM_RADIO_CONTROL_CARD;
    }

    public ManagedEnvironment createEnvironment(ItemStack stack, EnvironmentHost host) {
        World hostWorld = host.world();
        if (stack != null && stack.func_77973_b() == IRItems.ITEM_RADIO_CONTROL_CARD) {
            for (Object e : hostWorld.field_72996_f) {
                Locomotive train;
                if (!(e instanceof Locomotive) || !(train = (Locomotive)((Object)e)).getPersistentID().equals(UUID.fromString(stack.func_77978_p().func_74779_i("linked_uuid")))) continue;
                return new RadioCtrlCardManager(train, host.xPosition(), host.yPosition(), host.zPosition());
            }
        }
        return null;
    }

    public String slot(ItemStack stack) {
        return "card";
    }

    public int tier(ItemStack stack) {
        return 0;
    }

    public NBTTagCompound dataTag(ItemStack stack) {
        return null;
    }

    public class RadioCtrlCardManager
    extends AbstractManagedEnvironment {
        protected Vec3d cardPosition;
        protected CommonAPI api;
        protected ComponentConnector node;

        public RadioCtrlCardManager(Locomotive loco, double x, double y, double z) {
            this.cardPosition = new Vec3d(x, y, z);
            this.api = new CommonAPI(loco);
            this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("ir_remote_control", Visibility.Network).withConnector().create();
            this.setNode((Node)this.node);
        }

        public boolean canUpdate() {
            return false;
        }

        public void update() {
        }

        @Callback(doc="function(double) -- sets the locomotive throttle")
        public Object[] setThrottle(Context context, Arguments arguments) {
            if (this.radioDrain()) {
                this.api.setThrottle(arguments.checkDouble(0));
            }
            return null;
        }

        private boolean radioDrain() {
            if (this.api == null) {
                return false;
            }
            double distance = this.api.getPosition().func_72438_d(this.cardPosition);
            if (distance > (double)Config.ConfigBalance.RadioRange) {
                return false;
            }
            return this.node.tryChangeBuffer((double)(-Config.ConfigBalance.RadioCostPerMetre) * distance);
        }

        @Callback(doc="function(double) -- sets the locomotive brake")
        public Object[] setBrake(Context context, Arguments arguments) {
            if (this.radioDrain()) {
                this.api.setAirBrake(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function() -- fires the locomotive horn")
        public Object[] horn(Context context, Arguments arguments) {
            if (this.radioDrain()) {
                this.api.setHorn(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function() -- sets the locomotive bell")
        public Object[] bell(Context context, Arguments arguments) {
            if (this.radioDrain()) {
                this.api.setBell(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function():array -- returns the XYZ position of the locomotive")
        public Object[] getPos(Context context, Arguments args) {
            if (this.radioDrain()) {
                Vec3d pos = this.api.getPosition();
                return new Object[]{pos.field_72450_a, pos.field_72448_b, pos.field_72449_c};
            }
            return null;
        }

        @Callback(doc="function():araray -- returns the UUID of the bound loco")
        public Object[] getLinkUUID(Context context, Arguments args) {
            if (this.radioDrain()) {
                return new Object[]{this.api.getUniqueID()};
            }
            return new Object[]{null};
        }
    }
}

