/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderIterator;
import cam72cam.immersiverailroading.track.CubicCurve;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BuilderCubicCurve
extends BuilderIterator {
    private List<BuilderBase> subBuilders;
    private HashMap<Double, List<PosStep>> cache;

    public BuilderCubicCurve(RailInfo info, BlockPos pos) {
        this(info, pos, false);
    }

    @Override
    public List<BuilderBase> getSubBuilders() {
        return this.subBuilders;
    }

    public BuilderCubicCurve(RailInfo info, BlockPos pos, boolean endOfTrack) {
        super(info, pos, endOfTrack);
        CubicCurve curve = this.getCurve();
        List<CubicCurve> subCurves = curve.subsplit(158);
        if (subCurves.size() > 1) {
            this.subBuilders = new ArrayList<BuilderBase>();
            for (CubicCurve subCurve : subCurves) {
                Vec3d delta = info.placementInfo.placementPosition;
                if (pos.equals((Object)BlockPos.field_177992_a)) {
                    delta = delta.func_178788_d(new Vec3d((Vec3i)new BlockPos(info.placementInfo.placementPosition)));
                }
                PlacementInfo startPos = new PlacementInfo(subCurve.p1.func_178787_e(delta), info.placementInfo.direction, subCurve.angleStart(), subCurve.ctrl1.func_178787_e(delta));
                PlacementInfo endPos = new PlacementInfo(subCurve.p2.func_178787_e(delta), info.placementInfo.direction, subCurve.angleStop() + 180.0f, subCurve.ctrl2.func_178787_e(delta));
                RailInfo subInfo = new RailInfo(info.world, info.settings.withType(TrackItems.CUSTOM), startPos, endPos, SwitchState.NONE, SwitchState.NONE, 0.0);
                BlockPos sPos = new BlockPos(startPos.placementPosition);
                BuilderCubicCurve subBuilder = new BuilderCubicCurve(subInfo, sPos);
                if (this.subBuilders.size() != 0) {
                    for (TrackBase track : subBuilder.tracks) {
                        if (!(track instanceof TrackRail)) continue;
                        track.overrideParent(this.subBuilders.get(0).getParentPos());
                    }
                } else {
                    this.tracks = subBuilder.tracks;
                }
                this.subBuilders.add(subBuilder);
            }
        }
    }

    public CubicCurve getCurve() {
        Vec3d nextPos = new Vec3d((Vec3i)new BlockPos(VecUtil.fromYaw(this.info.settings.length, this.info.placementInfo.yaw + 45.0f)));
        boolean isDefault = this.info.customInfo.placementPosition.equals((Object)this.info.placementInfo.placementPosition);
        if (!isDefault) {
            nextPos = this.info.customInfo.placementPosition.func_178788_d(this.info.placementInfo.placementPosition);
        }
        double ctrlGuess = nextPos.func_72433_c() / 2.0;
        float angle = this.info.placementInfo.yaw;
        float angle2 = angle + 180.0f;
        if (!isDefault) {
            angle2 = this.info.customInfo.yaw;
        }
        Vec3d ctrl1 = VecUtil.fromYaw(ctrlGuess, angle);
        Vec3d ctrl2 = nextPos.func_178787_e(VecUtil.fromYaw(ctrlGuess, angle2));
        if (this.info.placementInfo.control != null) {
            ctrl1 = this.info.placementInfo.control.func_178788_d(this.info.placementInfo.placementPosition);
        }
        if (this.info.customInfo.control != null && !isDefault) {
            ctrl2 = this.info.customInfo.control.func_178788_d(this.info.placementInfo.placementPosition);
        }
        return new CubicCurve(Vec3d.field_186680_a, ctrl1, ctrl2, nextPos);
    }

    @Override
    public List<PosStep> getPath(double stepSize) {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        if (this.cache.containsKey(stepSize)) {
            return this.cache.get(stepSize);
        }
        ArrayList<PosStep> res = new ArrayList<PosStep>();
        CubicCurve curve = this.getCurve();
        curve = curve.subsplit(200).get(0);
        List<Vec3d> points = curve.toList(stepSize);
        for (int i = 0; i < points.size(); ++i) {
            Vec3d next;
            float pitch;
            float yaw;
            Vec3d p = points.get(i);
            if (points.size() == 1) {
                yaw = this.info.placementInfo.yaw;
                pitch = 0.0f;
            } else if (i == points.size() - 1) {
                next = points.get(i - 1);
                pitch = (float)Math.toDegrees(Math.atan2(next.field_72448_b - p.field_72448_b, next.func_72438_d(p)));
                yaw = curve.angleStop();
            } else if (i == 0) {
                next = points.get(i + 1);
                pitch = (float)(-Math.toDegrees(Math.atan2(next.field_72448_b - p.field_72448_b, next.func_72438_d(p))));
                yaw = curve.angleStart();
            } else {
                Vec3d prev = points.get(i - 1);
                Vec3d next2 = points.get(i + 1);
                pitch = (float)(-Math.toDegrees(Math.atan2(next2.field_72448_b - prev.field_72448_b, next2.func_72438_d(prev))));
                yaw = VecUtil.toYaw(points.get(i + 1).func_178788_d(points.get(i - 1)));
            }
            res.add(new PosStep(p, yaw, pitch));
        }
        this.cache.put(stepSize, res);
        return this.cache.get(stepSize);
    }

    @Override
    public int costTies() {
        if (this.subBuilders == null) {
            return super.costTies();
        }
        return this.subBuilders.stream().mapToInt(BuilderBase::costTies).sum();
    }

    @Override
    public int costRails() {
        if (this.subBuilders == null) {
            return super.costRails();
        }
        return this.subBuilders.stream().mapToInt(BuilderBase::costRails).sum();
    }

    @Override
    public int costBed() {
        if (this.subBuilders == null) {
            return super.costBed();
        }
        return this.subBuilders.stream().mapToInt(BuilderBase::costBed).sum();
    }

    @Override
    public int costFill() {
        if (this.subBuilders == null) {
            return super.costFill();
        }
        return this.subBuilders.stream().mapToInt(BuilderBase::costFill).sum();
    }

    @Override
    public void setDrops(List<ItemStack> drops) {
        if (this.subBuilders == null) {
            super.setDrops(drops);
        } else {
            this.subBuilders.get(0).setDrops(drops);
        }
    }

    @Override
    public boolean canBuild() {
        if (this.subBuilders == null) {
            return super.canBuild();
        }
        return this.subBuilders.stream().allMatch(BuilderBase::canBuild);
    }

    @Override
    public void build() {
        if (this.subBuilders == null) {
            super.build();
        } else {
            this.subBuilders.stream().forEach(BuilderBase::build);
        }
    }

    @Override
    public void clearArea() {
        if (this.subBuilders == null) {
            super.clearArea();
        } else {
            this.subBuilders.stream().forEach(BuilderBase::clearArea);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        if (this.subBuilders == null) {
            return super.getTracksForRender();
        }
        return this.subBuilders.subList(0, Math.min(this.subBuilders.size(), 3)).stream().map(BuilderBase::getTracksForRender).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        if (this.subBuilders == null) {
            return super.getRenderData();
        }
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        for (BuilderBase curve : this.subBuilders.subList(0, Math.min(this.subBuilders.size(), 3))) {
            Vec3d offset = new Vec3d((Vec3i)curve.pos.func_177973_b((Vec3i)this.pos));
            for (BuilderBase.VecYawPitch rd : curve.getRenderData()) {
                rd = (BuilderBase)this.new BuilderBase.VecYawPitch(rd.field_72450_a + offset.field_72450_a, rd.field_72448_b + offset.field_72448_b, rd.field_72449_c + offset.field_72449_c, rd.yaw, rd.pitch, rd.length, new String[0]);
                data.add(rd);
            }
        }
        return data;
    }
}

