/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTurnTable
extends BuilderBase {
    protected HashSet<Pair<Integer, Integer>> positions = new HashSet();
    private BlockPos offset;

    public BuilderTurnTable(RailInfo info, BlockPos pos) {
        super(info.withLength(Math.min(info.settings.length, (int)(30.0 * info.settings.gauge.scale()))), pos);
        this.offset = new BlockPos(0, 1, info.settings.length);
        this.offset = BlockUtil.rotateYaw(this.offset, info.placementInfo.facing());
        double radius = info.settings.length;
        for (double irad = 1.0; irad <= radius + 1.0; irad += 1.0) {
            for (double angle = 0.0; angle < 360.0; angle += 0.5) {
                Vec3d gagPos = VecUtil.fromYaw(irad, (float)angle);
                this.positions.add((Pair<Integer, Integer>)Pair.of((Object)((int)gagPos.field_72450_a), (Object)((int)gagPos.field_72449_c)));
            }
        }
        this.setParentPos(new BlockPos((Vec3i)this.offset.func_177977_b()));
        TrackRail main = new TrackRail(this, this.offset.func_177977_b());
        this.tracks.add(main);
        for (Pair<Integer, Integer> pair : this.positions) {
            double toCenter = new Vec3d((double)((Integer)pair.getLeft()).intValue(), 0.0, (double)((Integer)pair.getRight()).intValue()).func_72433_c();
            if (toCenter > (double)info.settings.length + 0.5) continue;
            if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                TrackGag tgu = new TrackGag(this, new BlockPos((Integer)pair.getLeft() + this.offset.func_177958_n(), this.offset.func_177956_o() - 1, (Integer)pair.getRight() + this.offset.func_177952_p()));
                if (toCenter > (double)info.settings.length - 0.5) {
                    tgu.setHeight(1.0f);
                    tgu.setFlexible();
                }
                this.tracks.add(tgu);
            }
            TrackGag tg = new TrackGag(this, new BlockPos((Integer)pair.getLeft() + this.offset.func_177958_n(), this.offset.func_177956_o(), (Integer)pair.getRight() + this.offset.func_177952_p()));
            tg.setHeight(1.0E-6f);
            tg.solidNotRequired = true;
            if (toCenter > (double)info.settings.length - 0.5) {
                tg.setHeight(0.0f);
            }
            if (toCenter > (double)info.settings.length - 1.5) {
                tg.setFlexible();
            }
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        float angle = 0.0f;
        while (angle < 360.0f) {
            Vec3d gagPos = VecUtil.rotateWrongYaw(new Vec3d(0.0, 0.0, (double)this.info.settings.length), angle - 90.0f);
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(gagPos.field_72450_a + (double)this.offset.func_177958_n(), gagPos.field_72448_b + (double)this.offset.func_177956_o(), gagPos.field_72449_c + (double)this.offset.func_177952_p(), -angle, new String[0]));
            angle = (float)((double)angle + 22.5);
        }
        angle = 22.5f * (float)this.info.tablePos - this.info.placementInfo.facing().func_185119_l();
        data.add((BuilderBase)this.new BuilderBase.VecYawPitch((double)this.offset.func_177958_n(), (double)this.offset.func_177956_o(), (double)this.offset.func_177952_p(), -angle, 0.0f, this.info.settings.length * 2, "RAIL_RIGHT", "RAIL_LEFT"));
        return data;
    }

    @Override
    public int costTies() {
        return MathHelper.func_76143_f((double)((double)(this.info.settings.length + 8) * Config.ConfigBalance.TieCostMultiplier));
    }

    @Override
    public int costRails() {
        return MathHelper.func_76143_f((double)((double)((this.info.settings.length + 8) * 2 / 3) * Config.ConfigBalance.RailCostMultiplier));
    }

    @Override
    public int costBed() {
        return MathHelper.func_76143_f((double)((double)this.tracks.size() / 2.0 * 0.1 * Config.ConfigBalance.BedCostMultiplier));
    }

    @Override
    public int costFill() {
        int fillCount = 0;
        for (TrackBase track : this.tracks) {
            if (track.rel.func_177956_o() == 1 || !BlockUtil.canBeReplaced(this.info.world, track.getPos().func_177977_b(), false)) continue;
            ++fillCount;
        }
        return MathHelper.func_76123_f((float)(this.info.settings.railBedFill.func_77973_b() != Items.field_190931_a ? (float)fillCount : 0.0f));
    }
}

