/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class TrackBase {
    public BuilderBase builder;
    protected BlockPos rel;
    private float bedHeight;
    private float railHeight;
    protected Block block;
    private boolean flexible = false;
    private BlockPos parent;
    public boolean solidNotRequired;

    public TrackBase(BuilderBase builder, BlockPos rel, Block block) {
        this.builder = builder;
        this.rel = rel;
        this.block = block;
    }

    public boolean isDownSolid() {
        BlockPos pos = this.getPos();
        return !Config.ConfigDamage.requireSolidBlocks || this.solidNotRequired || this.builder.info.world.func_180495_p(pos.func_177977_b()).func_185896_q() || BlockUtil.canBeReplaced(this.builder.info.world, pos.func_177977_b(), false) && this.builder.info.settings.railBedFill.func_77973_b() != Items.field_190931_a || BlockUtil.isIRRail(this.builder.info.world, pos.func_177977_b());
    }

    public boolean isOverTileRail() {
        return TileRail.get((IBlockAccess)this.builder.info.world, this.getPos()) != null && this instanceof TrackGag;
    }

    public boolean canPlaceTrack() {
        BlockPos pos = this.getPos();
        return this.isDownSolid() && (BlockUtil.canBeReplaced(this.builder.info.world, pos, this.flexible || this.builder.overrideFlexible) || this.isOverTileRail());
    }

    public TileEntity placeTrack(boolean actuallyPlace) {
        BlockPos pos = this.getPos();
        if (!actuallyPlace) {
            TileRailGag tr = new TileRailGag();
            tr.func_174878_a(pos);
            tr.func_145834_a(this.builder.info.world);
            if (this.parent != null) {
                tr.setParent(this.parent);
            } else {
                tr.setParent(this.builder.getParentPos());
            }
            tr.setRailHeight(this.getRailHeight());
            tr.setBedHeight(this.getBedHeight());
            return tr;
        }
        if (this.builder.info.settings.railBedFill.func_77973_b() != Items.field_190931_a && BlockUtil.canBeReplaced(this.builder.info.world, pos.func_177977_b(), false)) {
            this.builder.info.world.func_175656_a(pos.func_177977_b(), BlockUtil.itemToBlockState(this.builder.info.settings.railBedFill));
        }
        NBTTagCompound replaced = null;
        IBlockState state = this.builder.info.world.func_180495_p(pos);
        Block removed = state.func_177230_c();
        TileRailBase te = null;
        if (removed != null) {
            if (removed instanceof BlockRailBase) {
                te = TileRailBase.get((IBlockAccess)this.builder.info.world, pos);
                if (te != null) {
                    replaced = te.serializeNBT();
                }
            } else {
                removed.func_176226_b(this.builder.info.world, pos, state, 0);
            }
        }
        if (te != null) {
            te.setWillBeReplaced(true);
        }
        this.builder.info.world.func_180501_a(pos, this.getBlockState(), 3);
        if (te != null) {
            te.setWillBeReplaced(false);
        }
        TileRailBase tr = TileRailBase.get((IBlockAccess)this.builder.info.world, pos);
        tr.setReplaced(replaced);
        if (this.parent != null) {
            tr.setParent(this.parent);
        } else {
            tr.setParent(this.builder.getParentPos());
        }
        tr.setRailHeight(this.getRailHeight());
        tr.setBedHeight(this.getBedHeight());
        return tr;
    }

    public IBlockState getBlockState() {
        return this.block.func_176223_P();
    }

    public BlockPos getPos() {
        return this.builder.convertRelativePositions(this.rel);
    }

    public void setHeight(float height) {
        this.setBedHeight(height);
        this.setRailHeight(height);
    }

    public void setBedHeight(float height) {
        this.bedHeight = height;
    }

    public float getBedHeight() {
        return this.bedHeight;
    }

    public void setRailHeight(float height) {
        this.railHeight = height;
    }

    public float getRailHeight() {
        return this.railHeight;
    }

    public void setFlexible() {
        this.flexible = true;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void overrideParent(BlockPos blockPos) {
        this.parent = blockPos;
    }
}

