/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.library.ItemComponentType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BufferUtil {
    public static void writeString(ByteBuf buf, String val) {
        buf.writeInt(val.getBytes(StandardCharsets.UTF_8).length);
        buf.writeBytes(val.getBytes(StandardCharsets.UTF_8));
    }

    public static String readString(ByteBuf buf) {
        byte[] defBytes = new byte[buf.readInt()];
        buf.readBytes(defBytes);
        return new String(defBytes, StandardCharsets.UTF_8);
    }

    public static void writeFloat(ByteBuf buf, @Nullable Float frontYaw) {
        if (frontYaw != null) {
            BufferUtil.writeString(buf, frontYaw.toString());
        } else {
            BufferUtil.writeString(buf, "NULLFLOAT");
        }
    }

    @Nullable
    public static Float readFloat(ByteBuf buf) {
        String val = BufferUtil.readString(buf);
        if (!val.equals("NULLFLOAT")) {
            return Float.valueOf(Float.parseFloat(val));
        }
        return null;
    }

    public static void writeUUID(ByteBuf buf, @Nullable UUID val) {
        if (val != null) {
            BufferUtil.writeString(buf, val.toString());
        } else {
            BufferUtil.writeString(buf, "NULLUUID");
        }
    }

    @Nullable
    public static UUID readUUID(ByteBuf buf) {
        String val = BufferUtil.readString(buf);
        if (!val.equals("NULLUUID")) {
            return UUID.fromString(val);
        }
        return null;
    }

    public static void writeVec3d(ByteBuf buf, Vec3d val) {
        buf.writeDouble(val.field_72450_a);
        buf.writeDouble(val.field_72448_b);
        buf.writeDouble(val.field_72449_c);
    }

    public static Vec3d readVec3d(ByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void writePlayerPositions(ByteBuf buf, Map<UUID, Vec3d> passengerPositions) {
        buf.writeInt(passengerPositions.size());
        for (UUID entry : passengerPositions.keySet()) {
            BufferUtil.writeUUID(buf, entry);
            BufferUtil.writeVec3d(buf, passengerPositions.get(entry));
        }
    }

    public static Map<UUID, Vec3d> readPlayerPositions(ByteBuf buf) {
        HashMap<UUID, Vec3d> passengerPositions = new HashMap<UUID, Vec3d>();
        for (int itemCount = buf.readInt(); itemCount > 0; --itemCount) {
            UUID id = BufferUtil.readUUID(buf);
            Vec3d pos = BufferUtil.readVec3d(buf);
            passengerPositions.put(id, pos);
        }
        return passengerPositions;
    }

    public static void writeVec3i(ByteBuf buf, Vec3i pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    public static Vec3i readVec3i(ByteBuf buf) {
        return new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeItemComponentTypes(ByteBuf buf, List<ItemComponentType> items) {
        buf.writeInt(items.size());
        for (ItemComponentType item : items) {
            buf.writeInt(item.ordinal());
        }
    }

    public static List<ItemComponentType> readItemComponentTypes(ByteBuf buf) {
        ArrayList<ItemComponentType> items = new ArrayList<ItemComponentType>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            items.add(ItemComponentType.values()[buf.readInt()]);
        }
        return items;
    }

    public static void writeStaticPassengers(ByteBuf buffer, List<EntityRidableRollingStock.StaticPassenger> staticPassengers) {
        buffer.writeInt(staticPassengers.size());
        for (EntityRidableRollingStock.StaticPassenger pass : staticPassengers) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)pass.writeNBT());
        }
    }

    public static List<EntityRidableRollingStock.StaticPassenger> readStaticPassengers(ByteBuf buffer) {
        ArrayList<EntityRidableRollingStock.StaticPassenger> staticPassengers = new ArrayList<EntityRidableRollingStock.StaticPassenger>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            staticPassengers.add(new EntityRidableRollingStock.StaticPassenger(ByteBufUtils.readTag((ByteBuf)buffer)));
        }
        return staticPassengers;
    }
}

