/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackComponent;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.TrackDefinition;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderCrossing;
import cam72cam.immersiverailroading.track.BuilderCubicCurve;
import cam72cam.immersiverailroading.track.BuilderSlope;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.BuilderSwitch;
import cam72cam.immersiverailroading.track.BuilderTurn;
import cam72cam.immersiverailroading.track.BuilderTurnTable;
import cam72cam.immersiverailroading.util.PlacementInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class RailInfo {
    public final World world;
    public final RailSettings settings;
    public final PlacementInfo placementInfo;
    public final PlacementInfo customInfo;
    public final SwitchState switchState;
    public final SwitchState switchForced;
    public final double tablePos;
    public final String uniqueID;
    public Map<BlockPos, BuilderBase> builders = new HashMap<BlockPos, BuilderBase>();
    private double trackHeight = -1.0;

    public RailInfo(World world, RailSettings settings, PlacementInfo placementInfo, PlacementInfo customInfo, SwitchState switchState, SwitchState switchForced, double tablePos) {
        if (customInfo == null) {
            customInfo = placementInfo;
        }
        this.world = world;
        this.settings = settings;
        this.placementInfo = placementInfo;
        this.customInfo = customInfo;
        this.switchState = switchState;
        this.switchForced = switchForced;
        this.tablePos = tablePos;
        Object[] props = new Object[]{this.settings.type, this.settings.length, this.settings.quarters, this.settings.railBed, this.settings.gauge, this.settings.track, this.switchState, this.switchForced, this.tablePos, Float.valueOf(this.placementInfo.yaw), this.placementInfo.direction, Float.valueOf(this.customInfo.yaw), this.customInfo.direction};
        String id = Arrays.toString(props);
        if (!placementInfo.placementPosition.equals((Object)customInfo.placementPosition) || this.settings.posType != TrackPositionType.FIXED) {
            id = id + placementInfo.placementPosition.func_178788_d(customInfo.placementPosition);
        }
        if (placementInfo.control != null) {
            id = id + placementInfo.control;
        }
        if (customInfo.control != null) {
            id = id + customInfo.control;
        }
        this.uniqueID = id;
    }

    public RailInfo(World world, ItemStack settings, PlacementInfo placementInfo, PlacementInfo customInfo) {
        this(world, ItemTrackBlueprint.settings(settings), placementInfo, customInfo, SwitchState.NONE, SwitchState.NONE, 0.0);
    }

    public RailInfo(World world, BlockPos pos, NBTTagCompound nbt) {
        this(world, new RailSettings(nbt.func_74775_l("settings")), new PlacementInfo(nbt.func_74775_l("placement"), pos), new PlacementInfo(nbt.func_74775_l("custom"), pos), SwitchState.values()[nbt.func_74762_e("switchState")], SwitchState.values()[nbt.func_74762_e("switchForced")], nbt.func_74769_h("tablePos"));
    }

    public NBTTagCompound toNBT(BlockPos pos) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("settings", (NBTBase)this.settings.toNBT());
        nbt.func_74782_a("placement", (NBTBase)this.placementInfo.toNBT(pos));
        nbt.func_74782_a("custom", (NBTBase)this.customInfo.toNBT(pos));
        nbt.func_74768_a("switchState", this.switchState.ordinal());
        nbt.func_74768_a("switchForced", this.switchForced.ordinal());
        nbt.func_74780_a("tablePos", this.tablePos);
        return nbt;
    }

    public RailInfo clone() {
        return new RailInfo(this.world, this.settings, this.placementInfo, this.customInfo, this.switchState, this.switchForced, this.tablePos);
    }

    public RailInfo withLength(int length) {
        RailSettings settings = this.settings.withLength(length);
        return new RailInfo(this.world, settings, this.placementInfo, this.customInfo, this.switchState, this.switchForced, this.tablePos);
    }

    public RailInfo withType(TrackItems type) {
        RailSettings settings = this.settings.withType(type);
        return new RailInfo(this.world, settings, this.placementInfo, this.customInfo, this.switchState, this.switchForced, this.tablePos);
    }

    public BuilderBase getBuilder(BlockPos pos) {
        if (this.builders.containsKey(pos)) {
            return this.builders.get(pos);
        }
        this.builders.put(pos, this.constructBuilder(pos));
        return this.builders.get(pos);
    }

    private BuilderBase constructBuilder(BlockPos pos) {
        switch (this.settings.type) {
            case STRAIGHT: {
                return new BuilderStraight(this, pos);
            }
            case CROSSING: {
                return new BuilderCrossing(this, pos);
            }
            case SLOPE: {
                return new BuilderSlope(this, pos);
            }
            case TURN: {
                return new BuilderTurn(this, pos);
            }
            case SWITCH: {
                return new BuilderSwitch(this, pos);
            }
            case TURNTABLE: {
                return new BuilderTurnTable(this, pos);
            }
            case CUSTOM: {
                return new BuilderCubicCurve(this, pos);
            }
        }
        return null;
    }

    public BuilderBase getBuilder() {
        return this.getBuilder(BlockPos.field_177992_a);
    }

    public boolean build(EntityPlayer player) {
        BuilderBase builder = this.getBuilder(new BlockPos(this.placementInfo.placementPosition));
        if (player.func_184812_l_() && Config.ConfigDamage.creativePlacementClearsBlocks && !this.world.field_72995_K) {
            builder.clearArea();
        }
        if (builder.canBuild() && !this.world.field_72995_K) {
            if (player.func_184812_l_()) {
                builder.build();
                return true;
            }
            TrackDefinition def = this.getDefinition();
            ArrayList<MaterialManager> materials = new ArrayList<MaterialManager>();
            if (this.settings.railBed.func_77973_b() != Items.field_190931_a) {
                materials.add(new MaterialManager(builder.costBed(), arg_0 -> ((ItemStack)this.settings.railBed).func_77969_a(arg_0), this.settings.railBed));
            }
            if (this.settings.railBedFill.func_77973_b() != Items.field_190931_a) {
                materials.add(new MaterialManager(builder.costFill(), arg_0 -> ((ItemStack)this.settings.railBedFill).func_77969_a(arg_0), this.settings.railBedFill));
            }
            List<TrackDefinition.TrackMaterial> tieParts = def.materials.get((Object)TrackComponent.TIE);
            List<TrackDefinition.TrackMaterial> railParts = def.materials.get((Object)TrackComponent.RAIL);
            List<TrackDefinition.TrackMaterial> bedParts = def.materials.get((Object)TrackComponent.BED);
            if (tieParts != null) {
                for (TrackDefinition.TrackMaterial trackMaterial : tieParts) {
                    materials.add(new MaterialManager((int)Math.ceil((float)builder.costTies() * trackMaterial.cost), trackMaterial::matches, trackMaterial.examples()));
                }
            }
            if (railParts != null) {
                for (TrackDefinition.TrackMaterial trackMaterial : railParts) {
                    materials.add(new MaterialManager((int)Math.ceil((float)builder.costRails() * trackMaterial.cost), trackMaterial::matches, trackMaterial.examples()));
                }
            }
            if (bedParts != null) {
                for (TrackDefinition.TrackMaterial trackMaterial : bedParts) {
                    materials.add(new MaterialManager((int)Math.ceil((float)builder.costBed() * trackMaterial.cost), trackMaterial::matches, trackMaterial.examples()));
                }
            }
            boolean isOk = true;
            for (MaterialManager material : materials) {
                isOk &= material.checkMaterials(player);
            }
            if (!isOk) {
                return false;
            }
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            for (MaterialManager material : materials) {
                arrayList.addAll(material.useMaterials(player));
            }
            builder.setDrops(arrayList);
            builder.build();
            return true;
        }
        return false;
    }

    public TrackDefinition getDefinition() {
        return DefinitionManager.getTrack(this.settings.track);
    }

    public TrackModel getTrackModel() {
        return DefinitionManager.getTrack(this.settings.track, this.settings.gauge.value());
    }

    public double getTrackHeight() {
        if (this.trackHeight == -1.0) {
            TrackModel model = this.getTrackModel();
            this.trackHeight = model.getHeight();
        }
        return this.trackHeight;
    }

    private class MaterialManager {
        private final Function<ItemStack, Boolean> material;
        private final int count;
        private final ItemStack[] examples;

        MaterialManager(int count, Function<ItemStack, Boolean> material, ItemStack ... examples) {
            this.material = material;
            this.count = count;
            this.examples = examples;
        }

        public MaterialManager(int count, Function<ItemStack, Boolean> material, List<ItemStack> examples) {
            this(count, material, examples.toArray(new ItemStack[0]));
        }

        private boolean checkMaterials(EntityPlayer player) {
            int found = 0;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!this.material.apply(stack).booleanValue() || ItemGauge.has(stack) && ItemGauge.get(stack) != RailInfo.this.settings.gauge) continue;
                found += stack.func_190916_E();
            }
            if (found < this.count) {
                String example = Arrays.stream(this.examples).map(ItemStack::func_82833_r).collect(Collectors.joining(" | "));
                if (this.examples.length > 1) {
                    example = "[ " + example + " ]";
                }
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING.getMessage(this.count - found, example));
                return false;
            }
            return true;
        }

        private List<ItemStack> useMaterials(EntityPlayer player) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            int required = this.count;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                ItemStack copy;
                if (!this.material.apply(stack).booleanValue() || ItemGauge.has(stack) && ItemGauge.get(stack) != RailInfo.this.settings.gauge) continue;
                if (required > stack.func_190916_E()) {
                    required -= stack.func_190916_E();
                    copy = stack.func_77946_l();
                    copy.func_190920_e(stack.func_190916_E());
                    drops.add(copy);
                    stack.func_190920_e(0);
                    continue;
                }
                if (required == 0) continue;
                copy = stack.func_77946_l();
                copy.func_190920_e(required);
                drops.add(copy);
                stack.func_190920_e(stack.func_190916_E() - required);
                required = 0;
            }
            return drops;
        }
    }
}

